/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricThreshold;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.math.BigDecimal;

public final class FloatThreshold
extends MetricThreshold {
    private BigDecimal m_lowerThreshold = BigDecimal.ZERO;
    private BigDecimal m_upperThreshold = BigDecimal.ZERO;

    public FloatThreshold(NamedElement parent, IMetricDescriptor descriptor, BigDecimal lowerThreshold, BigDecimal upperThreshold, Severity severity) {
        super(parent, descriptor, severity);
        assert (lowerThreshold != null) : "Parameter 'lowerThreshold' of method 'FloatThreshold' must not be null";
        assert (upperThreshold != null) : "Parameter 'upperThreshold' of method 'FloatThreshold' must not be null";
        this.m_lowerThreshold = lowerThreshold;
        this.m_upperThreshold = upperThreshold;
    }

    public FloatThreshold(NamedElement parent, IMetricDescriptor descriptor, String encodedThresholds) {
        super(parent, descriptor, Severity.WARNING);
        assert (encodedThresholds != null && encodedThresholds.length() > 0) : "Parameter 'encodedThresholds' of method 'FloatThreshold' must not be empty";
        String[] thresholds = encodedThresholds.split(":");
        this.m_lowerThreshold = new BigDecimal(thresholds[0]);
        this.m_upperThreshold = new BigDecimal(thresholds[1]);
        if (thresholds.length > 2) {
            Severity severity = Severity.valueOf(thresholds[2]);
            this.setSeverity(severity);
        }
    }

    @Override
    public String getValue() {
        return String.format("%s:%s:%s", NumberUtility.formatLocaleIndependent((Number)this.m_lowerThreshold), NumberUtility.formatLocaleIndependent((Number)this.m_upperThreshold), this.getSeverity().name());
    }

    @Override
    public Number getLowerThreshold() {
        return this.m_lowerThreshold;
    }

    @Override
    public Number getUpperThreshold() {
        return this.m_upperThreshold;
    }

    @Override
    public void setLowerThreshold(Number n) {
        assert (n != null) : "Parameter 'n' of method 'setLowerThreshold' must not be null";
        this.m_lowerThreshold = new BigDecimal(n.toString());
    }

    @Override
    public void setUpperThreshold(Number n) {
        assert (n != null) : "Parameter 'n' of method 'setUpperThreshold' must not be null";
        this.m_upperThreshold = new BigDecimal(n.toString());
    }

    @Override
    public boolean isViolatedBy(Number value) {
        assert (value != null) : "Parameter 'value' of method 'isViolatedBy' must not be null";
        double v = value.doubleValue();
        return v < this.m_lowerThreshold.doubleValue() || v > this.m_upperThreshold.doubleValue();
    }
}

