/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;

public final class DynamicIssueType
extends IssueType {
    public static String createKey(IIssueId issueId, IProviderId providerId) {
        assert (issueId != null) : "Parameter 'issueId' of method 'createKey' must not be null";
        assert (providerId != null) : "Parameter 'providerId' of method 'createKey' must not be null";
        return issueId.getStandardName() + ":" + providerId.getStandardName();
    }

    public DynamicIssueType(NamedElement parent, IIssueId id, String key) {
        super(parent, id, key);
    }

    public String getIssueProviderIdStandardName() {
        String key = this.getKey();
        assert (key != null) : "'key' of method 'getAdditionalInformation' must not be null";
        int pos = key.lastIndexOf(":");
        assert (pos != -1) : "Invalid format: " + key;
        return key.substring(pos + ":".length());
    }

    @Override
    protected String getAdditionalInformation() {
        return this.getIssueProviderIdStandardName();
    }
}

