/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class CycleGroup
extends NamedElementContainer {
    private static final String IS_CRITICAL = "isCritical";
    private static final String FQ_NAME_PART = "fqNamePart";
    private static final String NEEDS_SORTING = "needsSorting";
    private volatile boolean m_needsSorting;
    private String m_fqNamePart;
    private boolean m_isCritical;

    protected CycleGroup(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeBoolean(NEEDS_SORTING, this.m_needsSorting);
        writer.writeString(FQ_NAME_PART, this.m_fqNamePart);
        writer.writeBoolean(IS_CRITICAL, this.m_isCritical);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_needsSorting = reader.readBoolean(NEEDS_SORTING);
        this.m_fqNamePart = reader.readString(FQ_NAME_PART);
        this.m_isCritical = reader.readBoolean(IS_CRITICAL);
    }

    protected CycleGroup(NamedElement parent, boolean isCritical) {
        super(parent);
        this.m_isCritical = isCritical;
    }

    @Override
    public final String getImageResourceName() {
        return CycleGroup.class.getSimpleName();
    }

    public final boolean isCritical() {
        return this.m_isCritical;
    }

    @Override
    public final synchronized void addChild(NamedElement child) {
        assert (child != null && child instanceof NamedElementProxy) : "Unexpected class in method 'addChild': " + String.valueOf(child);
        super.addChild(child);
    }

    public final synchronized void addCyclicElement(NamedElement cyclicElement) {
        assert (cyclicElement != null) : "Parameter 'cyclicElement' of method 'add' must not be null";
        this.addChild(new NamedElementProxy(this, cyclicElement));
        this.m_needsSorting = true;
    }

    @Override
    public IDomainRoot.Domain getDomain() {
        ArrayList<NamedElement> children = this.getModifiableChildrenList();
        if (children != null && !children.isEmpty()) {
            return ((NamedElement)children.get(0)).getDomain();
        }
        return null;
    }

    @Property
    public final int getNumberOfCyclicElements() {
        return this.getChildren().size();
    }

    public final synchronized Set<NamedElement> getCyclicNamedElements() {
        if (this.hasChildren()) {
            List<NamedElement> cyclicElements;
            if (this.m_needsSorting) {
                this.m_needsSorting = false;
                cyclicElements = this.getModifiableChildrenList();
                cyclicElements.sort(new Comparator<NamedElement>(){

                    @Override
                    public int compare(NamedElement ne1, NamedElement ne2) {
                        if (!($assertionsDisabled || ne1 != null && ne1 instanceof NamedElementProxy)) {
                            throw new AssertionError((Object)("Unexpected class in method 'compare': " + String.valueOf(ne1)));
                        }
                        if (!($assertionsDisabled || ne2 != null && ne2 instanceof NamedElementProxy)) {
                            throw new AssertionError((Object)("Unexpected class in method 'compare': " + String.valueOf(ne2)));
                        }
                        return ne1.getElement().getFullyQualifiedName().compareTo(ne2.getElement().getFullyQualifiedName());
                    }
                });
            }
            cyclicElements = this.getChildren().stream().map(c -> c.getElement()).collect(Collectors.toList());
            return new LinkedHashSet<NamedElement>(cyclicElements);
        }
        return Collections.emptySet();
    }

    public final Collection<String> getFullyQualifiedNamesOfInvolvedElements() {
        LinkedHashSet<String> fqNames = new LinkedHashSet<String>();
        for (NamedElement nextCyclic : this.getCyclicNamedElements()) {
            fqNames.add(nextCyclic.getFullyQualifiedName());
        }
        return fqNames;
    }

    @Override
    public final String getFullyQualifiedNamePart() {
        if (this.m_fqNamePart == null) {
            StringBuilder sb = new StringBuilder();
            for (String next : this.getFullyQualifiedNamesOfInvolvedElements()) {
                sb.append(next);
            }
            this.m_fqNamePart = HashSupport.MD5.getHexString(sb.toString());
        }
        return this.m_fqNamePart;
    }
}

