/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IRepresentedNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

public final class GraphNode<T extends IRepresentedNode<T>>
implements INode<T> {
    private final ArrayList<GraphEdge> m_edges = new ArrayList();
    private final T m_representedObject;

    public GraphNode(T object) {
        assert (object != null) : "Parameter 'object' of method 'GraphNode' must not be null";
        this.m_representedObject = object;
    }

    private void addEdge(GraphEdge edge) {
        assert (edge != null) : "Parameter 'edge' of method 'addEdge' must not be null";
        this.m_edges.add(edge);
    }

    public void connectTo(GraphNode<T> node) {
        assert (node != null) : "Parameter 'node' of method 'connectTo' must not be null";
        new GraphEdge(this, node);
    }

    @Override
    public String getName() {
        return this.m_representedObject.getName();
    }

    @Override
    public T getUnderlyingObject() {
        return this.m_representedObject;
    }

    @Override
    public Collection<? extends INode.IEdge> getIncomingEdges() {
        return this.m_edges.stream().filter(edge -> edge.getTo() == this).collect(Collectors.toList());
    }

    @Override
    public Collection<? extends INode.IEdge> getOutgoingEdges() {
        return this.m_edges.stream().filter(edge -> edge.getFrom() == this).collect(Collectors.toList());
    }

    public void finishModification() {
        this.m_edges.trimToSize();
    }

    public class GraphEdge
    implements INode.IEdge {
        private final GraphNode<T> m_from;
        private final GraphNode<T> m_to;

        private GraphEdge(GraphNode<T> from, GraphNode<T> to) {
            assert (from != null) : "Parameter 'from' of method 'GraphEdge' must not be null";
            assert (to != null) : "Parameter 'to' of method 'GraphEdge' must not be null";
            this.m_from = from;
            this.m_to = to;
            this.m_from.addEdge(this);
            if (this.m_from != this.m_to) {
                this.m_to.addEdge(this);
            }
        }

        public INode<T> getFrom() {
            return this.m_from;
        }

        public INode<T> getTo() {
            return this.m_to;
        }

        @Override
        public int getWeight() {
            return 1;
        }
    }

    public static interface NodeMapper<T extends IRepresentedNode<T>> {
        public GraphNode<T> getNodeFor(T var1);
    }
}

