/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.sonargraph.foundation.utilities.CommonResourceProviderAdapter;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderAdapter;
import com.hello2morrow.sonargraph.license.foundation.LicenseResourceProviderAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CoreResourceProviderAdapter
extends ResourceProviderAdapter {
    public static final String BUNDLE_ID = "com.hello2morrow.sonargraph.core";
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreResourceProviderAdapter.class);
    private static CoreResourceProviderAdapter s_instance;
    private String m_userHomeDirectoryPath;
    private TFile m_userHomeDirectory;

    private CoreResourceProviderAdapter() {
        super(new String[]{"", "images"}, "CoreResourceBundle", new ResourceProviderAdapter[]{CommonResourceProviderAdapter.getInstance(), LicenseResourceProviderAdapter.getInstance()});
    }

    public static CoreResourceProviderAdapter getInstance() {
        if (s_instance == null) {
            s_instance = new CoreResourceProviderAdapter();
        }
        return s_instance;
    }

    public void setSonargraphUserHomeDir(String userHomeDirectoryPath) {
        if (userHomeDirectoryPath != null) {
            assert (userHomeDirectoryPath.length() > 0) : "Parameter 'userHomeDirectoryPath' of method 'setSonargraphUserHomeDir' must not be empty";
            this.m_userHomeDirectoryPath = userHomeDirectoryPath;
        } else {
            this.m_userHomeDirectoryPath = null;
        }
        this.m_userHomeDirectory = null;
    }

    public TFile getSonargraphUserHomeDir() {
        if (this.m_userHomeDirectory != null) {
            return this.m_userHomeDirectory;
        }
        if (this.m_userHomeDirectoryPath == null) {
            String appDataDir;
            String userHome = System.getProperty("user.home");
            if (Platform.isWindows()) {
                String appDataEnvVar = System.getenv("APPDATA");
                if (appDataEnvVar != null) {
                    appDataDir = String.format("%s\\hello2morrow\\Sonargraph", appDataEnvVar);
                } else {
                    LOGGER.error("Environment variable APPDATA is not set");
                    appDataDir = String.format("%s\\AppData\\Roaming\\hello2morrow\\Sonargraph", userHome);
                }
            } else {
                appDataDir = Platform.isMac() ? String.format("%s/Library/Application Support/hello2morrow/Sonargraph", userHome) : String.format("%s/.hello2morrow/Sonargraph", userHome);
            }
            this.m_userHomeDirectoryPath = appDataDir;
        }
        this.m_userHomeDirectory = new TFile(this.m_userHomeDirectoryPath);
        if (!this.m_userHomeDirectory.exists() && !this.m_userHomeDirectory.mkdirs()) {
            LOGGER.error("Failed to create directory '" + this.m_userHomeDirectory.getAbsolutePath() + "'.");
        }
        return this.m_userHomeDirectory;
    }

    public TFile getProductsConfigurationDirectory() {
        TFile dir = new TFile((File)this.getSonargraphUserHomeDir(), "Configuration");
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.error("Failed to create directory '" + dir.getAbsolutePath() + "'.");
        }
        return dir;
    }
}

