/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.controller.system.representation.FocusModeCollector;
import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.programming.EndpointType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.representation.FocusMode;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class OnlyVisibleCollector
extends FocusModeCollector {
    private final Set<ProgrammingElement> m_allProgrammingElements;

    public OnlyVisibleCollector(SoftwareSystem softwareSystem, Set<NamedElement> mainNodes, Set<NamedElement> additionalNodes, Set<OnDemandCycleGroup> cycleNodes, Set<ProgrammingElement> programmingElementsForMainNodes, Set<ProgrammingElement> programmingElementsForAdditionalNodes, Map<NamedElement, NamedElement> namedElementToProxy, Set<CoreParserDependencyType> dependencyTypes, IDomainRoot.Domain domain, FocusMode mode, PresentationMode presentationMode, boolean collectProgrammingElements, boolean dontCollectTypesRecursively, EndpointType endpointType) {
        super(softwareSystem, mainNodes, additionalNodes, cycleNodes, namedElementToProxy, dependencyTypes, domain, mode, presentationMode, collectProgrammingElements, dontCollectTypesRecursively, endpointType);
        assert (programmingElementsForMainNodes != null) : "Parameter 'programmingElementsForMainNodes' of method 'OnlyVisibleNotTransitiveCollector' must not be null";
        assert (programmingElementsForAdditionalNodes != null) : "Parameter 'programmingElementsForAdditionalNodes' of method 'OnlyVisibleNotTransitiveCollector' must not be null";
        this.m_allProgrammingElements = new HashSet<ProgrammingElement>(programmingElementsForMainNodes);
        this.m_allProgrammingElements.addAll(programmingElementsForAdditionalNodes);
    }

    @Override
    public final boolean addDependency(NamedElement from, NamedElement to, Dependency dependency) {
        assert (from != null) : "Parameter 'from' of method 'addDependency' must not be null";
        assert (to != null) : "Parameter 'to' of method 'addDependency' must not be null";
        if (this.addDependencyFromCycleNode(from, to, dependency)) {
            return true;
        }
        if (!this.checkForFocusModes() || super.addDependency(from, to, dependency)) {
            boolean checkForParserDependencies;
            boolean bl = checkForParserDependencies = dependency != null && dependency instanceof ParserDependency;
            if (checkForParserDependencies) {
                assert (dependency != null);
                ParserDependency parserDependency = (ParserDependency)dependency;
                return this.m_allProgrammingElements.contains(parserDependency.getFrom()) && this.m_allProgrammingElements.contains(parserDependency.getTo());
            }
            return true;
        }
        return false;
    }

    protected abstract boolean checkForFocusModes();
}

