/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignedToplevelNodesCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FindElementsInArchitectureFile;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FocusHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StateHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureHandler;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.LibraryComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.LogicalNamespaceContainer;
import com.hello2morrow.sonargraph.core.model.architecture.RecursiveElementComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.RootDirectoryPathComponentContainer;
import com.hello2morrow.sonargraph.core.model.architecture.UnassignedElements;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ComponentNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ComponentStructureNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.IAssignableContainer;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNonRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveRootNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ReadOnlyArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ResetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.TopLevelLogicalProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureFileBasedCreator
extends ArchitecturalViewNodeCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureFileBasedCreator.class);
    private static final List<Class<?>> CLASSES = Arrays.asList(Artifact.class, ArchitectureElementContainer.class, AssignedElement.class, SourceFile.class);
    private static final List<Class<?>> CLASSES_NON_EMPTY = Arrays.asList(UnassignedElements.class);
    private ProgrammingElementAggregatingNode m_leafNode;

    public ArchitectureFileBasedCreator(IWorkerContext workerContext, ExplorationViewRepresentation representation) {
        super(workerContext, representation);
    }

    private static boolean canHandle(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeElement' must not be null";
        Class<?> elementClass = element.getClass();
        for (Class<?> nextClass : CLASSES_NON_EMPTY) {
            if (!nextClass.isAssignableFrom(elementClass)) continue;
            return !element.getAllChildren().isEmpty();
        }
        for (Class<?> nextClass : CLASSES) {
            if (!nextClass.isAssignableFrom(elementClass)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCreatePossible(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'isCreatePossible' must not be null";
        return architectureFile.isChecked() && architectureFile.modelLoaded();
    }

    public static ArchitectureFile isCreateExplorationViewOnDemandPossible(NamedElement element, Set<NamedElement> select, Map<NamedElement, Artifact> artifactMapping) {
        ArchitectureFile architectureFile;
        assert (element != null) : "Parameter 'element' of method 'isCreateExplorationViewOnDemandPossible' must not be null";
        assert (select != null) : "Parameter 'select' of method 'isCreateExplorationViewOnDemandPossible' must not be null";
        if (element instanceof ArchitectureFile) {
            if (!ArchitectureFileBasedCreator.isCreatePossible((ArchitectureFile)element)) {
                return null;
            }
            return (ArchitectureFile)element;
        }
        if (ArchitecturalViewNodeCreator.canBeShownInExplorationView(element) && ArchitectureFileBasedCreator.canHandle(element) && (architectureFile = element.getParent(ArchitectureFile.class, new Class[0])) != null) {
            if (element instanceof AssignedElement) {
                select.add(((AssignedElement)element).getAssignable().getNamedElement());
                artifactMapping.put(((AssignedElement)element).getAssignable().getNamedElement(), ((AssignedElement)element).getParent(Artifact.class, ArchitectureFile.class));
            } else if (element instanceof UnassignedElements) {
                for (NamedElement nextChild : element.getChildren(NamedElement.class)) {
                    if (!ArchitecturalViewNodeCreator.canBeShownInExplorationView(nextChild) || !ArchitectureFileBasedCreator.canHandle(nextChild) || !(nextChild instanceof ArchitectureElementContainer)) continue;
                    select.add((NamedElement)((ArchitectureElementContainer)nextChild).getRepresentedElement());
                    artifactMapping.put((NamedElement)((ArchitectureElementContainer)nextChild).getRepresentedElement(), (Artifact)null);
                }
            } else if (element instanceof ArchitectureElementContainer) {
                select.add((NamedElement)((ArchitectureElementContainer)element).getRepresentedElement());
                artifactMapping.put((NamedElement)((ArchitectureElementContainer)element).getRepresentedElement(), ((ArchitectureElementContainer)element).getParent(Artifact.class, ArchitectureFile.class));
            } else if (element instanceof Artifact) {
                select.add(element);
                artifactMapping.put(element, null);
            } else {
                return null;
            }
            return architectureFile;
        }
        return null;
    }

    public static Map<NamedElement, Artifact> getArtifactMapping(Set<NamedElement> elements, ArchitectureFile architectureFile) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'getArtifactMapping' must not be empty";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getArtifactMapping' must not be null";
        assert (architectureFile.isChecked() && architectureFile.modelLoaded()) : "'architectureFile' must be checked and model loaded: " + String.valueOf(architectureFile);
        THashMap collector = new THashMap();
        FindElementsInArchitectureFile find = new FindElementsInArchitectureFile(elements, (Map<NamedElement, NamedElement>)collector);
        architectureFile.accept(find);
        if (collector.isEmpty()) {
            return Collections.emptyMap();
        }
        THashMap mapping = new THashMap(collector.size());
        for (Map.Entry nextEntry : collector.entrySet()) {
            Artifact artifact = ((NamedElement)nextEntry.getKey()).getParent(Artifact.class, ArchitectureFile.class);
            mapping.put((NamedElement)nextEntry.getValue(), artifact);
        }
        return mapping;
    }

    public static List<? extends NamedElement> getTopLevelElements(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getTopLevelElements' must not be null";
        assert (architectureFile.isChecked()) : "Not checked: " + architectureFile.getIdentifyingPath();
        assert (architectureFile.modelLoaded()) : "Model not loaded: " + architectureFile.getIdentifyingPath();
        return architectureFile.getChildren(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                return namedElement instanceof Artifact || namedElement instanceof UnassignedElements;
            }
        }, NamedElement.class);
    }

    private static void resetStructure(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'resetStructure' must not be null";
        LOGGER.debug("Reset structure");
        List<ReadOnlyArtifactNode> topLevelArtifacts = representation.getChildren(ReadOnlyArtifactNode.class);
        if (!topLevelArtifacts.isEmpty()) {
            List<NonRecursiveRootNode> assignedTopLevelNodes = AssignedToplevelNodesCollector.collect(topLevelArtifacts);
            assignedTopLevelNodes.forEach(n -> StructureHandler.integrate(n, representation, null, true, representation));
            topLevelArtifacts.forEach(n -> n.remove());
        }
        LOGGER.debug("Reset structure");
    }

    private static boolean includeArtifact(Artifact artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'includeArtifact' must not be null";
        return !artifact.isDeprecated() || artifact.getNumberOfAssignedElements() > 0 || artifact.hasChildren(false, Artifact.class);
    }

    private static void processArtifact(ArchitecturalViewElement parent, Artifact artifact, Map<Artifact, ReadOnlyArtifactNode> artifactsToNode, ExplorationViewRepresentation representation) {
        assert (parent != null) : "Parameter 'parent' of method 'processArtifact' must not be null";
        assert (artifact != null) : "Parameter 'artifact' of method 'processArtifact' must not be null";
        assert (artifactsToNode != null) : "Parameter 'artifactsToNode' of method 'processArtifact' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'processArtifact' must not be null";
        if (ArchitectureFileBasedCreator.includeArtifact(artifact)) {
            ReadOnlyArtifactNode artifactNode = new ReadOnlyArtifactNode(parent, representation.getPresentationMode(), ArchitectureFileBasedCreator.createArtifactProperties(artifact), artifact);
            parent.addChild(artifactNode, ReadOnlyArtifactNode.class);
            artifactsToNode.put(artifact, artifactNode);
            for (Artifact nextChildArtifact : artifact.getChildren(Artifact.class)) {
                ArchitectureFileBasedCreator.processArtifact(artifactNode, nextChildArtifact, artifactsToNode, representation);
            }
        }
    }

    private static void collectLogicalGroupRecursively(LogicalProgrammingElement element, Collection<ProgrammingElement> collector) {
        assert (element != null) : "Parameter 'element' of method 'collectLogicalGroupRecursively' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectLogicalGroupRecursively' must not be null";
        collector.addAll(element.getProgrammingElements());
        for (LogicalProgrammingElement nextChildElement : element.getChildren(LogicalProgrammingElement.class)) {
            ArchitectureFileBasedCreator.collectLogicalGroupRecursively(nextChildElement, collector);
        }
    }

    private static void applyModifications(ArchitectureFile architectureFile, ExplorationViewRepresentation representation) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'applyModifications' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'applyModifications' must not be null";
        LOGGER.debug("Apply modifications");
        THashMap artifactsToNode = new THashMap();
        for (Artifact artifact : architectureFile.getChildren(Artifact.class)) {
            ArchitectureFileBasedCreator.processArtifact(representation, artifact, (Map<Artifact, ReadOnlyArtifactNode>)artifactsToNode, representation);
        }
        if (representation.getStructureMode().isPhysical()) {
            LOGGER.debug("Apply modifications - physical");
            for (Map.Entry entry : artifactsToNode.entrySet()) {
                Artifact nextArtifact = (Artifact)entry.getKey();
                Collection<IAssignableToArtifact> nextAssignedElements = nextArtifact.getAssignedElements();
                LOGGER.debug("Collect assignables for '" + nextArtifact.getName() + "': " + nextAssignedElements.size());
                ArrayList<Object> assign = new ArrayList<Object>(nextAssignedElements.size());
                block2: for (IAssignableToArtifact nextAssigned : nextAssignedElements) {
                    ArchitecturalViewNode nextLeafNode;
                    assert (nextAssigned != null && nextAssigned instanceof IComponent) : "Unexpected class in method 'applyModifications': " + String.valueOf(nextAssigned);
                    boolean nextHasBeenAssigned = false;
                    NamedElement nextUnderlyingNamedElement = nextAssigned.getNamedElement();
                    if (nextUnderlyingNamedElement instanceof ProgrammingElement && (nextLeafNode = representation.getLeafNode((ProgrammingElement)nextUnderlyingNamedElement)) != null) {
                        AssignableToArtifactNode nextAssignableToArtifactNode = nextLeafNode.getParent(AssignableToArtifactNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        assert (nextAssignableToArtifactNode != null) : "'nextAssignableToArtifactNode' of method 'process' must not be null";
                        assign.add(nextAssignableToArtifactNode);
                        nextHasBeenAssigned = true;
                    }
                    if (nextHasBeenAssigned) continue;
                    for (ProgrammingElement nextProgrammingElement : nextUnderlyingNamedElement.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                        ArchitecturalViewNode nextLeafNode2 = representation.getLeafNode(nextProgrammingElement);
                        if (nextLeafNode2 == null) continue;
                        AssignableToArtifactNode nextAssignableToArtifactNode = nextLeafNode2.getParent(AssignableToArtifactNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        assert (nextAssignableToArtifactNode != null) : "'nextAssignableToArtifactNode' of method 'process' must not be null";
                        assign.add(nextAssignableToArtifactNode);
                        continue block2;
                    }
                }
                LOGGER.debug("Collect assignables for '" + nextArtifact.getName() + "': " + nextAssignedElements.size() + " - done");
                if (assign.isEmpty()) continue;
                LOGGER.debug("Assign");
                StructureHandler.assign(null, assign, (IAssignableContainer)entry.getValue(), representation);
                LOGGER.debug("Assign - done");
            }
        } else {
            LOGGER.debug("Apply modifications - logical");
            assert (representation.getStructureMode().isLogical()) : "Representation not logical";
            for (Map.Entry entry : artifactsToNode.entrySet()) {
                ArrayList<AssignableToArtifactNode> assign = new ArrayList<AssignableToArtifactNode>();
                block5: for (IAssignableToArtifact nextAssigned : ((Artifact)entry.getKey()).getAssignedElements()) {
                    NamedElement nextAssignedLogical = nextAssigned.getNamedElement();
                    assert (nextAssignedLogical != null && nextAssignedLogical instanceof LogicalProgrammingElement) : "Unexpected class in method 'applyModifications': " + String.valueOf(nextAssignedLogical);
                    ArrayList<ProgrammingElement> nextProgrammingElements = new ArrayList<ProgrammingElement>();
                    ArchitectureFileBasedCreator.collectLogicalGroupRecursively((LogicalProgrammingElement)nextAssignedLogical, nextProgrammingElements);
                    for (ProgrammingElement nextProgrammingElement : nextProgrammingElements) {
                        ArchitecturalViewNode nextLeafNode = representation.getLeafNode(nextProgrammingElement);
                        if (nextLeafNode == null) continue;
                        AssignableToArtifactNode nextAssignableToArtifactNode = nextLeafNode.getParent(AssignableToArtifactNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        assert (nextAssignableToArtifactNode != null) : "Parameter 'nextAssignableToArtifactNode' of method 'process' must not be null";
                        assign.add(nextAssignableToArtifactNode);
                        continue block5;
                    }
                }
                if (assign.isEmpty()) continue;
                StructureHandler.assign(null, assign, (IAssignableContainer)entry.getValue(), representation);
            }
        }
        LOGGER.debug("Apply modifications - done");
    }

    public static void processModifiedArchitectureFile(IWorkerContext workerContext, ArchitectureFile architectureFile, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'process' must not be null";
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'getTopLevelElements' must not be null";
        assert (architectureFile.isChecked()) : "Not checked: " + architectureFile.getIdentifyingPath();
        assert (architectureFile.modelLoaded()) : "Model not loaded: " + architectureFile.getIdentifyingPath();
        assert (representation != null) : "Parameter 'representation' of method 'process' must not be null";
        assert (representation.isReadOnly()) : "Not read only: " + String.valueOf(representation);
        LOGGER.debug("Process modified architecture file '" + architectureFile.getIdentifyingPath() + "'");
        workerContext.working("Reset structure", false);
        ResetInfo resetInfo = representation.startModification();
        RepresentationHandler.aboutToChangeStructure(true, representation);
        ArchitecturalViewState state = StateHandler.createState(representation);
        RepresentationHandler.removeAggregatedDependencies(true, representation);
        ExplorationViewFocus focus = representation.getFocus();
        if (!focus.isEmpty()) {
            FocusHandler.resetFocus(true, representation);
        }
        RepresentationHandler.collapseAll(false, representation);
        ArchitectureFileBasedCreator.resetStructure(representation);
        RepresentationHandler.reset(resetInfo.getNodeToOriginalLocation(), representation);
        workerContext.working("Apply modifications", false);
        ArchitectureFileBasedCreator.applyModifications(architectureFile, representation);
        workerContext.working("Finish element stucture", false);
        ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishElementStructure(representation);
        workerContext.working("Sort nodes", false);
        RepresentationHandler.sortNodes(workerContext, nodeInfo.getLeafNodes(), representation);
        if (!focus.isEmpty()) {
            workerContext.working("Apply focus", false);
            FocusHandler.applyFocus(focus, representation);
        }
        if (!state.isEmpty()) {
            workerContext.working("Apply nodes state", false);
            StateHandler.applyNodesState(state, null, representation);
        }
        workerContext.working("Create aggregated dependencies", false);
        RepresentationHandler.createAggregatedDependencies(true, representation);
        if (!state.isEmpty()) {
            workerContext.working("Apply dependencies state", false);
            StateHandler.applyDependenciesState(state, representation);
        }
        representation.modificationFinished();
        RepresentationHandler.structureChanged(true, true, representation);
        LOGGER.debug("Process modified architecture file '" + architectureFile.getIdentifyingPath() + "' - done");
    }

    @Override
    public void visitChildrenOf(NamedElement element) {
        block5: {
            block6: {
                assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
                if (element instanceof SourceFile) break block5;
                if (!(element instanceof AssignedElement)) break block6;
                IAssignableToArtifact iAssignableToArtifact = ((AssignedElement)element).getAssignable();
                if (!(iAssignableToArtifact instanceof IComponent)) break block5;
                for (SourceFile nextSourceFile : iAssignableToArtifact.getNamedElement().getChildren(SourceFile.class)) {
                    if (this.done()) {
                        return;
                    }
                    nextSourceFile.accept(this);
                }
                break block5;
            }
            for (NamedElement namedElement : element.getAllChildren()) {
                if (this.done()) {
                    return;
                }
                namedElement.accept(this);
            }
        }
    }

    @Override
    protected boolean includeElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'includeElement' must not be null";
        return ArchitectureFileBasedCreator.canHandle(element);
    }

    private static ArtifactProperties createArtifactProperties(Artifact artifact) {
        assert (artifact != null) : "Parameter 'artifact' of method 'createArtifactProperties' must not be null";
        ArtifactIncomingDependencyMode in = ArtifactIncomingDependencyMode.NONE;
        if (artifact.isPublic()) {
            in = ArtifactIncomingDependencyMode.PUBLIC;
        }
        ArtifactOutgoingDependencyMode out = ArtifactOutgoingDependencyMode.RESTRICTED;
        if (artifact.isStrict()) {
            out = ArtifactOutgoingDependencyMode.STRICT;
        } else if (artifact.isRelaxed()) {
            out = ArtifactOutgoingDependencyMode.RELAXED;
        } else if (artifact.isUnrestricted()) {
            out = ArtifactOutgoingDependencyMode.UNRESTRICTED;
        }
        ArtifactAssignmentMode assignment = ArtifactAssignmentMode.STANDARD;
        if (artifact.isDeprecated()) {
            assignment = ArtifactAssignmentMode.DEPRECATED;
        } else if (artifact.isOptional()) {
            assignment = ArtifactAssignmentMode.OPTIONAL;
        }
        EnumSet<ArtifactVisibility> visibilities = EnumSet.noneOf(ArtifactVisibility.class);
        if (artifact.isHidden()) {
            visibilities.add(ArtifactVisibility.HIDDEN);
        }
        if (artifact.isLocal()) {
            visibilities.add(ArtifactVisibility.LOCAL);
        }
        return new ArtifactProperties(in, out, assignment, visibilities);
    }

    @Override
    protected final ArchitecturalViewNode processElement(ArchitecturalViewElement parent, NamedElement element) {
        assert (parent != null) : "Parameter 'parent' of method 'processElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'processElement' must not be null";
        ProgrammingElementAggregatingNode node = null;
        String unhandledClass = element.getClass().getName();
        if (element instanceof Artifact) {
            if (ArchitectureFileBasedCreator.includeArtifact((Artifact)element)) {
                node = new ReadOnlyArtifactNode(parent, this.getPresentationMode(), ArchitectureFileBasedCreator.createArtifactProperties((Artifact)element), (Artifact)element);
                parent.addChild(node, ReadOnlyArtifactNode.class);
            }
            unhandledClass = null;
        } else if (element instanceof UnassignedElements) {
            unhandledClass = null;
        } else if (element instanceof LogicalNamespaceContainer) {
            node = new RecursiveNode(parent, this.getPresentationMode(), this.isReadOnly(), (IRecursiveElement)((LogicalNamespaceContainer)element).getRepresentedElement());
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof RecursiveElementComponentContainer) {
            node = new RecursiveNode(parent, this.getPresentationMode(), this.isReadOnly(), (IRecursiveElement)((RecursiveElementComponentContainer)element).getRepresentedElement());
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof RootDirectoryPathComponentContainer) {
            node = new NonRecursiveNonRootNode(parent, this.getPresentationMode(), this.isReadOnly(), (NamedElement)((RootDirectoryPathComponentContainer)element).getRepresentedElement());
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof LibraryComponentContainer) {
            node = new NonRecursiveNonRootNode(parent, this.getPresentationMode(), this.isReadOnly(), (NamedElement)((LibraryComponentContainer)element).getRepresentedElement());
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof ArchitectureElementContainer) {
            node = new NonRecursiveRootNode(parent, this.getPresentationMode(), this.isReadOnly(), (NamedElement)((ArchitectureElementContainer)element).getRepresentedElement());
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof AssignedElement) {
            IAssignableToArtifact assignableToArtifact = ((AssignedElement)element).getAssignable();
            if (assignableToArtifact instanceof IComponent) {
                node = new ComponentNode(parent, this.getPresentationMode(), this.isReadOnly(), (IComponent)assignableToArtifact);
                if (!assignableToArtifact.getNamedElement().hasChildren(false, SourceFile.class)) {
                    node.setIsLazyExpandable(true);
                    this.m_leafNode = (ComponentNode)node;
                }
            } else {
                assert (assignableToArtifact instanceof LogicalProgrammingElement) : "Unexpected class in method 'processElement': " + String.valueOf(assignableToArtifact);
                node = new TopLevelLogicalProgrammingElementNode(parent, this.getPresentationMode(), this.isReadOnly(), (LogicalProgrammingElement)assignableToArtifact);
                this.m_leafNode = (TopLevelLogicalProgrammingElementNode)node;
            }
            parent.addChild(node);
            unhandledClass = null;
        } else if (element instanceof SourceFile) {
            node = new ComponentStructureNode(parent, this.getPresentationMode(), this.isReadOnly(), (SourceFile)element);
            parent.addChild(node);
            this.m_leafNode = (ComponentStructureNode)node;
            node.setIsLazyExpandable(true);
            unhandledClass = null;
        }
        assert (unhandledClass == null) : "Unhandled class: " + unhandledClass;
        return node;
    }

    @Override
    protected void enter(NamedElement element, ArchitecturalViewNode node) {
        EmptyNodeProgrammingElement emptyNodeProgrammingElement;
        assert (element != null) : "Parameter 'element' of method 'enter' must not be null";
        if (this.m_leafNode != null) {
            NamedElement physical;
            assert (node == this.m_leafNode) : "Not same nodes";
            this.startLeafNode(this.m_leafNode);
            if (element instanceof AssignedElement) {
                IAssignableToArtifact assignable = ((AssignedElement)element).getAssignable();
                if (assignable instanceof IComponent) {
                    physical = assignable.getNamedElement();
                    if (assignable instanceof ProgrammingElement) {
                        this.processProgrammingElement((ProgrammingElement)((Object)assignable));
                    }
                } else {
                    physical = null;
                    assert (assignable != null && assignable instanceof LogicalProgrammingElement) : "Unexpected class in method 'enter': " + String.valueOf(assignable);
                    ArrayList<ProgrammingElement> programmingElements = new ArrayList<ProgrammingElement>();
                    ArchitectureFileBasedCreator.collectLogicalGroupRecursively((LogicalProgrammingElement)assignable, programmingElements);
                    for (ProgrammingElement nextProgrammingElement : programmingElements) {
                        if (this.done()) {
                            return;
                        }
                        this.processProgrammingElement(nextProgrammingElement);
                    }
                }
            } else if (element instanceof SourceFile) {
                physical = element;
            } else {
                assert (false) : "Unhandled element: " + element.getClass().getName();
                physical = null;
            }
            if (physical != null) {
                for (ProgrammingElement nextProgrammingElement : physical.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                    if (this.done()) {
                        return;
                    }
                    this.processProgrammingElement(nextProgrammingElement);
                }
            }
            this.m_leafNode = null;
        }
        if (node != null && (emptyNodeProgrammingElement = node.getEmptyNodeProgrammingElement()) != null) {
            this.processEmptyProgrammingElement(node, emptyNodeProgrammingElement);
        }
    }

    @Override
    protected void leave(NamedElement element, ArchitecturalViewNode node) {
        assert (element != null) : "Parameter 'element' of method 'leave' must not be null";
        if (node != null && this.getCurrentLeafNode() == node) {
            this.finishLeafNode(this.getCurrentLeafNode());
        }
    }
}

