/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CycleMetricsAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import java.util.Collections;

public final class ComponentCyclesInModulesMetricsAnalyzerAdapter
extends CycleMetricsAnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.COMPONENT_CYCLES_MODULE_METRICS;
    private final IMetricDescriptor m_numberOfCyclicComponents;
    private final IMetricDescriptor m_numberOfComponentCycleGroups;
    private final IMetricDescriptor m_numberOfCriticalComponentCycleGroups;
    private final IMetricDescriptor m_biggestComponentCycleGroup;
    private final IMetricDescriptor m_ignoredCyclicComponents;
    private final IMetricDescriptor m_referencesToCut;
    private final IMetricDescriptor m_dependenciesToCut;
    private final IMetricDescriptor m_sdi;
    private final IMetricDescriptor m_cyclicity;
    private final IMetricDescriptor m_relativeCyclicity;

    public ComponentCyclesInModulesMetricsAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID, Collections.singletonList(CoreAnalyzerId.COMPONENT_CYCLES_MODULE));
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_numberOfComponentCycleGroups = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_COMPONENT_CYCLE_GROUPS, CoreMetricLevel.MODULE, null);
        this.m_numberOfCriticalComponentCycleGroups = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CRITICAL_COMPONENT_CYCLE_GROUPS, CoreMetricLevel.MODULE, null);
        this.m_numberOfCyclicComponents = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLIC_COMPONENTS, CoreMetricLevel.MODULE, null);
        this.m_biggestComponentCycleGroup = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_BIGGEST_COMPONENT_CYCLE_GROUP, CoreMetricLevel.MODULE, null);
        this.m_ignoredCyclicComponents = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_CYCLIC_COMPONENTS, CoreMetricLevel.MODULE, null);
        this.m_referencesToCut = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_PARSER_DEPENDENCIES_TO_REMOVE_COMPONENTS, CoreMetricLevel.MODULE, null);
        this.m_dependenciesToCut = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_COMPONENT_DEPENDENCIES_TO_REMOVE_COMPONENTS, CoreMetricLevel.MODULE, null);
        this.m_sdi = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_STRUCTURAL_DEBT_INDEX_COMPONENTS, CoreMetricLevel.MODULE, null);
        this.m_cyclicity = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_CYCLICITY_COMPONENTS, CoreMetricLevel.MODULE, null);
        this.m_relativeCyclicity = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS, CoreMetricLevel.MODULE, null);
    }

    @Override
    protected IMetricDescriptor getNumberOfIgnoredCyclicElementsMetric() {
        return this.m_ignoredCyclicComponents;
    }

    @Override
    protected IMetricDescriptor getNumberOfCycleGroupsMetric() {
        return this.m_numberOfComponentCycleGroups;
    }

    @Override
    protected IMetricDescriptor getNumberOfCriticalCycleGroupsMetric() {
        return this.m_numberOfCriticalComponentCycleGroups;
    }

    @Override
    protected IMetricDescriptor getNumberOfCyclicElementsMetric() {
        return this.m_numberOfCyclicComponents;
    }

    @Override
    protected IMetricDescriptor getBiggestCycleGroupMetric() {
        return this.m_biggestComponentCycleGroup;
    }

    @Override
    protected IMetricDescriptor getReferencesToCutMetric() {
        return this.m_referencesToCut;
    }

    @Override
    protected IMetricDescriptor getComponentDependenciesToCutMetric() {
        return this.m_dependenciesToCut;
    }

    @Override
    protected IMetricDescriptor getStructuralDebtIndexMetric() {
        return this.m_sdi;
    }

    @Override
    protected IMetricDescriptor getCyclicityMetric() {
        return this.m_cyclicity;
    }

    @Override
    protected IMetricDescriptor getRelativeCyclicityMetric() {
        return this.m_relativeCyclicity;
    }

    @Override
    protected IMetricId getNumberOfElementsMetricId() {
        return CoreMetricId.CORE_COMPONENTS_FULLY_ANALYZED;
    }

    @Override
    protected boolean runOnSystemLevel() {
        return false;
    }
}

