/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.coupling;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.coupling.AbstractDependencyMetricsSystem;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IIncomingDependencyCumulatorAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IncomingDependencyCumulator;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;

public final class IncomingDependencyMetricsSystem
extends AbstractDependencyMetricsSystem {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.INCOMING_DEPENDENCY_METRICS_SYSTEM;
    private final IMetricDescriptor m_usedFromSystem;
    private final IMetricDescriptor m_fanInDescriptor;

    public IncomingDependencyMetricsSystem(IAnalyzerController listener) {
        super(listener, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_usedFromSystem = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_USED_FROM_SYSTEM, CoreMetricLevel.COMPONENT, null);
        this.m_fanInDescriptor = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_FAN_IN_SYSTEM, CoreMetricLevel.COMPONENT, null);
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        IncomingDependencyMetricsSystemJob job = new IncomingDependencyMetricsSystemJob(this.getGroup(), result, this.getController());
        job.start();
    }

    private class IncomingDependencyMetricsSystemJob
    extends AbstractDependencyMetricsSystem.DependencyMetricsSystemJob
    implements IIncomingDependencyCumulatorAdapter {
        private final ValueList m_usedFromValues;
        private final ValueList m_fanInValues;

        protected IncomingDependencyMetricsSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(IncomingDependencyMetricsSystem.this, group, result, controller);
            this.m_usedFromValues = IncomingDependencyMetricsSystem.this.createValueList(result, IncomingDependencyMetricsSystem.this.m_usedFromSystem, this.getSoftwareSystem());
            this.m_fanInValues = IncomingDependencyMetricsSystem.this.createValueList(result, IncomingDependencyMetricsSystem.this.m_fanInDescriptor, this.getSoftwareSystem());
        }

        @Override
        protected void processSystem(NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet) {
            if (nodeAdapterSet != null && !nodeAdapterSet.getNodes().isEmpty()) {
                new IncomingDependencyCumulator(nodeAdapterSet.getNodes(), this.getWorkerContext(), this);
            }
        }

        @Override
        public void setUsedFrom(INode<?> node, int usedFrom) {
            this.m_usedFromValues.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), usedFrom);
        }

        @Override
        public void setFanIn(INode<?> node, float fanIn) {
            this.m_fanInValues.addValue(((ParserDependencyNodeAdapter)node).getUnderlyingObject(), Float.valueOf(fanIn));
        }

        @Override
        public boolean isNodeIncluded(INode<?> node) {
            assert (node != null) : "Parameter 'node' of method 'isNodeIncluded' must not be null";
            NamedElement namedElement = ((ParserDependencyNodeAdapter)node).getUnderlyingObject();
            return !namedElement.ignoreIssues();
        }
    }
}

