/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IVirtualModelProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.List;

abstract class VirtualModelProvider
extends Extension
implements IVirtualModelProvider {
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;

    VirtualModelProvider(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'VirtualModelExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'VirtualModelExtension' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
    }

    protected final Installation getInstallation() {
        return this.m_installation;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    @Override
    public final VirtualModel getCurrentVirtualModel() {
        return this.m_softwareSystem.getCurrentModel();
    }

    @Override
    public final List<ModifiableModel> getAvailableModifiableModels() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getVirtualModels().getChildrenRecursively(ModifiableModel.class, new Class[0]);
    }

    public final ModifiableModel findModifiableModelByIdentifyingPath(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'findModifiableModelByIdentifyingPath' must not be empty";
        for (ModifiableModel next : this.getAvailableModifiableModels()) {
            if (!next.getIdentifyingPath().equals(identifyingPath)) continue;
            return next;
        }
        return null;
    }

    @Override
    public final ITextValidator getModifiableModelNameValidator() {
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if ("Parser".equalsIgnoreCase(newInput)) {
                    result.addError("'Parser' is a reserved name");
                } else {
                    if (!FileUtility.isValidName((String)newInput)) {
                        result.addError("Model name is not valid");
                    }
                    if (newInput.endsWith(CoreFileType.MODEL.getDefaultExtension())) {
                        result.addError("Name needs to be specified without file extension");
                    }
                    String newName = "./" + newInput + CoreFileType.MODEL.getDefaultExtension();
                    for (VirtualModel next : VirtualModelProvider.this.m_softwareSystem.getAvailableVirtualModels()) {
                        if (!next.getName().equalsIgnoreCase(newName)) continue;
                        result.addError("Model with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final boolean isDeletable(VirtualModel virtualModel) {
        assert (virtualModel != null) : "Parameter 'virtualModel' of method 'isDeletable' must not be null";
        if (virtualModel instanceof ParserModel) {
            return false;
        }
        if (virtualModel.getName().equals(SoftwareSystem.DEFAULT_MODIFIABLE_MODEL)) {
            return ((IModifiableFile)((Object)virtualModel)).existsOnDisk() || !virtualModel.getChildren(Resolution.class).isEmpty();
        }
        return true;
    }
}

