/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.NeedsReparse;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import java.util.EnumSet;
import java.util.List;

final class TransactionContextUpdater {
    private TransactionContextUpdater() {
    }

    static void update(TransactionContext context, SoftwareSystem softwareSystem, EnumSet<Modification> modifications, List<IModifiableFile> modifiedFiles, List<IModifiableFile> savedFiles, List<IModifiableFile> createdFiles, List<IModifiableFile> deletedFiles, List<IModifiableFile> reloadedFiles, NeedsReparse needsReparseFlagModification, TransactionContext.ModelFinishedMode mode, boolean trace) {
        assert (context != null) : "Parameter 'context' of method 'update' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'update' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'update' must not be null";
        assert (needsReparseFlagModification != null) : "Parameter 'needsReparseFlagModification' of method 'update' must not be null";
        context.setSoftwareSystem(softwareSystem);
        context.addModifications(modifications);
        if (modifiedFiles != null && !modifiedFiles.isEmpty()) {
            context.addModifiedFiles(modifiedFiles);
        }
        if (createdFiles != null && !createdFiles.isEmpty()) {
            context.addCreatedFiles(createdFiles);
        }
        if (savedFiles != null && !savedFiles.isEmpty()) {
            context.addSavedFiles(savedFiles);
        }
        if (deletedFiles != null && !deletedFiles.isEmpty()) {
            context.addDeletedFiles(deletedFiles);
        }
        if (reloadedFiles != null && !reloadedFiles.isEmpty()) {
            context.addReloadedFiles(reloadedFiles);
        }
        context.setNeedsReparseFlagModification(needsReparseFlagModification);
        if (mode != null && trace) {
            context.modelFinished(mode);
        }
    }
}

