/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.remoting.RemoteSelectionClient;
import com.hello2morrow.sonargraph.core.controller.system.remoting.SimpleHttpServer;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IRemoteSelectionExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.SonargraphProduct;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.RemoteSelectionRequestEvent;
import com.hello2morrow.sonargraph.core.model.event.RemoteSelectionServerStatusEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteConfiguration;
import com.hello2morrow.sonargraph.core.model.remoting.RemoteSelectionData;
import com.hello2morrow.sonargraph.core.model.remoting.SelectionData;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.remote.ConfigurationPersistence;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteSelectionExtension
extends OptionalExtension
implements IRemoteSelectionExtension,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteSelectionExtension.class);
    private static final String PROPS_FILE_NAME = "RemoteConnection.properties";
    private final List<RemoteSelectionData> m_requestedSelectionData = new ArrayList<RemoteSelectionData>();
    private final Installation m_installation;
    private final SonargraphProduct m_product;
    private final INamedElementResolver m_resolver;
    private SimpleHttpServer m_httpServer;
    private SoftwareSystem m_softwareSystem;

    public RemoteSelectionExtension(Installation installation, SonargraphProduct product, INamedElementResolver resolver, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(enabled);
        assert (installation != null) : "Parameter 'installation' of method 'RemoteSelectionExtension' must not be null";
        assert (product != null) : "Parameter 'product' of method 'RemoteSelectionExtension' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'RemoteSelectionExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'RemoteSelectionExtension' must not be null";
        this.m_installation = installation;
        this.m_product = product;
        this.m_resolver = resolver;
        finishModelProcessor.addListener(this);
    }

    private String performStartServer(int port) {
        if (this.m_httpServer == null) {
            try {
                this.m_httpServer = new SimpleHttpServer(this, port);
                this.m_httpServer.start();
                LOGGER.debug("Started HTTP server listening on port '" + port + "'");
                return null;
            }
            catch (Exception e) {
                this.m_httpServer = null;
                LOGGER.error("Failed to start HTTP server listening on port '" + port + "' - " + e.getLocalizedMessage());
                return e.getLocalizedMessage();
            }
        }
        LOGGER.warn("Http server already running");
        return "Http server already running";
    }

    private String performStopServer() {
        if (this.m_httpServer != null) {
            try {
                this.m_httpServer.shutDown();
                this.m_httpServer = null;
                LOGGER.debug("Stopped HTTP server");
                return null;
            }
            catch (Exception e) {
                LOGGER.error("Failed to stop HTTP server - " + e.getLocalizedMessage());
                return e.getLocalizedMessage();
            }
        }
        LOGGER.warn("Http server not running");
        return "Http server not running";
    }

    @Override
    public void finishInstallationInitialization() {
        RemoteConfiguration configuration;
        OperationResultWithOutcome<RemoteConfiguration> configurationResult;
        if (this.isEnabled() && (configurationResult = this.getCurrentConfiguration()).isSuccess() && (configuration = (RemoteConfiguration)configurationResult.getOutcome()).isEnabled()) {
            this.performStartServer(configuration.getServerPort());
        }
    }

    @Override
    public OperationResultWithOutcome<RemoteConfiguration> getConfiguration() {
        return this.getCurrentConfiguration();
    }

    @Override
    public RemoteConfiguration getDefaultConfiguration() {
        int defaultServerPort = -1;
        int defaultRemotePort = -1;
        switch (this.m_product) {
            case SONARGRAPH: {
                defaultServerPort = 42420;
                defaultRemotePort = 42421;
                break;
            }
            case SONARGRAPH_BUILD: {
                break;
            }
            case SONARGRAPH_ECLIPSE: 
            case SONARGRAPH_INTELLI_J: {
                defaultServerPort = 42421;
                defaultRemotePort = 42420;
                break;
            }
            default: {
                assert (false) : "Unspported product: " + this.m_product.getPresentationName();
                break;
            }
        }
        return new RemoteConfiguration(false, defaultServerPort, false, defaultRemotePort);
    }

    @Override
    public boolean isRemoteListening() {
        OperationResultWithOutcome<RemoteConfiguration> configurationResult;
        if (this.isEnabled() && (configurationResult = this.getCurrentConfiguration()).isSuccess()) {
            int remotePort = ((RemoteConfiguration)configurationResult.getOutcome()).getRemotePort();
            try {
                new ServerSocket(remotePort).close();
                return false;
            }
            catch (IOException e) {
                return true;
            }
        }
        return false;
    }

    private OperationResultWithOutcome<RemoteConfiguration> getCurrentConfiguration() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load current configuration for communication");
        RemoteConfiguration defaultConfiguration = this.getDefaultConfiguration();
        if (defaultConfiguration.getServerPort() == -1) {
            result.setOutcome(null);
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.UNSUPPORTED_PRODUCT, this.m_product.getPresentationName() + " does not support remote communication.", new Object[0]);
            return result;
        }
        TFile configDir = CoreResourceProviderAdapter.getInstance().getProductsConfigurationDirectory();
        if (configDir == null) {
            result.addWarning((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_LOAD_CONFIGURATION, "Failed to load remote connection properties. Working with defaults.", new Object[0]);
            result.setOutcome((Object)defaultConfiguration);
            return result;
        }
        TFile propsFile = new TFile((File)configDir, PROPS_FILE_NAME);
        if (!propsFile.exists()) {
            result.setOutcome((Object)defaultConfiguration);
            return result;
        }
        ConfigurationPersistence reader = new ConfigurationPersistence(propsFile, this.m_product);
        RemoteConfiguration configuration = reader.load(defaultConfiguration.getServerPort(), defaultConfiguration.getRemotePort(), (OperationResult)result);
        if (result.isSuccess()) {
            result.setOutcome((Object)configuration);
        }
        return result;
    }

    @Override
    public void shutdown() {
        if (this.isServerRunning()) {
            this.performStopServer();
        }
    }

    @Override
    public void initialized(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initialized' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    @Override
    public void released(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        assert (this.m_softwareSystem == softwareSystem) : "Different system instances";
        this.m_softwareSystem = null;
    }

    @Override
    public synchronized OperationResult handleSelection(Version version, String systemPath, List<RemoteSelectionData> selectionData) {
        assert (version != null) : "Parameter 'version' of method 'handleSelection' must not be null";
        assert (systemPath != null) : "Parameter 'systemPath' of method 'handleSelection' must not be null";
        assert (selectionData != null && !selectionData.isEmpty()) : "Parameter 'descriptors' of method 'handleSelection' must not be empty";
        OperationResult result = new OperationResult("Received (multi) selection request");
        this.validateCoreRemoteInfo(version, systemPath, result);
        if (result.isFailure()) {
            return result;
        }
        this.m_requestedSelectionData.clear();
        this.m_requestedSelectionData.addAll(selectionData);
        if (this.m_softwareSystem == null) {
            return result;
        }
        List<String> identifiers = selectionData.stream().map(s -> s.getDescriptor()).collect(Collectors.toList());
        EventManager.getInstance().dispatch((Object)this, (Event)new RemoteSelectionRequestEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), identifiers));
        return result;
    }

    private void validateCoreRemoteInfo(Version version, String systemPath, OperationResult result) {
        if (this.m_softwareSystem != null && !systemPath.equals(this.m_softwareSystem.getAbsolutePath())) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.SYSTEM_MISMATCH, "System path from request '" + systemPath + "' does not match current system '" + this.m_softwareSystem.getAbsolutePath() + "'.", new Object[0]);
        } else if (this.m_softwareSystem == null) {
            String message = "Caching selection request for system " + systemPath;
            result.addWarning((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.SYSTEM_MISSING, message, new Object[0]);
            LOGGER.debug("", (Object)systemPath);
        }
        if (new Version.VersionComparator().compare(this.m_installation.getVersion(), version) != 0) {
            result.addWarning((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.VERSION_MISMATCH, "Product version of request (" + String.valueOf(version) + ") is different from this version (" + String.valueOf(this.m_installation.getVersion()) + ").", new Object[0]);
        }
    }

    public synchronized OperationResult handleSingleSelection(Version version, String systemFilePath, RemoteSelectionData data) {
        assert (version != null) : "Parameter 'version' of method 'handleSingleSelection' must not be null";
        assert (systemFilePath != null && systemFilePath.length() > 0) : "Parameter 'systemFilePath' of method 'handleSingleSelection' must not be empty";
        assert (data != null) : "Parameter 'data' of method 'handleSingleSelection' must not be null";
        OperationResult result = new OperationResult("Received (single) selection request");
        this.validateCoreRemoteInfo(version, systemFilePath, result);
        if (result.isFailure()) {
            return result;
        }
        this.m_requestedSelectionData.clear();
        this.m_requestedSelectionData.add(data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResultWithOutcome<StrictPair<List<SelectionData>, List<String>>> determineElementsToSelect(IWorkerContext context) {
        assert (this.m_softwareSystem != null) : "Software system must be present to reveal remote selection.";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Determine elements for the requested descriptors");
        ArrayList<RemoteSelectionData> requested = new ArrayList<RemoteSelectionData>();
        RemoteSelectionExtension remoteSelectionExtension = this;
        synchronized (remoteSelectionExtension) {
            assert (this.m_requestedSelectionData != null && !this.m_requestedSelectionData.isEmpty()) : "'m_requestedSelectionData' of method 'getNamedElementsForSelection' must not be empty";
            requested.addAll(this.m_requestedSelectionData);
        }
        ArrayList<SelectionData> matchedElements = new ArrayList<SelectionData>();
        ArrayList<String> unmatchedDescriptors = new ArrayList<String>();
        for (RemoteSelectionData next : requested) {
            Element found = this.m_resolver.resolve(next.getDescriptor());
            if (found == null) {
                LOGGER.warn("No element found for descriptor '{}'", (Object)next);
                unmatchedDescriptors.add(next.getDescriptor());
            }
            if (!(found instanceof NamedElement)) continue;
            SelectionData data = null;
            NamedElement namedElement = (NamedElement)found;
            int line = next.getLine() > 0 ? next.getLine() : namedElement.getLineNumber();
            FilePath source = this.getSourceFileForElement(namedElement);
            if (source != null) {
                data = new SelectionData(namedElement, source, line <= 0 ? 1 : line);
            }
            if (data == null) {
                data = new SelectionData(namedElement);
            }
            matchedElements.add(data);
        }
        result.setOutcome((Object)new StrictPair(matchedElements, unmatchedDescriptors));
        return result;
    }

    private void updateConfiguration(RemoteConfiguration configuration, OperationResult result) {
        assert (configuration != null) : "Parameter 'configuration' of method 'updateConfiguration' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateConfiguration' must not be null";
        TFile configDir = CoreResourceProviderAdapter.getInstance().getProductsConfigurationDirectory();
        if (configDir == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, "Failed to create directory to persist remote connection properties", new Object[0]);
            return;
        }
        TFile propsFile = new TFile((File)configDir, PROPS_FILE_NAME);
        ConfigurationPersistence persistence = new ConfigurationPersistence(propsFile, this.m_product);
        persistence.save(configuration);
    }

    @Override
    public synchronized OperationResult startServer() {
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.getCurrentConfiguration();
        if (configResult.isFailure()) {
            return configResult;
        }
        RemoteConfiguration configuration = (RemoteConfiguration)configResult.getOutcome();
        OperationResult result = new OperationResult("Starting HTTP server");
        String failureMessage = this.performStartServer(configuration.getServerPort());
        if (failureMessage != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_START_SERVER, failureMessage, new Object[0]);
        } else {
            String detail = SonargraphProduct.SONARGRAPH.equals((Object)this.m_product) ? " from IDE." : " from Sonargraph.";
            result.addInfo((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.STARTED_SERVER, "Successfully started HTTP server listening on port '" + configuration.getServerPort() + "' to remote selection requests" + detail);
        }
        RemoteConfiguration newConfig = new RemoteConfiguration(true, configuration.getServerPort(), configuration.isRemoteEnabled(), configuration.getRemotePort());
        this.updateConfiguration(newConfig, result);
        EventManager.getInstance().dispatch((Object)this, (Event)new RemoteSelectionServerStatusEvent(this.m_installation.getExtension(ISoftwareSystemProvider.class), this.m_httpServer != null));
        return result;
    }

    @Override
    public synchronized OperationResult stopServer() {
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.getCurrentConfiguration();
        if (configResult.isFailure()) {
            return configResult;
        }
        RemoteConfiguration configuration = (RemoteConfiguration)configResult.getOutcome();
        OperationResult result = new OperationResult("Stopping HTTP server");
        String failureMessage = this.performStopServer();
        if (failureMessage != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_STOP_SERVER, failureMessage, new Object[0]);
        } else {
            String detail = SonargraphProduct.SONARGRAPH.equals((Object)this.m_product) ? " from IDE." : " from Sonargraph.";
            result.addInfo((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.STOPPED_SERVER, "Successfully stopped HTTP server listening on port '" + configuration.getServerPort() + "' to remote selection requests" + detail);
        }
        RemoteConfiguration newConfig = new RemoteConfiguration(false, configuration.getServerPort(), configuration.isRemoteEnabled(), configuration.getRemotePort());
        this.updateConfiguration(newConfig, result);
        EventManager.getInstance().dispatch((Object)this, (Event)new RemoteSelectionServerStatusEvent(this.m_installation.getExtension(ISoftwareSystemProvider.class), this.m_httpServer != null));
        return result;
    }

    @Override
    public synchronized boolean hasRemoteSelection() {
        return !this.m_requestedSelectionData.isEmpty();
    }

    @Override
    public int getDefaultPort(SonargraphProduct product) {
        assert (product != null) : "Parameter 'product' of method 'getDefaultPort' must not be null";
        switch (product) {
            case SONARGRAPH: {
                return 42420;
            }
            case SONARGRAPH_BUILD: {
                return -1;
            }
            case SONARGRAPH_ECLIPSE: 
            case SONARGRAPH_INTELLI_J: {
                return 42421;
            }
        }
        return -1;
    }

    @Override
    public boolean isServerRunning() {
        return this.m_httpServer != null;
    }

    @Override
    public OperationResult sendSingleSelectionRequest(NamedElement element, int lineNumber) {
        assert (element != null) : "Parameter 'element' of method 'sendSingleSelectionEvent' must not be null";
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.getCurrentConfiguration();
        if (configResult.isFailure()) {
            return configResult;
        }
        RemoteConfiguration config = (RemoteConfiguration)configResult.getOutcome();
        assert (config != null) : "RemoteConfiguration must not be null";
        RemoteSelectionClient client = new RemoteSelectionClient(config.getRemotePort());
        FilePath sourceFile = this.getSourceFileForElement(element);
        RemoteSelectionData data = new RemoteSelectionData(this.m_resolver.getDescriptor(element), sourceFile != null ? sourceFile.getAbsolutePath() : null, lineNumber >= 0 ? lineNumber : element.getLineNumber());
        return client.selectSingle(this.m_installation.getVersion(), this.m_softwareSystem.getAbsolutePath(), data);
    }

    private FilePath getSourceFileForElement(NamedElement element) {
        ILanguageProvider languageProvider;
        assert (element != null) : "Parameter 'element' of method 'getSourceFileForElement' must not be null";
        Language language = element.getLanguage();
        if (language != null && (languageProvider = this.m_installation.getExtension(ISoftwareSystemProvider.class).getLanguageProvider(language)) != null) {
            return languageProvider.getSourceFile(element);
        }
        return null;
    }

    @Override
    public OperationResult sendSelectionRequest(List<NamedElement> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'sendSelectionRequest' must not be empty";
        OperationResult result = new OperationResult("Send remote selection request");
        OperationResultWithOutcome<RemoteConfiguration> configResult = this.getCurrentConfiguration();
        if (configResult.isFailure()) {
            result.addMessagesFrom(configResult);
            return result;
        }
        RemoteSelectionClient client = new RemoteSelectionClient(((RemoteConfiguration)configResult.getOutcome()).getRemotePort());
        ISoftwareSystemProvider softwareSystemProvider = this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class);
        INamedElementResolver resolver = softwareSystemProvider.getElementResolver();
        List<String> fqNames = elements.stream().map(e -> resolver.getDescriptor((Element)e)).collect(Collectors.toList());
        return client.select(this.m_installation.getVersion(), softwareSystemProvider.getSoftwareSystem().getSystemDirectoryFile().getAbsolutePath(), fqNames);
    }

    @Override
    public OperationResult updateConfiguration(RemoteConfiguration modifiedConfiguration) {
        String failureMessage;
        assert (modifiedConfiguration != null) : "Parameter 'modifiedConfiguration' of method 'updateConfiguration' must not be null";
        OperationResult result = new OperationResult("Update configuration for remote selection");
        boolean isRunning = this.m_httpServer != null;
        boolean failedToStop = false;
        if (isRunning && (failureMessage = this.performStopServer()) != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_STOP_SERVER, failureMessage, new Object[0]);
            failedToStop = true;
        }
        this.updateConfiguration(modifiedConfiguration, result);
        if (isRunning && !failedToStop && (failureMessage = this.performStartServer(modifiedConfiguration.getServerPort())) != null) {
            result.addError((OperationResult.IMessageCause)RemoteSelectionClient.RemoteMessageCause.FAILED_TO_START_SERVER, "Failed to restart server with new configuration - " + failureMessage, new Object[0]);
        }
        return result;
    }
}

