/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitecturalViewOperationProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArtifactHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CreateArtifactFromElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CreateArtifactsForElementsResult;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.EditOperationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FilterHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LoadedRepresentationInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ModificationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationExecutor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.OperationHandler;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewOperationExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewSplitEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNodeFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableTargetInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactFromElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactsForElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.EditOperationInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitecturalViewOperationExtension
extends ArchitecturalViewOperationProvider
implements IArchitecturalViewOperationExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewOperationExtension.class);

    public ArchitecturalViewOperationExtension(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, IElementResolver resolver, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(accessor, installation, softwareSystem, resolver, finishModelProcessor, enabled);
    }

    @Override
    public OperationResultWithOutcome<ArchitecturalViewFile> splitBeforeOperation(IWorkerContext workerContext, String name, String description, ArchitecturalViewOperation operation, ArchitecturalViewFile split) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'splitBeforeOperation' must not be null";
        ValidationResult isValid = this.getArchitecturalViewNameValidator().isValid(null, name);
        assert (isValid.isSuccess()) : "Name '" + name + "' is not valid: " + String.valueOf(isValid);
        assert (description != null) : "Parameter 'description' of method 'splitBeforeOperation' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'splitBeforeOperation' must not be null";
        assert (split != null) : "Parameter 'split' of method 'splitBeforeOperation' must not be null";
        StrictPair<ArchitecturalViewFile, ArchitecturalViewOperation> splitBeforePossible = this.isSplitBeforeOperationPossible(operation);
        assert (splitBeforePossible != null && ((ArchitecturalViewFile)splitBeforePossible.getFirst()).equals(split) && ((ArchitecturalViewOperation)splitBeforePossible.getSecond()).equals(operation)) : "Split not posible";
        LOGGER.debug("Split '" + split.getIdentifyingPath() + "' before operation '" + operation.getIndex() + "'");
        OperationResultWithOutcome result = new OperationResultWithOutcome("Split '" + split.getIdentifyingPath() + "' before operation '" + operation.getIndex() + "'");
        this.checkOutOfSync((OperationResult)result);
        if (result.isSuccess()) {
            ExplorationViewRepresentation representation = split.getUniqueChild(ExplorationViewRepresentation.class);
            Pair<ExplorationViewFocus, ArchitecturalViewState> focusAndState = representation != null ? ModificationHandler.startModification(representation) : null;
            split.removeChildren(ExplorationViewRepresentation.class);
            this.resetOperations(split);
            ArrayList<ArchitecturalViewOperation> opertionsToMove = new ArrayList<ArchitecturalViewOperation>();
            boolean delete = false;
            for (ArchitecturalViewOperation nextOp : split.getNonInheritedOperations()) {
                if (nextOp == operation) {
                    delete = true;
                }
                if (!delete) continue;
                opertionsToMove.add(nextOp);
                nextOp.remove();
            }
            assert (delete) : "At least 1 deleted operation expected";
            split.setNeedsSave(true);
            result.addMessagesFromMaintainingCurrentOutcome(this.save(split));
            this.fileContentModified(split);
            ArchitecturalViewFile newFile = this.createFile(name, description, split.getStructureMode(), split, (OperationResult)result);
            ArchitecturalViewOperationList operationsOfNewFile = newFile.getUniqueExistingChild(ArchitecturalViewOperationList.class);
            opertionsToMove.forEach(o -> operationsOfNewFile.addChild(o.copy(operationsOfNewFile)));
            newFile.setNeedsSave(true);
            result.addMessagesFromMaintainingCurrentOutcome(this.save(newFile));
            this.fileContentModified(newFile);
            if (representation != null) {
                representation.changeParent(newFile, true);
                OperationExecutor.applyOperations(workerContext, newFile, representation);
                ModificationHandler.finishModification(workerContext, representation, (ExplorationViewFocus)focusAndState.getFirst(), (ArchitecturalViewState)focusAndState.getSecond(), null, null);
            }
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
            ArchitecturalViewSplitEvent event = new ArchitecturalViewSplitEvent(this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), split, newFile);
            EventManager.getInstance().dispatch((Object)this, (Event)event);
        }
        LOGGER.debug("Split '" + split.getIdentifyingPath() + "' before operation '" + operation.getIndex() + "' - done");
        return result;
    }

    void deleteOperations(ArchitecturalViewFile file, List<ArchitecturalViewOperation> operations) {
        assert (file != null) : "Parameter 'workerContext' of method 'performDeleteOperations' must not be null";
        assert (operations != null && !operations.isEmpty()) : "Parameter 'operations' of method 'performDeleteOperations' must not be empty";
        operations.forEach(o -> o.remove());
        file.setNeedsSave(true);
    }

    void reApplyOperations(IWorkerContext workerContext, ArchitecturalViewFile restored) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'reApplyOperations' must not be null";
        assert (restored != null) : "Parameter 'restored' of method 'reApplyOperations' must not be null";
        assert (this.hasBeenLoaded(restored)) : "Not loaded: " + restored.getIdentifyingPath();
        restored.getFindingList().forgetChildren(false);
        restored.getRefactoringList().forgetChildren(false);
        restored.getViolationList().forgetChildren(false);
        this.resetOperations(restored);
        ExplorationViewRepresentation representation = restored.getUniqueExistingChild(ExplorationViewRepresentation.class);
        Pair<ExplorationViewFocus, ArchitecturalViewState> focusAndState = ModificationHandler.startModification(representation);
        OperationExecutor.applyOperations((IWorkerContext)DefaultWorkerContext.INSTANCE, restored, representation);
        ModificationHandler.finishModification(workerContext, representation, (ExplorationViewFocus)focusAndState.getFirst(), (ArchitecturalViewState)focusAndState.getSecond(), null, null);
        this.notifyModification(restored, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(this.getSoftwareSystem(), EnumSet.noneOf(Modification.class));
    }

    @Override
    public OperationResult deleteOperations(IWorkerContext workerContext, List<ArchitecturalViewOperation> operations) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'deleteOperations' must not be null";
        assert (operations != null && !operations.isEmpty()) : "Parameter 'operations' of method 'deleteOperations' must not be empty";
        OperationResult result = new OperationResult("Delete architectural view operations");
        ArchitecturalViewFile file = this.areModifiable(operations, false);
        assert (file != null) : "'file' of method 'deleteOperations' must not be null";
        if (this.hasBeenLoaded(file)) {
            boolean applyOperations = false;
            for (ArchitecturalViewOperation nextOperation : operations) {
                if (nextOperation.hasIssues(CoreIssueId.ARCHITECTURAL_VIEW_OPERATION_NOT_APPLICABLE)) continue;
                applyOperations = true;
                break;
            }
            if (applyOperations) {
                file.getFindingList().forgetChildren(false);
                file.getRefactoringList().forgetChildren(false);
                file.getViolationList().forgetChildren(false);
                this.resetOperations(file);
                ExplorationViewRepresentation representation = file.getUniqueExistingChild(ExplorationViewRepresentation.class);
                Pair<ExplorationViewFocus, ArchitecturalViewState> focusAndState = ModificationHandler.startModification(representation);
                operations.forEach(o -> o.remove());
                file.setNeedsSave(true);
                OperationExecutor.applyOperations((IWorkerContext)DefaultWorkerContext.INSTANCE, file, representation);
                ModificationHandler.finishModification(workerContext, representation, (ExplorationViewFocus)focusAndState.getFirst(), (ArchitecturalViewState)focusAndState.getSecond(), null, null);
                this.notifyModification(file, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
                this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
            } else {
                for (ArchitecturalViewOperation nextToDelete : operations) {
                    nextToDelete.removeIssues(CoreIssueId.ARCHITECTURAL_VIEW_OPERATION_NOT_APPLICABLE);
                    nextToDelete.remove();
                }
                file.setNeedsSave(true);
                this.notifyModification(file, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
                this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
            }
        } else {
            this.deleteOperations(file, operations);
            this.notifyModification(file, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITHOUT_STRUCTURE_MODIFICATION));
            this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public OperationResult startEditOperation(IWorkerContext workerContext, EditOperationInfo info) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'startEditOperation' must not be null";
        assert (info != null) : "Parameter 'info' of method 'startEditOperation' must not be null";
        OperationResult result = new OperationResult("Edit " + info.getOperation().getPresentationKind() + "'");
        EditOperationHandler.startEditOperation(workerContext, info);
        return result;
    }

    @Override
    public void editCreateArtifactOperation(IWorkerContext workerContext, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, ArtifactNodeFilter filter, CreateArtifactOperation operation, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editCreateArtifactOperation' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editCreateArtifactOperation' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'editCreateArtifactOperation' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'editCreateArtifactOperation' must not be null";
        assert (filter != null) : "Parameter 'filter' of method 'editCreateArtifactOperation' must not be null";
        assert (FilterHandler.isFilterValid(filter) == null) : "Filter not valid: " + String.valueOf(filter);
        assert (operation != null) : "Parameter 'operation' of method 'editCreateArtifactOperation' must not be null";
        assert (result != null) : "Parameter 'result' of method 'editCreateArtifactOperation' must not be null";
        assert (ArtifactHandler.getArtifactNameValidator(targetInfo, null).isValid(null, shortName).isSuccess()) : "Not a valid name: " + shortName;
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(targetInfo.getTarget().getArchitecturalViewElement());
        int atPos = targetInfo.getRelativeIndex();
        ArtifactNode artifact = OperationHandler.opCreateArtifact(loadedInfo.getPresentationMode(), targetInfo.getTarget(), atPos, shortName, properties, filter, loadedInfo.getRepresentation());
        CreateArtifactOperation op = new CreateArtifactOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), targetInfo.getTarget().getArchitecturalViewElement().getRelativePath(), atPos, properties, shortName);
        FilterHandler.finishFilterOperationCreation(op, artifact);
        loadedInfo.getOperationList().replaceChild(operation, op);
        loadedInfo.getFile().setNeedsSave(true);
    }

    @Override
    public void editCreateArtifactFromElementsOperation(IWorkerContext workerContext, AssignableTargetInfo targetInfo, String shortName, ArtifactProperties properties, List<ArchitecturalViewElement> elements, CreateArtifactFromElementsOperation operation, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editCreateArtifactFromElementsOperation' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editCreateArtifactFromElementsOperation' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'editCreateArtifactFromElementsOperation' must not be empty";
        assert (properties != null) : "Parameter 'properties' of method 'editCreateArtifactFromElementsOperation' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'editCreateArtifactFromElementsOperation' must not be empty";
        assert (operation != null) : "Parameter 'operation' of method 'editCreateArtifactFromElementsOperation' must not be null";
        assert (result != null) : "Parameter 'result' of method 'editCreateArtifactFromElementsOperation' must not be null";
        assert (ArtifactHandler.getArtifactFromElementsNameValidator(targetInfo, elements).isValid(null, shortName).isSuccess()) : "Not a valid name: " + shortName;
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(targetInfo.getTarget().getArchitecturalViewElement());
        int atPos = targetInfo.getRelativeIndex();
        CreateArtifactFromElementsResult creationResult = OperationHandler.opCreateArtifactFromElements(loadedInfo.getPresentationMode(), targetInfo.getTarget(), atPos, shortName, properties, elements, loadedInfo.getRepresentation());
        CreateArtifactFromElementsOperation op = new CreateArtifactFromElementsOperation(loadedInfo.getOperationList(), loadedInfo.getPresentationMode(), targetInfo.getTarget().getArchitecturalViewElement().getRelativePath(), atPos, properties, shortName, creationResult.getRelativePaths());
        loadedInfo.getOperationList().replaceChild(operation, op);
        loadedInfo.getFile().setNeedsSave(true);
    }

    @Override
    public void editCreateArtifactsForElementsOperation(IWorkerContext workerContext, AssignableTargetInfo targetInfo, ArtifactProperties artifactProperties, PresentationMode presentationMode, List<ArchitecturalViewElement> elements, CreateArtifactsForElementsOperation operation, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editCreateArtifactsForElementsOperation' must not be null";
        assert (targetInfo != null) : "Parameter 'targetInfo' of method 'editCreateArtifactsForElementsOperation' must not be null";
        assert (artifactProperties != null) : "Parameter 'artifactProperties' of method 'editCreateArtifactsForElementsOperation' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'editCreateArtifactsForElementsOperation' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'editCreateArtifactsForElementsOperation' must not be empty";
        assert (operation != null) : "Parameter 'operation' of method 'editCreateArtifactsForElementsOperation' must not be null";
        assert (result != null) : "Parameter 'result' of method 'editCreateArtifactsForElementsOperation' must not be null";
        LoadedRepresentationInfo loadedInfo = this.getLoadedRepresentationInfo(targetInfo.getTarget().getArchitecturalViewElement());
        int atPos = targetInfo.getRelativeIndex();
        CreateArtifactsForElementsResult creationResult = OperationHandler.opCreateArtifactsForElements(presentationMode, targetInfo.getTarget(), atPos, artifactProperties, elements, loadedInfo.getRepresentation());
        CreateArtifactsForElementsOperation op = new CreateArtifactsForElementsOperation(loadedInfo.getOperationList(), presentationMode, targetInfo.getTarget().getArchitecturalViewElement().getRelativePath(), atPos, artifactProperties, creationResult.getRelativePaths());
        loadedInfo.getOperationList().replaceChild(operation, op);
        loadedInfo.getFile().setNeedsSave(true);
    }

    @Override
    public void finishEditOperation(IWorkerContext workerContext, EditOperationInfo info, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishEditOperation' must not be null";
        assert (info != null) : "Parameter 'info' of method 'finishEditOperation' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishEditOperation' must not be null";
        ArchitecturalViewFile file = EditOperationHandler.finishEditOperation(workerContext, info);
        this.notifyModification(file, new ArchitecturalViewModifiedEvent.ArchitecturalViewModification(ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.OPERATION_WITH_STRUCTURE_MODIFICATION));
        this.getFinishModelProcessor().finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
    }
}

