/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.resolution;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IIssueExtension;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;

public final class DeleteResolutionsCommand
extends SimpleSoftwareSystemBasedCommand {
    private final List<Resolution> m_resolutionsToDelete;

    public DeleteResolutionsCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, List<Resolution> resolutionsToDelete) {
        super(provider, interaction);
        assert (resolutionsToDelete != null && resolutionsToDelete.size() > 0) : "Parameter 'resolutionsToDelete' of method 'DeleteResolutionCommand' must not be empty";
        this.m_resolutionsToDelete = resolutionsToDelete;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_RESOLUTIONS;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        OperationResult result = this.getSoftwareSystem().getExtension(IIssueExtension.class).delete(workerContext, this.m_resolutionsToDelete);
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process(result);
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess()) {
            if (!this.getController().getSoftwareSystem().getCurrentModel().isModifiable()) {
                enabled.addErrorMessage("Virtual model not modifiable");
            } else if (this.m_resolutionsToDelete == null || this.m_resolutionsToDelete.isEmpty()) {
                enabled.addErrorMessage("There are no issues to ignore");
            }
        }
        return enabled;
    }
}

