/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.qualitygate;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import java.util.List;

public class DeleteQualityGateElementsCommand
extends SoftwareSystemBasedCommand<IDeleteInteraction> {
    public DeleteQualityGateElementsCommand(ISoftwareSystemProvider provider, IDeleteInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_QUALITY_GATE_ELEMENTS;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        DeleteInteractionData data = new DeleteInteractionData();
        if (!((IDeleteInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IQualityGateExtension extension = this.getController().getSoftwareSystem().getExtension(IQualityGateExtension.class);
        OperationResultWithOutcome<QualityGate> result = extension.deleteQualityGateElements(workerContext, data.getQualityGate(), data.getElementsToDelete());
        ((IDeleteInteraction)this.getInteraction()).handleResult(result);
    }

    public static final class DeleteInteractionData
    implements ICommandInteractionData {
        private List<IQualityGateElement> m_toDelete;
        private QualityGate m_qualityGate;

        public void setQualityGate(QualityGate qualityGate) {
            assert (qualityGate != null) : "Parameter 'qualityGate' of method 'setQualityGate' must not be null";
            this.m_qualityGate = qualityGate;
        }

        public QualityGate getQualityGate() {
            return this.m_qualityGate;
        }

        public void setElementsToDelete(List<IQualityGateElement> toDelete) {
            assert (toDelete != null) : "Parameter 'toDelete' of method 'setElementsToDelete' must not be null";
            this.m_toDelete = toDelete;
        }

        public List<IQualityGateElement> getElementsToDelete() {
            return this.m_toDelete;
        }
    }

    public static interface IDeleteInteraction
    extends ICommandInteraction {
        public boolean collect(DeleteInteractionData var1);

        public void handleResult(OperationResultWithOutcome<QualityGate> var1);
    }
}

