/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferExecutionInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class TransferCommand
extends ArchitecturalViewCommand<ITransferInteraction> {
    public TransferCommand(ISoftwareSystemProvider provider, ITransferInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.TRANSFER_ARCHITECTURAL_VIEW;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        TransferData data = new TransferData();
        if (!((ITransferInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.transfer(workerContext, data.getTransferExecutionInfo());
        ((ITransferInteraction)this.getInteraction()).processTransferResult(result);
    }

    public static interface ITransferInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(TransferData var1);

        public void processTransferResult(OperationResult var1);
    }

    public static final class TransferData
    implements IArchitecturalViewCommandInteractionData {
        private TransferExecutionInfo m_transferExecutionInfo;

        TransferData() {
        }

        public void setTransferExecutionInfo(TransferExecutionInfo info) {
            assert (info != null) : "Parameter 'info' of method 'setTransferExecutionInfo' must not be null";
            this.m_transferExecutionInfo = info;
        }

        TransferExecutionInfo getTransferExecutionInfo() {
            assert (this.m_transferExecutionInfo != null) : "'m_transferExecutionInfo' of method 'getTransferExecutionInfo' must not be null";
            return this.m_transferExecutionInfo;
        }
    }
}

