/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveElementCreationInfo;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class CreateElementCommand
extends ArchitecturalViewCommand<ICreateElementInteraction> {
    public CreateElementCommand(ISoftwareSystemProvider provider, ICreateElementInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_ARCHITECTURAL_VIEW_ELEMENT;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        CreateElementData data = new CreateElementData();
        if (!((ICreateElementInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.createElement(workerContext, data.getCreationInfo(), data.getName());
        ((ICreateElementInteraction)this.getInteraction()).processCreateElementResult(result);
    }

    public static final class CreateElementData
    implements IArchitecturalViewCommandInteractionData {
        private RecursiveElementCreationInfo m_creationInfo;
        private String m_name;

        RecursiveElementCreationInfo getCreationInfo() {
            assert (this.m_creationInfo != null) : "'m_creationInfo' of method 'getCreationInfo' must not be null";
            return this.m_creationInfo;
        }

        public void setCreationInfo(RecursiveElementCreationInfo creationInfo) {
            assert (creationInfo != null) : "Parameter 'creationInfo' of method 'setCreationInfo' must not be null";
            this.m_creationInfo = creationInfo;
        }

        public void setName(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
            this.m_name = name;
        }

        String getName() {
            assert (this.m_name != null && this.m_name.length() > 0) : "'m_name' of method 'getName' must not be empty";
            return this.m_name;
        }
    }

    public static interface ICreateElementInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(CreateElementData var1);

        public void processCreateElementResult(OperationResult var1);
    }
}

