/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerExecutionLevel;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class SetAnalyzerExecutionLevelCommand
extends SonargraphCommand {
    private final ISetAnalyzerExecutionLevelInteraction m_interaction;

    public SetAnalyzerExecutionLevelCommand(ISoftwareSystemProvider provider, ISetAnalyzerExecutionLevelInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'SetAnalyzerExecutionLevelCommand' must not be null";
        this.m_interaction = interaction;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SET_ANALYZER_EXECUTION_LEVEL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SetAnalyzerExecutionLevelData data = new SetAnalyzerExecutionLevelData();
        if (!this.m_interaction.collect(data)) {
            return;
        }
        this.getController().setAnalyzerExecutionLevel(data.geLevel());
    }

    public static interface ISetAnalyzerExecutionLevelInteraction
    extends ICommandInteraction {
        public boolean collect(SetAnalyzerExecutionLevelData var1);
    }

    public static final class SetAnalyzerExecutionLevelData
    implements ICommandInteractionData {
        private AnalyzerExecutionLevel m_level;

        SetAnalyzerExecutionLevelData() {
        }

        public void setLevel(AnalyzerExecutionLevel level) {
            assert (level != null) : "Parameter 'level' of method 'setLevel' must not be null";
            this.m_level = level;
        }

        AnalyzerExecutionLevel geLevel() {
            assert (this.m_level != null) : "'m_level' of method 'geLevel' must not be null";
            return this.m_level;
        }
    }
}

