/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public final class MoveRootDirectoryPathsCommand
extends SoftwareSystemBasedCommand<IMoveRootDirectoryPathsInteraction> {
    public MoveRootDirectoryPathsCommand(ISoftwareSystemProvider provider, IMoveRootDirectoryPathsInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.MOVE_ROOT_DIRECTORY_PATHS;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        MoveRootDirectoryPathsData data = new MoveRootDirectoryPathsData();
        if (((IMoveRootDirectoryPathsInteraction)this.getInteraction()).collectMoveRootDirectoryPathsData(data)) {
            OperationResult result = this.getSoftwareSystem().getExtension(IWorkspaceExtension.class).moveRootDirectoryPathsTo(workerContext, data.getRootDirectoryPaths(), data.getModule(), data.getPos());
            ((IMoveRootDirectoryPathsInteraction)this.getInteraction()).processMoveRootDirectoryPathsResult(result);
        }
    }

    public static interface IMoveRootDirectoryPathsInteraction
    extends ICommandInteraction {
        public boolean collectMoveRootDirectoryPathsData(MoveRootDirectoryPathsData var1);

        public void processMoveRootDirectoryPathsResult(OperationResult var1);
    }

    public static final class MoveRootDirectoryPathsData
    implements ICommandInteractionData {
        private List<RootDirectoryPath> m_rootDirectoryPaths;
        private Module m_module;
        private int m_pos = -1;

        MoveRootDirectoryPathsData() {
        }

        public final void set(List<RootDirectoryPath> rootDirectoryPaths, Module module, int pos) {
            assert (rootDirectoryPaths != null && !rootDirectoryPaths.isEmpty()) : "Parameter 'rootDirectoryPaths' of method 'set' must not be empty";
            assert (module != null) : "Parameter 'module' of method 'set' must not be null";
            assert (pos >= 0) : "'pos' must not be negative";
            this.m_rootDirectoryPaths = new ArrayList<RootDirectoryPath>(rootDirectoryPaths);
            this.m_module = module;
            this.m_pos = pos;
        }

        List<RootDirectoryPath> getRootDirectoryPaths() {
            assert (this.m_rootDirectoryPaths != null && !this.m_rootDirectoryPaths.isEmpty()) : "'m_rootDirectoryPaths' of method 'getRootDirectoryPaths' must not be empty";
            return this.m_rootDirectoryPaths;
        }

        public Module getModule() {
            assert (this.m_module != null) : "Parameter 'm_module' of method 'getModule' must not be null";
            return this.m_module;
        }

        int getPos() {
            assert (this.m_pos >= 0) : "'m_pos' must not be negative";
            return this.m_pos;
        }
    }
}

