/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityModelImportExportExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.path.ExportQualityModel;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;

public final class ExportQualityModelCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public static IPathValidator getExportQualityModelValidator(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getPathValidator' must not be null";
        return provider.getInstallation().getExtension(IQualityModelImportExportExtension.class).getExportQualityModelValidator();
    }

    public ExportQualityModelCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EXPORT_QUALITY_MODEL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        ExportQualityModel exportQualityModel = this.getController().getSoftwareSystem().getExtension(IQualityModelImportExportExtension.class).getExportQualityModel();
        if (!((IInteraction)this.getInteraction()).confirm(exportQualityModel)) {
            return;
        }
        String fileName = exportQualityModel.getFilePath();
        TFile file = new TFile(fileName);
        if (file.exists() && !((IInteraction)this.getInteraction()).confirmOverwrite()) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IQualityModelImportExportExtension.class).exportQualityModel(exportQualityModel);
        ((IInteraction)this.getInteraction()).processExportResult(result);
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean confirm(ExportQualityModel var1);

        public boolean confirmOverwrite();

        public void processExportResult(OperationResult var1);
    }
}

