/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.CreateRepresentationCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGraphRepresentationExtension;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.graph.GraphRepresentation;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.Result;

public final class CreateGraphForPresentationModeChangeCommand
extends CreateRepresentationCommand<GraphRepresentation> {
    private final GraphRepresentation m_previousRepresentation;
    private final PresentationMode m_presentationMode;

    public CreateGraphForPresentationModeChangeCommand(ISoftwareSystemProvider controller, GraphRepresentation previousRepresentation, PresentationMode presentationMode) {
        super(controller);
        assert (previousRepresentation != null) : "Parameter 'previousRepresentation' of method 'CreateTreeForProgrammingElementCollectionModeChangeCommand' must not be null";
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'CreateGraphForPresentationModeChangeCommand' must not be null";
        this.m_previousRepresentation = previousRepresentation;
        this.m_presentationMode = presentationMode;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && this.m_previousRepresentation.getMainNodes().isEmpty()) {
            enabled.addErrorMessage("No main path nodes to modify the tree");
        }
        return enabled;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_GRAPH_REPRESENTATION_FOR_PRESENTATION_MODE_CHANGE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        this.setRepresentation(this.getController().getSoftwareSystem().getExtension(IGraphRepresentationExtension.class).createRepresentationForPresentationModeChange(workerContext, this.m_previousRepresentation, this.m_presentationMode));
    }
}

