/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IDynamicSystemExtension;
import com.hello2morrow.sonargraph.core.model.system.IAdditionalDynamicInfoProvider;
import com.hello2morrow.sonargraph.core.model.system.IDynamicSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.dynamic.DynamicSystemInfo;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import de.schlichtherle.truezip.file.TFile;
import java.util.Map;

public final class CreateDynamicSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    private final IInteraction m_interaction;

    public CreateDynamicSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateDynamicSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_DYNAMIC_SYSTEM;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SystemData data = new SystemData();
        if (!this.m_interaction.collect(data)) {
            return;
        }
        OperationResultWithOutcome<TFile> result = this.getController().getInstallation().getExtension(IDynamicSystemExtension.class).createSoftwareSystem(data.getSystem(), data.getTargetDir(), data.getQualityModelFile());
        this.m_interaction.processResult(result);
    }

    public static Map<String, IAdditionalDynamicInfoProvider> getAdditionalInfoProviders(ISoftwareSystemProvider systemProvider) {
        assert (systemProvider != null) : "Parameter 'systemProvider' of method 'getAdditionalInfoProviders' must not be null";
        return systemProvider.getInstallation().getExtension(IDynamicSystemProvider.class).getInfoProviders();
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(SystemData var1);

        public void processResult(OperationResultWithOutcome<TFile> var1);
    }

    public class SystemData
    implements ICommandInteractionData {
        private DynamicSystemInfo m_system;
        private TFile m_targetDir;
        private TFile m_qualityModelFile;

        public void setSystemInfo(DynamicSystemInfo dynamicSystem) {
            assert (dynamicSystem != null) : "Parameter 'system' of method 'setSystemInfo' must not be null";
            this.m_system = dynamicSystem;
        }

        public void setTargetDirectory(TFile dir) {
            assert (dir != null) : "Parameter 'dir' of method 'setTargetDirectory' must not be null";
            this.m_targetDir = dir;
        }

        public DynamicSystemInfo getSystem() {
            return this.m_system;
        }

        public TFile getTargetDir() {
            return this.m_targetDir;
        }

        public void setQualityModelFile(TFile qualityModelFile) {
            this.m_qualityModelFile = qualityModelFile;
        }

        public TFile getQualityModelFile() {
            return this.m_qualityModelFile;
        }
    }
}

