/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.storage;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.auth.nls.SecAuthMessages;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesContainer;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesRoot;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesWrapper;
import org.eclipse.equinox.internal.security.storage.StorageUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;

public class SecurePreferencesMapper {
    private static final String KEYRING_ARGUMENT = "-eclipse.keyring";
    private static final String KEYRING_ENVIRONMENT = "ECLIPSE_KEYRING";
    private static final String PASSWORD_ARGUMENT = "-eclipse.password";
    private static ISecurePreferences defaultPreferences = null;
    private static Map<String, SecurePreferencesRoot> preferences = new HashMap<String, SecurePreferencesRoot>();
    public static final String USER_HOME = "user.home";

    public static ISecurePreferences getDefault() {
        if (defaultPreferences == null) {
            try {
                defaultPreferences = SecurePreferencesMapper.open(null, null);
            }
            catch (IOException e) {
                AuthPlugin.getDefault().logError(SecAuthMessages.keyringNotAvailable, e);
            }
        }
        return defaultPreferences;
    }

    public static void clearDefault() {
        if (defaultPreferences == null) {
            return;
        }
        try {
            defaultPreferences.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SecurePreferencesMapper.close(((SecurePreferencesWrapper)defaultPreferences).getContainer().getRootData());
        defaultPreferences = null;
    }

    public static ISecurePreferences open(URL location, Map<Object, Object> options) throws IOException {
        String[] args;
        EnvironmentInfo infoService = AuthPlugin.getDefault().getEnvironmentInfoService();
        if (infoService != null && (args = infoService.getNonFrameworkArgs()) != null && args.length != 0) {
            int i = 0;
            while (i < args.length - 1) {
                if (!args[i + 1].startsWith("-")) {
                    if (location == null && KEYRING_ARGUMENT.equalsIgnoreCase(args[i])) {
                        location = SecurePreferencesMapper.getKeyringFile(args[i + 1]).toURL();
                    } else if (PASSWORD_ARGUMENT.equalsIgnoreCase(args[i])) {
                        options = SecurePreferencesMapper.processPassword(options, args[i + 1]);
                    }
                }
                ++i;
            }
        }
        String environmentKeyring = System.getenv(KEYRING_ENVIRONMENT);
        if (location == null && environmentKeyring != null) {
            location = SecurePreferencesMapper.getKeyringFile(environmentKeyring).toURL();
        }
        if (location == null) {
            location = StorageUtils.getDefaultLocation();
        }
        if (!StorageUtils.isFile(location)) {
            throw new IOException(NLS.bind((String)SecAuthMessages.loginFileURL, (Object)location.toString()));
        }
        String key = location.toString();
        SecurePreferencesRoot root = preferences.get(key);
        if (root == null) {
            root = new SecurePreferencesRoot(location);
            preferences.put(key, root);
        }
        SecurePreferencesContainer container = new SecurePreferencesContainer(root, options);
        return container.getPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        Map<String, SecurePreferencesRoot> map = preferences;
        synchronized (map) {
            for (SecurePreferencesRoot provider : preferences.values()) {
                try {
                    provider.flush();
                }
                catch (IOException e) {
                    AuthPlugin.getDefault().frameworkLogError(SecAuthMessages.errorOnSave, 4, e);
                }
            }
            preferences.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPasswordCache() {
        Map<String, SecurePreferencesRoot> map = preferences;
        synchronized (map) {
            for (SecurePreferencesRoot provider : preferences.values()) {
                provider.clearPasswordCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close(SecurePreferencesRoot root) {
        if (root != null) {
            Map<String, SecurePreferencesRoot> map = preferences;
            synchronized (map) {
                preferences.values().remove(root);
            }
        }
    }

    private static File getKeyringFile(String path) {
        if (path.startsWith("@user.home")) {
            return new File(System.getProperty(USER_HOME), path.substring(USER_HOME.length() + 1));
        }
        return new File(path);
    }

    private static Map<Object, Object> processPassword(Map<Object, Object> options, String arg) {
        if (arg == null || arg.isEmpty()) {
            return options;
        }
        Path file = Path.of(arg, new String[0]);
        if (!Files.isReadable(file)) {
            String msg = NLS.bind((String)SecAuthMessages.unableToReadPswdFile, (Object)arg);
            AuthPlugin.getDefault().logError(msg, null);
            return options;
        }
        try {
            Throwable msg = null;
            Object var4_7 = null;
            try (Stream<String> lines = Files.lines(file);){
                StringBuilder buffer = new StringBuilder();
                lines.forEach(buffer::append);
                if (buffer.isEmpty()) {
                    return options;
                }
                if (options == null) {
                    options = new HashMap<Object, Object>(1);
                }
                if (!options.containsKey("org.eclipse.equinox.security.storage.defaultPassword")) {
                    options.put("org.eclipse.equinox.security.storage.defaultPassword", new PBEKeySpec(buffer.toString().toCharArray()));
                }
            }
            catch (Throwable throwable) {
                if (msg == null) {
                    msg = throwable;
                } else if (msg != throwable) {
                    msg.addSuppressed(throwable);
                }
                throw msg;
            }
        }
        catch (IOException e) {
            String msg = NLS.bind((String)SecAuthMessages.unableToReadPswdFile, (Object)arg);
            AuthPlugin.getDefault().logError(msg, e);
        }
        return options;
    }
}

