/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.AbstractSourceFileExtensions;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CppSourceFileExtensions
extends AbstractSourceFileExtensions {
    public CppSourceFileExtensions(NamedElement parent) {
        super(parent, new HashSet<String>(Arrays.asList(CPlusPlusFileType.CPP_SOURCE.getExtensions())));
    }

    public CppSourceFileExtensions(NamedElement parent, Set<String> extensions) {
        super(parent, extensions);
    }

    @Override
    public String getDefaultSourceFileExtension() {
        return CPlusPlusFileType.CPP_SOURCE.getDefaultExtension();
    }

    public static class Validator
    implements ITextValidator {
        private static final String COMMON_REGEXP = "[a-zA-Z0-9+]+";
        private static String REGEXP_ALLOWED = "\\.[a-zA-Z0-9+]+";
        private static String REGEXP_HEADER = "\\.h[a-zA-Z0-9+]*";

        public ValidationResult isValid(String initialInput, String newInput) {
            String input;
            ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)initialInput, (String)newInput));
            String string = input = newInput != null ? newInput.trim() : null;
            if (input == null || input.isEmpty()) {
                result.addError("Must not be empty");
                return result;
            }
            String[] extensions = input.split(",");
            HashSet<String> uniqueExtensions = new HashSet<String>();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                String trimmedExtension = extension.trim();
                if (!trimmedExtension.matches(REGEXP_ALLOWED)) {
                    result.addError("Extension '" + trimmedExtension + "' does not match allowed pattern");
                } else if (trimmedExtension.matches(REGEXP_HEADER)) {
                    result.addError("Header files '" + trimmedExtension + "' must not be included");
                } else if (!uniqueExtensions.add(trimmedExtension)) {
                    result.addWarning("Duplicate extension '" + trimmedExtension + "' will be ignored");
                }
                ++n2;
            }
            return result;
        }
    }
}

