/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ArrayOf;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.BasicType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ConstVolatileModifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.FunctionReturning;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.LiteralTypeName;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.NotImplemented;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.PointerTo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.PointerToMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.ReferenceTo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.TemplateType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.Type;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.VariableParameterList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class CppSignatureParser {
    public static String UNDEFINED = "v";
    public static String UNDEFINED_ROUTINE = "()v";
    protected String m_signature;

    protected CppSignatureParser(String sig) {
        this.m_signature = sig;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public boolean isFunction() {
        return this.m_signature.startsWith("(");
    }

    protected Type createPointerToMember(String name, Type type) {
        return new PointerToMember(name, type);
    }

    private Type parseSignature(StringReader reader) throws IOException {
        reader.mark(1);
        int ch = reader.read();
        Type result = null;
        if (ch == 36) {
            boolean isConst = false;
            boolean isVolatile = false;
            ch = reader.read();
            if (ch == 99) {
                isConst = true;
                ch = reader.read();
            }
            if (ch == 118) {
                isVolatile = true;
                ch = reader.read();
            }
            assert (ch == 36) : "unexpected signature character (expected '$')" + (char)ch;
            return ConstVolatileModifier.get(this.parseSignature(reader), isConst, isVolatile);
        }
        switch (ch) {
            case 33: {
                result = ConstVolatileModifier.get(this.parseSignature(reader), true, false);
                break;
            }
            case 42: {
                result = new PointerTo(this.parseSignature(reader));
                break;
            }
            case 38: {
                result = new ReferenceTo(this.parseSignature(reader), false);
                break;
            }
            case 126: {
                result = new ReferenceTo(this.parseSignature(reader), true);
                break;
            }
            case 91: {
                result = new ArrayOf(this.parseSignature(reader));
                break;
            }
            case 40: {
                result = this.handleFunction(reader);
                break;
            }
            case 96: {
                result = new PointerToMember(this.readUntilSemicolon(reader), this.parseSignature(reader));
                break;
            }
            case 60: {
                result = this.handleTemplate(reader);
                break;
            }
            default: {
                reader.reset();
                result = this.parsePrimitive(reader);
            }
        }
        return result;
    }

    protected final Type createTemplateType(Type template, List<Type> parameters) {
        return new TemplateType((LiteralTypeName)template, parameters);
    }

    private Type handleTemplate(StringReader reader) throws IOException {
        ArrayList<Type> parameters = new ArrayList<Type>();
        reader.mark(1);
        while (reader.read() != 62) {
            reader.reset();
            parameters.add(this.parseSignature(reader));
            reader.mark(1);
        }
        return this.createTemplateType(this.parseSignature(reader), parameters);
    }

    private Type handleFunction(StringReader reader) throws IOException {
        ArrayList<Type> parameters = new ArrayList<Type>();
        ArrayList<Type> throwList = new ArrayList<Type>();
        reader.mark(1);
        while (reader.read() != 41) {
            reader.reset();
            parameters.add(this.parseSignature(reader));
            reader.mark(1);
        }
        Type returnType = this.parseSignature(reader);
        reader.mark(1);
        if (reader.read() == 40) {
            reader.mark(1);
            while (reader.read() != 41) {
                reader.reset();
                throwList.add(this.parseSignature(reader));
                reader.mark(1);
            }
        } else {
            reader.reset();
        }
        return new FunctionReturning(parameters, returnType, throwList);
    }

    private String readUntilSemicolon(StringReader reader) throws IOException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while ((ch = reader.read()) != 59) {
            buffer.append((char)ch);
        }
        return buffer.toString();
    }

    private Type parsePrimitive(StringReader reader) throws IOException {
        int ch = reader.read();
        Type result = BasicType.getByEncoding(ch);
        if (result == null) {
            switch (ch) {
                case 63: {
                    result = NotImplemented.INSTANCE;
                    break;
                }
                case 46: {
                    result = VariableParameterList.INSTANCE;
                    break;
                }
                case 78: {
                    result = new LiteralTypeName(this.readUntilSemicolon(reader));
                    break;
                }
                default: {
                    assert (false) : "invalid signature character " + (char)ch;
                    break;
                }
            }
        }
        assert (result != null);
        return result;
    }

    public Type getType() {
        StringReader reader = new StringReader(this.m_signature);
        try {
            return this.parseSignature(reader);
        }
        catch (IOException e) {
            assert (false) : "StringReader throws IOException: " + e.getMessage();
            return null;
        }
    }
}

