/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CppElement
implements IPersistable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CppElement.class);
    private static final String DEPENDENCIES = "dependencies";
    private static final String NAME = "name";
    private CppElement m_parent;
    private String m_name;
    private List<CppElement> m_children = null;
    private List<Dependency> m_dependencies = null;

    public CppElement() {
        this.m_parent = null;
        this.m_name = null;
    }

    public CppElement(CppElement parent, String name) {
        assert (name != null) : "Parameter 'name' of method 'CppElement' must not be null";
        this.m_parent = parent;
        this.m_name = name;
    }

    public abstract CppElement getSource();

    public boolean isExternal() {
        return this.m_parent.isExternal();
    }

    public abstract String getKey();

    public List<CppElement> getChildren() {
        if (this.m_children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_children);
    }

    public Dependency getDependencyAt(int index) {
        assert (this.m_dependencies != null);
        return this.m_dependencies.get(index);
    }

    public boolean hasDependencies() {
        return this.m_dependencies != null;
    }

    public List<Dependency> getDependencies() {
        if (this.m_dependencies == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_dependencies);
    }

    public boolean hasChildren() {
        return this.m_children != null;
    }

    public String getNamespace() {
        return null;
    }

    public List<? extends IPersistable> getPersistableChildren() {
        return this.getChildren();
    }

    public int getLineNo() {
        return -1;
    }

    public void addChild(CppElement child) {
        assert (child != null) : "Parameter 'child' of method 'addChild' must not be null";
        if (this.m_children == null) {
            this.m_children = new ArrayList<CppElement>();
        }
        this.m_children.add(child);
    }

    public final CppElement getParent() {
        return this.m_parent;
    }

    public final String getName() {
        return this.m_name;
    }

    public String getPresentationName() {
        return this.m_name;
    }

    public void addDependency(CppElement to, CppDependencyType type, int lineNo) {
        if (type == null) {
            LOGGER.error("Dependency initialized with type null: ", (Throwable)new IllegalArgumentException());
            return;
        }
        if (this.m_dependencies == null) {
            this.m_dependencies = new ArrayList<Dependency>();
        }
        this.m_dependencies.add(new Dependency(to, type, lineNo));
    }

    public void linkParent(IPersistable parent) {
        CppElement p;
        assert (parent instanceof CppElement);
        this.m_parent = p = (CppElement)parent;
        this.m_parent.addChild(this);
    }

    public boolean isFunction() {
        return false;
    }

    public List<CppElement> getChildren(Predicate<CppElement> predicate) {
        ArrayList<CppElement> result = new ArrayList<CppElement>();
        for (CppElement child : this.getChildren()) {
            if (!predicate.test(child)) continue;
            result.add(child);
        }
        return result;
    }

    public <T extends CppElement> List<T> getChildren(Class<T> cls) {
        return this.getChildren(e -> true, cls);
    }

    public <T extends CppElement> List<T> getChildren(Predicate<T> predicate, Class<T> cls) {
        ArrayList<CppElement> result = new ArrayList<CppElement>();
        for (CppElement child : this.getChildren()) {
            if (!cls.isAssignableFrom(child.getClass()) || !predicate.test(child)) continue;
            result.add(child);
        }
        return result;
    }

    public <T extends CppElement> T getFirstChild(Predicate<T> predicate, Class<T> cls) {
        for (CppElement child : this.getChildren()) {
            if (!cls.isAssignableFrom(child.getClass()) || !predicate.test(child)) continue;
            return (T)child;
        }
        return null;
    }

    public final <T extends CppElement> T getParent(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getParent' must not be null";
        CppElement parent = this.getParent();
        while (parent != null) {
            if (clazz.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public void writeAttributes(IObjectWriter writer) throws IOException {
        writer.writeString(NAME, this.m_name);
        if (this.m_dependencies == null) {
            writer.writeOwnedObjects(DEPENDENCIES, null);
        } else {
            writer.writeOwnedObjects(DEPENDENCIES, (IPersistable[])this.m_dependencies.toArray(new Dependency[this.m_dependencies.size()]));
        }
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        this.m_name = reader.readString(NAME);
        Dependency[] deps = (Dependency[])reader.readOwnedObjects(DEPENDENCIES, Dependency.class);
        if (deps != null && deps.length > 0) {
            this.m_dependencies = new ArrayList<Dependency>();
            int i = 0;
            while (i < deps.length) {
                this.m_dependencies.add(deps[i]);
                ++i;
            }
        }
    }

    public String getLocation() {
        return this.getSource().getName() + ":" + this.getLineNo();
    }

    public void accept(Visitor visitor) {
        visitor.visitChildrenOf(this);
    }

    public String toString() {
        return this.getName();
    }

    public static class Dependency
    implements IPersistable {
        private static final String TYPE = "type";
        private static final String LINE_NO = "lineNo";
        private static final String TO = "to";
        private CppElement m_to;
        private CppDependencyType m_type;
        private int m_lineNo;

        public Dependency() {
        }

        private Dependency(CppElement to, CppDependencyType type, int lineNo) {
            assert (to != null);
            assert (type != null);
            this.m_to = to;
            this.m_type = type;
            this.m_lineNo = lineNo;
        }

        public CppElement getTo() {
            return this.m_to;
        }

        public CppDependencyType getType() {
            return this.m_type;
        }

        public int getLineNo() {
            return this.m_lineNo;
        }

        public void writeAttributes(IObjectWriter writer) throws IOException {
            writer.writeObjectReference(TO, (IPersistable)this.m_to);
            writer.writeInt(LINE_NO, this.m_lineNo);
            writer.writeEnumConstant(TYPE, (Enum)this.m_type);
        }

        public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
            reader.readObjectReference(TO, CppElement.class, r -> {
                CppElement cppElement = this.m_to = r;
            });
            this.m_lineNo = reader.readInt(LINE_NO);
            this.m_type = (CppDependencyType)reader.readEnumConstant(TYPE, CppDependencyType.class);
            if (this.m_type == null) {
                LOGGER.error("Dependency restored with type null: ", (Throwable)new IllegalArgumentException());
                this.m_type = CppDependencyType.USES;
            }
        }
    }

    public static class Visitor {
        protected void visitChildrenOf(CppElement element) {
            element.getChildren().forEach(e -> e.accept(this));
        }
    }
}

