/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IScmExtension;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.ModuleDelta;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusFileConsumer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DiagnosticMode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ErrorMessage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.IParserResultHandler;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParserContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingService;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CppAccessSpecifier;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementWithSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionSpec;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElementProxy;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppSourceFileElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppStructuredType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CompilationUnitFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppExternalHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppIncludeDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClass;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppEnumeration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppEnumerationConstant;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppField;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMacro;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMacroInvocation;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMethodType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppNamespaceFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutineDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppStruct;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppStructDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppTypedef;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppUnionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppVariable;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppHasSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppMemberFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.IHasFqnSerialNumber;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppAddressTakenDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppByNameDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppByNameDependencyWithLine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppCallDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppCastDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDeclaresDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDeleteDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDynamicCastDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppFieldTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppInheritsFrom;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppInitializeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppLocalVariableTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppMacroInvocationDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppNewDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppParameterTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppPointerToMemberDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppReadDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppReturnTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppSizeofDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppTemplateParameterTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppThrowTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppTypedefDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppTypedefTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppUsesDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppVariableTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppVirtualCallDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppVirtuallyInheritsFrom;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppWriteDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusExternal;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CppElementVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusParserConfigurationProvider;
import com.hello2morrow.sonargraph.scm.IScmDataAndConfigurationProvider;
import com.hello2morrow.sonargraph.scm.ScmManager;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RefreshJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(RefreshJob.class);
    private static final int DEFAULT_NUMBER_OF_DAEMONS = 8;
    private static final String SONARGRAPH_DAEMONS = "SONARGRAPH_DAEMONS";
    private final CPlusPlusFileConsumer m_fileConsumer;
    private final Set<CppSourceFile> m_filesToParse = new LinkedHashSet<CppSourceFile>();
    private final LanguageProvider m_languageProvider;
    private final ParserModel m_factsModel;
    private final SoftwareSystem m_softwareSystem;
    private final ParserContext m_parserContext;
    private final ParsingService m_parsingService;
    private final Map<CppSource, MultipleValueMap<String, ProgrammingElement>> m_elementMappings = new THashMap();
    private final MultipleValueMap<String, CppTypedef> m_typedefs = new MultipleValueMap();
    private final String m_action;

    RefreshJob(SoftwareSystem system, LanguageProvider languageProvider, ICPlusPlusParserConfigurationProvider configProvider, OperationResult result, List<ModuleDelta> moduleDeltas, TFile diagnosticsDir, boolean isPreprocessingOnly) {
        assert (system != null) : "Parameter 'system' of method 'RefreshJob' must not be null";
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'RefreshJob' must not be null";
        assert (configProvider != null) : "Parameter 'configProvider' of method 'RefreshJob' must not be null";
        assert (result != null);
        assert (moduleDeltas != null && !moduleDeltas.isEmpty()) : "Parameter 'moduleDeltas' of method 'RefreshJob' must not be empty";
        assert (diagnosticsDir != null) : "Parameter 'diagnosticsDir' of method 'RefreshJob' must not be null";
        this.m_languageProvider = languageProvider;
        moduleDeltas.stream().filter(d -> !d.isEmpty()).forEach(d -> this.cleanup((ModuleDelta)d));
        String daemonCountStr = System.getenv(SONARGRAPH_DAEMONS);
        int daemonCount = 8;
        if (daemonCountStr != null) {
            try {
                LOGGER.info("Processing daemon count provided via environment variable '{}'={}", (Object)SONARGRAPH_DAEMONS, (Object)daemonCountStr);
                daemonCount = Integer.valueOf(daemonCountStr);
                if (daemonCount < 1) {
                    daemonCount = 1;
                } else if (daemonCount > 16) {
                    daemonCount = 16;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("Invalid value of environment variable {}: {}", (Object)SONARGRAPH_DAEMONS, (Object)daemonCountStr);
            }
        }
        ScmManager manager = ScmManager.getInstance();
        List<TFile> scmRoots = manager.getScmRootDirectories((IScmDataAndConfigurationProvider)system.getExtension(IScmExtension.class)).stream().map(f -> new TFile(f)).collect(Collectors.toList());
        this.m_parsingService = new ParsingService(system, diagnosticsDir, DiagnosticMode.INTERNAL_ERRORS, configProvider, (IAddedOrChangedSourceFileProcessor)languageProvider, result);
        this.m_fileConsumer = new CPlusPlusFileConsumer(this.m_parsingService, isPreprocessingOnly);
        this.m_action = isPreprocessingOnly ? "Preprocessing" : "Parsing";
        this.m_softwareSystem = system;
        this.m_parserContext = new ParserContext(languageProvider, system, scmRoots);
        this.m_parserContext.setSystemIncludeDirectories(this.m_parsingService.getDefinition().getSystemInclueDirectories());
        this.m_factsModel = system.getParserModel();
        ((Workspace)system.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)new PrepareModelForReparseVisitor());
        this.m_fileConsumer.aboutToParse(system);
    }

    private void cleanup(ModuleDelta delta) {
        CleanupVisitor visitor = new CleanupVisitor();
        delta.visitDeleted((ModuleDelta.IVisitor)visitor);
        delta.visitModified((ModuleDelta.IVisitor)visitor);
    }

    private void addSourceFileToParsingQueue(CppSourceFile cppSourceFile, OperationResult result) throws IOException {
        assert (cppSourceFile != null) : "'cppSourceFile' must not be null";
        this.m_fileConsumer.addToQueue((CPlusPlusModule)((Object)cppSourceFile.getParent(CPlusPlusModule.class, new Class[0])), cppSourceFile, result);
    }

    private void processModifiedFile(CppSourceFile file) {
        assert (file != null) : "'file' must not be null";
        file.setTimestamp(file.getFile().lastModified());
        this.m_languageProvider.processAddedOrChangedSourceFile((SourceFile)file);
        this.m_filesToParse.add(file);
    }

    private void processAddedFile(RootDirectoryPath root, TFile file, CPlusPlusFileType fileType) {
        assert (file != null) : "'file' must not be null";
        assert (fileType != null) : "'fileType' must not be null";
        assert (root != null) : "'root' must not be null";
        String relativePath = FileUtility.calculateRelativePath((TFile)file.getParentFile(), (TFile)root.getDirectoryFile());
        IDirectoryPath parentOfFile = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)root, (String)relativePath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new CppDirectoryFragment(msp, parent, name);
            }
        });
        switch (fileType) {
            case CPP_SOURCE: 
            case C_SOURCE: {
                CppSourceFile sourceFile = new CppSourceFile((IModelServiceProvider)this.m_softwareSystem, parentOfFile.getNamedElement(), file);
                parentOfFile.getNamedElement().addChild((NamedElement)sourceFile);
                this.m_filesToParse.add(sourceFile);
                this.m_parserContext.addSourceFile(sourceFile);
                sourceFile.setTimestamp(1L);
                break;
            }
            default: {
                assert (false) : "Not a source file: " + String.valueOf(file);
                break;
            }
        }
    }

    void refreshModule(ModuleDelta delta, OperationResult result) {
        assert (!delta.isEmpty()) : "m_delta must not be empty";
        delta.visitAdded((ModuleDelta.IVisitor)new DeltaVisitor());
        delta.visitModified((ModuleDelta.IVisitor)new DeltaVisitor());
        int numberOfFiles = this.m_filesToParse.size();
        String moduleShortName = delta.getModule().getShortName();
        LOGGER.info("Start {} {} files of module '{}'", new Object[]{this.m_action.toLowerCase(), numberOfFiles, moduleShortName});
        for (CppSourceFile nextCppSourceFile : this.m_filesToParse) {
            try {
                this.addSourceFileToParsingQueue(nextCppSourceFile, result);
            }
            catch (IOException ex) {
                result.addWarning((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)ex);
                break;
            }
        }
        this.m_filesToParse.clear();
    }

    private void addTypedef(CppTypedef typedef) {
        assert (typedef != null) : "Parameter 'typedef' of method 'addTypedef' must not be null";
        if (!(typedef.getParent() instanceof CppClassStructUnion)) {
            this.m_typedefs.put((Object)typedef.getName(), (Object)typedef);
        }
    }

    private void checkDuplicateTypedefs() {
        for (String name : this.m_typedefs.keySet()) {
            List typedefs = this.m_typedefs.get((Object)name);
            if (typedefs.size() <= 1) continue;
            for (CppTypedef td : typedefs) {
                List deps = td.getIncomingDependencies(new IStandardEnumeration[0]);
                for (ParserDependency dep : deps) {
                    ProgrammingElement from = dep.getFrom();
                    ProgrammingElement to = dep.getTo();
                    from.removeDependency(dep);
                    CppTypedefDependency newDep = new CppTypedefDependency(from, to);
                    from.addDependencyIfNotPresent((ParserDependency)newDep);
                }
            }
        }
        this.m_typedefs.clear();
    }

    private void removeExternalTemplateImplementations(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'removeExternalTemplateImplementations' must not be null";
        ((Workspace)system.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)new ExternalTemplateImplementationRemover());
    }

    void finishRefresh(IWorkerContext workerContext, SoftwareSystem system, boolean systemWillBeCleared) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishRefresh' must not be null";
        assert (system != null) : "Parameter 'system' of method 'finishRefresh' must not be null";
        this.m_parserContext.processParserLog();
        if (!systemWillBeCleared) {
            Workspace ws = (Workspace)system.getUniqueExistingChild(Workspace.class);
            ws.accept((NamedElement.INamedElementVisitor)new DependencyCleaner());
            workerContext.working("Finish refresh for C,C++", true);
            this.m_parserContext.parsingFinished(true);
            this.m_fileConsumer.parsingFinished(system);
            this.removeExternalTemplateImplementations(system);
            this.removeUnreferencedHeaders(system);
            this.removeUnreferencedExternals(system);
            this.checkDuplicateTypedefs();
            ws.accept((NamedElement.INamedElementVisitor)new CompilationUnitFragmentCleaner());
            ws.accept((NamedElement.INamedElementVisitor)new CheckFqns());
            ws.accept((NamedElement.INamedElementVisitor)new HandleByNameDependencies());
        } else {
            this.m_parserContext.parsingFinished(false);
            this.m_parserContext.reset();
        }
    }

    private void removeUnreferencedHeaders(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'removeUnreferencedHeaders' must not be null";
        RemoveUnreferencedHeaderVisitor headerCleanupVisitor = new RemoveUnreferencedHeaderVisitor();
        do {
            ((Workspace)system.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)headerCleanupVisitor);
        } while (headerCleanupVisitor.headersWereRemoved());
    }

    private void removeUnreferencedExternals(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'removeUnreferencedExternals' must not be null";
        ((Workspace)system.getUniqueExistingChild(Workspace.class)).accept((NamedElement.INamedElementVisitor)new RemoveUnreferencedExternalsVisitor(this.m_factsModel));
    }

    boolean retrieveParsingResultsAndCreateModel(IWorkerContext workerContext, OperationResult result) {
        ParsingResultHandler resultHandler = new ParsingResultHandler(result);
        boolean anySuccess = this.m_parsingService.processRequests(workerContext, resultHandler);
        resultHandler.finish(anySuccess);
        return anySuccess;
    }

    private static class CheckFqns
    extends NamedElementVisitor
    implements CppClassStructUnionDefinition.IVisitor,
    CppSource.IVisitor,
    CppNamespaceFragment.IVisitor,
    CppClassStructUnionNamespace.IVisitor {
        private final List<CppClassStructUnionNamespace> m_invalidLeftovers = new ArrayList<CppClassStructUnionNamespace>();

        private CheckFqns() {
        }

        private void processElement(NamedElement element) {
            MultipleValueMap fqnMap = new MultipleValueMap();
            for (IHasFqnSerialNumber child : element.getChildren(IHasFqnSerialNumber.class)) {
                child.setSerialNumberForQualifiedName((short)0);
                String fqnPart = child.getFullyQualifiedNamePart();
                List sameFqn = fqnMap.get((Object)fqnPart);
                child.setSerialNumberForQualifiedName((short)sameFqn.size());
                fqnMap.put((Object)fqnPart, (Object)child);
            }
            this.visitChildrenOf(element);
        }

        @Override
        public void visitCppNamespaceFragment(CppNamespaceFragment element) {
            this.processElement((NamedElement)element);
        }

        @Override
        public void visitCppSource(CppSource element) {
            this.processElement((NamedElement)element);
            this.m_invalidLeftovers.forEach(e -> e.remove());
            this.m_invalidLeftovers.clear();
        }

        @Override
        public void visitCppClassStructUnionDefinition(CppClassStructUnionDefinition element) {
            this.processElement((NamedElement)element);
        }

        private void addProxy(CppClassStructUnion csu, NamedElement e) {
            NamedElementProxy p = csu.getChildren(NamedElementProxy.class).stream().filter(pr -> pr.getElement() == e).findFirst().orElse(null);
            if (p == null) {
                String fqnPart = e.getFullyQualifiedNamePart();
                if (!csu.getChildren().stream().anyMatch(ne -> ne.getFullyQualifiedNamePart().equals(fqnPart))) {
                    csu.addChild((NamedElement)new NamedElementProxy((NamedElement)csu, e));
                }
            }
        }

        @Override
        public void visitCppClassStructUnionNamespace(CppClassStructUnionNamespace element) {
            if (element.isValid()) {
                this.processElement((NamedElement)element);
                CppClassStructUnion csu = element.getReferencedType();
                for (NamedElement e : element.getChildren()) {
                    ParserDependency dep;
                    CppRoutine mf;
                    if (e instanceof CppField) {
                        this.addProxy(csu, e);
                        continue;
                    }
                    if (e instanceof CppMemberFunctionDeclaration) {
                        mf = (CppMemberFunctionDeclaration)e;
                        dep = mf.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.DECLARES}).stream().findFirst().orElse(null);
                        if (dep != null) continue;
                        this.addProxy(csu, e);
                        continue;
                    }
                    if (e instanceof CppMemberFunction) {
                        mf = (CppMemberFunction)e;
                        dep = mf.getIncomingDependencies(new IStandardEnumeration[]{CppDependencyType.DECLARES}).stream().findFirst().orElse(null);
                        if (dep == null) {
                            this.addProxy(csu, e);
                            continue;
                        }
                        if (!(dep.getFrom().getParent() instanceof CppClassStructUnionNamespace)) continue;
                        this.addProxy(csu, e);
                        continue;
                    }
                    if (e instanceof CppVariable) {
                        CppVariable var = (CppVariable)e;
                        if (!var.isDefinition()) continue;
                        dep = var.getIncomingDependencies(new IStandardEnumeration[]{CppDependencyType.DECLARES}).stream().findFirst().orElse(null);
                        if (dep == null) {
                            this.addProxy(csu, e);
                            continue;
                        }
                        if (!(dep.getFrom().getParent() instanceof CppClassStructUnionNamespace)) continue;
                        this.addProxy(csu, e);
                        continue;
                    }
                    if (!(e instanceof CppTypedef)) continue;
                    this.addProxy(csu, e);
                }
            } else {
                this.m_invalidLeftovers.add(element);
            }
        }
    }

    private class CleanupVisitor
    implements ModuleDelta.IVisitor {
        private CleanupVisitor() {
        }

        public void deleted(ModuleDelta delta, FilePath filePath) {
            CppSource source = (CppSource)filePath;
            for (ProgrammingElement element : source.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                element.removeDependencies(false);
            }
            source.discardChildren();
            source.remove();
        }

        public void modified(ModuleDelta delta, FilePath filePath) {
            CppSource source = (CppSource)filePath;
            for (ProgrammingElement element : source.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
                element.removeDependencies(false);
            }
            source.discardChildren();
            if (source.isIncludeFile()) {
                source.remove();
            } else {
                filePath.getIssueManager().removeElementIssues((ElementWithIssues)source);
            }
        }

        public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
        }
    }

    private class CompilationUnitFragmentCleaner
    extends NamedElementVisitor
    implements CompilationUnitFragment.IVisitor,
    CppHeader.IVisitor,
    CppSourceFile.IVisitor {
        private CompilationUnitFragmentCleaner() {
        }

        @Override
        public void visitCppCompilationUnitFragment(CompilationUnitFragment element) {
            if (!element.getAssociatedHeader().isValid()) {
                element.remove();
            } else {
                this.visitChildrenOf((NamedElement)element);
            }
        }

        @Override
        public void visitCppSourceFile(CppSourceFile element) {
            for (CompilationUnitFragment frag : element.getChildren(CompilationUnitFragment.class)) {
                frag.accept(this);
            }
        }

        @Override
        public void visitCppHeader(CppHeader element) {
        }
    }

    private class DeltaVisitor
    implements ModuleDelta.IVisitor {
        private DeltaVisitor() {
        }

        public void added(RootDirectoryPath root, IFileType fileType, TFile file) {
            RefreshJob.this.processAddedFile(root, file, (CPlusPlusFileType)fileType);
        }

        public void deleted(ModuleDelta delta, FilePath filePath) {
        }

        public void modified(ModuleDelta delta, FilePath filePath) {
            RefreshJob.this.processModifiedFile((CppSourceFile)filePath);
        }
    }

    private class DependencyCleaner
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor {
        private DependencyCleaner() {
        }

        public void visitProgrammingElement(ProgrammingElement element) {
            Iterator iter = element.getDependencyIterator();
            while (iter.hasNext()) {
                ParserDependency dep = (ParserDependency)iter.next();
                ProgrammingElement from = dep.getFrom();
                if (from != element) {
                    if (from.isValid()) continue;
                    iter.remove();
                    continue;
                }
                if (dep.getTo().isValid()) continue;
                iter.remove();
            }
            this.visitChildrenOf((NamedElement)element);
        }
    }

    private class ExternalTemplateImplementationRemover
    extends NamedElementVisitor
    implements External.IVisitor,
    CPlusPlusModule.IVisitor,
    CppMemberFunction.IVisitor {
        private final Set<CppExternalHeaderFile> m_toBeDeleted = new THashSet();

        private ExternalTemplateImplementationRemover() {
        }

        @Override
        public void visitCppMemberFunction(CppMemberFunction element) {
            CppExternalHeaderFile toFile;
            CppMemberFunctionDeclaration decl;
            CppHeader fromFile;
            ParserDependency declaresDep = element.getIncomingDependencies(new IStandardEnumeration[]{CppDependencyType.DECLARES}).stream().findFirst().orElse(null);
            if (declaresDep != null && (fromFile = (CppHeader)((Object)(decl = (CppMemberFunctionDeclaration)declaresDep.getFrom()).getParent(CppHeader.class, new Class[0]))) != (toFile = (CppExternalHeaderFile)((Object)element.getParent(CppExternalHeaderFile.class, new Class[0])))) {
                element.transferIncomingDependenciesTo((ProgrammingElement)decl);
                this.m_toBeDeleted.add(toFile);
            }
        }

        @Override
        public void visitCPlusPlusModule(CPlusPlusModule obj) {
        }

        public void visitExternal(External element) {
            this.visitChildrenOf((NamedElement)element);
            this.m_toBeDeleted.forEach(header -> header.remove());
        }
    }

    private static class HandleByNameDependencies
    extends NamedElementVisitor
    implements CppClassStructUnionDefinition.IVisitor,
    CppEnumeration.IVisitor,
    CppClassStructUnionDeclaration.IVisitor {
        public HandleByNameDependencies() {
            super(true);
        }

        @Override
        public void visitCppClassStructUnionDefinition(CppClassStructUnionDefinition element) {
            boolean isExternal = element.isExternal();
            List byNameDeps = element.getIncomingDependencies(new IStandardEnumeration[]{CppDependencyType.BY_NAME});
            if (byNameDeps.isEmpty()) {
                return;
            }
            MultipleValueMap incomingMap = new MultipleValueMap();
            for (ParserDependency dep : element.getIncomingDependencies(new IStandardEnumeration[0])) {
                if (dep.getDependencyType() == CppDependencyType.BY_NAME) continue;
                incomingMap.put((Object)dep.getFrom(), (Object)dep);
            }
            for (ParserDependency byNameDep : byNameDeps) {
                ProgrammingElement byNameFrom = byNameDep.getFrom();
                if (isExternal && byNameFrom.isExternal()) continue;
                List incomingDeps = byNameFrom.getIncomingDependencies(new IStandardEnumeration[0]);
                for (ParserDependency dep : incomingDeps) {
                    ProgrammingElement from = dep.getFrom();
                    boolean found = false;
                    for (ParserDependency innerDep : incomingMap.get((Object)from)) {
                        if (innerDep.getDependencyType() != dep.getDependencyType() || innerDep.getLineNumber() != dep.getLineNumber()) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        CppByNameDependencyWithLine newDep = new CppByNameDependencyWithLine(from, (ProgrammingElement)element, dep.getLineNumber());
                        from.addDependencyIfNotPresent((ParserDependency)newDep);
                    }
                    dep.remove();
                }
                assert (byNameFrom instanceof CppClassStructUnionDeclaration);
                byNameFrom.remove();
            }
        }

        @Override
        public void visitCppClassStructUnionDeclaration(CppClassStructUnionDeclaration element) {
            if (element.getDefinition() == null) {
                if (element.hasIssues(new IIssueId[0])) {
                    List deps = element.getIncomingDependencies(new IStandardEnumeration[0]);
                    for (ParserDependency dep : deps) {
                        dep.remove();
                    }
                } else {
                    element.remove();
                }
            }
        }

        @Override
        public void visitCppEnumeration(CppEnumeration element) {
            if (!element.isDefinition()) {
                for (ParserDependency dep : element.getIncomingDependencies(new IStandardEnumeration[0])) {
                    ProgrammingElement from = dep.getFrom();
                    int line = dep.getLineNumber();
                    dep.remove();
                    CppByNameDependencyWithLine newDep = new CppByNameDependencyWithLine(from, (ProgrammingElement)element, line);
                    from.addDependencyIfNotPresent((ParserDependency)newDep);
                }
            }
        }
    }

    private static interface IProcessor {
        public void process();
    }

    private final class ParsingResultHandler
    implements IParserResultHandler {
        private final OperationResult m_result;
        private final Map<CppElement, NamedElement> m_elementMap = new THashMap();
        private final List<IProcessor> m_processors = new ArrayList<IProcessor>();
        private MultipleValueMap<String, ProgrammingElement> m_currentMap;
        private final MultipleValueMap<String, ProgrammingElement> m_anonymousStructsOrUnions = new MultipleValueMap();
        private final List<CppClassStructUnionDeclaration> m_structTypeDecls = new ArrayList<CppClassStructUnionDeclaration>();
        private final List<CppRoutine> m_routineDecls = new ArrayList<CppRoutine>();
        private final Set<CppVariable> m_undefinedVariables = new THashSet();
        private final List<ProgrammingElement> m_definitions = new ArrayList<ProgrammingElement>();

        private boolean mapElement(CppElement key, NamedElement element) {
            assert (key != null);
            assert (element != null);
            MappingChecker checker = new MappingChecker(element);
            key.accept(checker);
            if (checker.m_value == null) {
                return false;
            }
            this.m_elementMap.put(key, checker.m_value);
            return true;
        }

        private ParsingResultHandler(OperationResult result) {
            this.m_result = result;
            RefreshJob.this.m_parserContext.setResult(result);
        }

        @Override
        public void processParserResult(ParsingResult result) {
            result.getMessages().forEach(msg -> RefreshJob.this.m_parserContext.logErrorMessage((ErrorMessage)msg));
            CppSourceFileElement primarySource = result.getModel().getFirstChild(c -> true, CppSourceFileElement.class);
            this.mapElement(primarySource, (NamedElement)result.getSourceFile());
            this.buildCompilationUnitFragments((NamedElement)result.getSourceFile(), primarySource);
            RefreshJob.this.m_parserContext.processExternals();
            this.buildModel(result.getModel());
            this.processMacroInvocations(result.getModel());
            this.processDependencies();
            for (String key : this.m_anonymousStructsOrUnions.keySet()) {
                List elements = this.m_anonymousStructsOrUnions.get((Object)key);
                if (elements.size() != 2) continue;
                Iterator iter = elements.iterator();
                ProgrammingElement first = (ProgrammingElement)iter.next();
                ProgrammingElement second = (ProgrammingElement)iter.next();
                if (first.getParent() instanceof CppSource) {
                    second.mergeDependenciesFrom(first);
                    second.remove();
                    continue;
                }
                first.mergeDependenciesFrom(second);
                first.remove();
            }
            this.m_anonymousStructsOrUnions.clear();
            this.m_elementMap.clear();
            this.m_currentMap = null;
        }

        @Override
        public void failedToParse(ParsingResult result) {
            result.reportFailureMessage(this.m_result);
            result.getMessages().forEach(msg -> RefreshJob.this.m_parserContext.logErrorMessage((ErrorMessage)msg));
            result.getSourceFile().setTimestamp(1L);
        }

        @Override
        public void internalError(ParsingResult result, Throwable ex) {
            this.m_result.addError((OperationResult.IMessageCause)CppCauses.PARSING_REQUEST_FAILED, "Internal error (" + ex.getClass().getName() + ": " + ex.getMessage() + ") while parsing " + result.getSourceFile().getName(), new Object[0]);
        }

        private Set<String> getKeySet(CppSourceFileElement header) {
            KeyCollector collector = new KeyCollector();
            header.accept(collector);
            return collector.m_keys;
        }

        private void buildCompilationUnitFragments(NamedElement parent, CppSourceFileElement src) {
            for (CppElement.Dependency dep : src.getDependencies()) {
                if (dep.getType() != CppDependencyType.INCLUDES) continue;
                CppSourceFileElement included = (CppSourceFileElement)dep.getTo();
                Set<String> keys = this.getKeySet(included);
                CppHeader header = RefreshJob.this.m_parserContext.getHeader(included.getName(), keys, src.getName(), dep.getLineNo());
                if (header == null) {
                    LOGGER.error("Header file " + included.getName() + " cannot be located on the disk.");
                    continue;
                }
                this.mapElement(included, (NamedElement)header);
                CompilationUnitFragment existingFrag = parent.getChildren(CompilationUnitFragment.class).stream().filter(f -> f.getAssociatedHeader() == header && f.getLineNumber() == dep.getLineNo()).findFirst().orElse(null);
                if (existingFrag == null) {
                    CompilationUnitFragment fragment = new CompilationUnitFragment(parent, header, dep.getLineNo());
                    parent.addChild((NamedElement)fragment);
                    header.addFragment(fragment);
                    this.buildCompilationUnitFragments((NamedElement)fragment, included);
                    continue;
                }
                this.buildCompilationUnitFragments((NamedElement)existingFrag, included);
            }
        }

        private CppNamespaceFragment getNamespaceFragment(CppSource src, String ns, Map<String, CppNamespaceFragment> nsMap) {
            CppNamespaceFragment nsf = nsMap.get(ns);
            if (nsf == null) {
                String name;
                Object parent;
                int pos = ns.lastIndexOf("::");
                if (pos > 0) {
                    parent = this.getNamespaceFragment(src, ns.substring(0, pos), nsMap);
                    name = ns.substring(pos + "::".length());
                } else {
                    parent = src;
                    name = ns;
                }
                nsf = new CppNamespaceFragment((IModelServiceProvider)RefreshJob.this.m_softwareSystem, (NamedElement)parent, name);
                parent.addChild((NamedElement)nsf);
                nsMap.put(ns, nsf);
            }
            return nsf;
        }

        private void createElement(Map<String, CppNamespaceFragment> nsMap, CppSource src, CppElement element) {
            String ns = element.getNamespace();
            if (ns != null) {
                CppNamespaceFragment nsf = nsMap.get(ns);
                if (nsf == null) {
                    nsf = this.getNamespaceFragment(src, ns, nsMap);
                }
                element.accept(new ModelFactory((NamedElement)nsf));
            } else {
                element.accept(new ModelFactory((NamedElement)src));
            }
        }

        private void buildModel(CppCompilationUnit model) {
            List<CppElement> children = model.getChildren();
            int i = children.size() - 1;
            while (i >= 0) {
                CppElement file = children.get(i);
                CppSource src = (CppSource)this.m_elementMap.get(file);
                MultipleValueMap elementMap = RefreshJob.this.m_elementMappings.get((Object)src);
                THashMap nsMap = new THashMap();
                assert (src != null) : "Header file cannot be resolved: " + file.getName();
                if (elementMap != null) {
                    this.buildNamespaceMap(src, (Map<String, CppNamespaceFragment>)nsMap);
                    ModelMapper mapper = new ModelMapper((MultipleValueMap<String, ProgrammingElement>)elementMap, (Map<String, CppNamespaceFragment>)nsMap);
                    this.m_currentMap = elementMap;
                    for (CppElement element : file.getChildren()) {
                        element.accept(mapper);
                    }
                } else if (file.hasChildren()) {
                    elementMap = new MultipleValueMap();
                    RefreshJob.this.m_elementMappings.put(src, (MultipleValueMap<String, ProgrammingElement>)elementMap);
                    this.m_currentMap = elementMap;
                    for (CppElement element : file.getChildren()) {
                        this.createElement((Map<String, CppNamespaceFragment>)nsMap, src, element);
                    }
                }
                --i;
            }
            this.m_processors.forEach(p -> p.process());
            this.m_processors.clear();
            for (ProgrammingElement def : this.m_definitions) {
                RefreshJob.this.m_parserContext.addDefinition(def.getName(), def);
            }
            this.m_definitions.clear();
        }

        private void buildNamespaceMap(CppSource src, Map<String, CppNamespaceFragment> nsMap) {
            List nsList = src.getChildrenRecursively(CppNamespaceFragment.class, new Class[]{ProgrammingElement.class});
            nsList.forEach(ns -> {
                CppNamespaceFragment cppNamespaceFragment = nsMap.put(ns.getName(), (CppNamespaceFragment)ns);
            });
        }

        private void processMacroInvocations(CppCompilationUnit model) {
            for (CppElement file : model.getChildren()) {
                CppSource src = (CppSource)this.m_elementMap.get(file);
                MultipleValueMap usageMap = new MultipleValueMap();
                if (src.isExternal() || src.hasChildren(false, new Class[]{CppMacroInvocation.class})) continue;
                for (CppElement.Dependency dep : file.getDependencies()) {
                    ProgrammingElement target;
                    if (dep.getType() != CppDependencyType.MACRO_INVOCATION || (target = (ProgrammingElement)this.m_elementMap.get(dep.getTo())) == null) continue;
                    String name = dep.getTo().getName();
                    int index = usageMap.get((Object)name).size();
                    CppMacroInvocation mi = new CppMacroInvocation((IModelServiceProvider)RefreshJob.this.m_softwareSystem, (NamedElement)src, name + "@" + index, dep.getLineNo());
                    usageMap.put((Object)name, (Object)mi);
                    src.addChild((NamedElement)mi);
                    CppMacroInvocationDependency midep = new CppMacroInvocationDependency(mi, target);
                    mi.addDependency(midep);
                }
            }
        }

        private void processDependencies() {
            for (CppElement element : this.m_elementMap.keySet()) {
                if (!(element instanceof CppProgrammingElement)) continue;
                ProgrammingElement modelElement = (ProgrammingElement)this.m_elementMap.get(element);
                element.accept(new DependencyCreator(modelElement));
            }
        }

        private void addDependency(CppElement.Dependency dep, ProgrammingElement from, ProgrammingElement to) {
            assert (dep != null);
            assert (from != null);
            assert (to != null);
            Object pdep = null;
            switch (dep.getType()) {
                case FIELD_TYPE: {
                    pdep = new CppFieldTypeDependency(from, to);
                    break;
                }
                case VARIABLE_TYPE: {
                    pdep = new CppVariableTypeDependency(from, to);
                    break;
                }
                case PARAMETER_TYPE: {
                    pdep = new CppParameterTypeDependency(from, to, dep.getLineNo());
                    break;
                }
                case LOCAL_VARIABLE_TYPE: {
                    pdep = new CppLocalVariableTypeDependency(from, to, dep.getLineNo());
                    break;
                }
                case TEMPLATE_PARAMETER_TYPE: {
                    pdep = new CppTemplateParameterTypeDependency(from, to, dep.getLineNo());
                    break;
                }
                case THROW_TYPE: {
                    pdep = new CppThrowTypeDependency(from, to);
                    break;
                }
                case RETURN_TYPE: {
                    pdep = new CppReturnTypeDependency(from, to);
                    break;
                }
                case TYPEDEF_TYPE: {
                    pdep = new CppTypedefTypeDependency(from, to);
                    break;
                }
                case SIZEOF: {
                    pdep = new CppSizeofDependency(from, to, dep.getLineNo());
                    break;
                }
                case DYNAMIC_CAST: {
                    pdep = new CppDynamicCastDependency(from, to, dep.getLineNo());
                    break;
                }
                case CAST: {
                    pdep = new CppCastDependency(from, to, dep.getLineNo());
                    break;
                }
                case POINTER_TO_MEMBER_OF: {
                    pdep = new CppPointerToMemberDependency(from, to, dep.getLineNo());
                    break;
                }
                case INHERITS_FROM: {
                    pdep = new CppInheritsFrom(from, to, dep.getLineNo());
                    break;
                }
                case VIRTUALLY_INHERITS_FROM: {
                    pdep = new CppVirtuallyInheritsFrom(from, to, dep.getLineNo());
                    break;
                }
                case USES: {
                    pdep = new CppUsesDependency(from, to, dep.getLineNo());
                    break;
                }
                case CALL: {
                    pdep = new CppCallDependency(from, to, dep.getLineNo());
                    break;
                }
                case VIRTUAL_CALL: {
                    pdep = new CppVirtualCallDependency(from, to, dep.getLineNo());
                    break;
                }
                case READ: {
                    pdep = new CppReadDependency(from, to, dep.getLineNo());
                    break;
                }
                case WRITE: {
                    pdep = new CppWriteDependency(from, to, dep.getLineNo());
                    break;
                }
                case NEW: {
                    pdep = new CppNewDependency(from, to, dep.getLineNo());
                    break;
                }
                case DELETE: {
                    pdep = new CppDeleteDependency(from, to, dep.getLineNo());
                    break;
                }
                case MACRO_INVOCATION: {
                    break;
                }
                case ADDRESS_TAKEN: {
                    pdep = new CppAddressTakenDependency(from, to, dep.getLineNo());
                    break;
                }
                case INITIALIZE: {
                    pdep = new CppInitializeDependency(from, to, dep.getLineNo());
                    break;
                }
                case DECLARES: {
                    if (from instanceof CppVariable) {
                        assert (to instanceof CppVariable) : to.getClass().getName();
                    } else if (from instanceof CppEnumeration) {
                        assert (to instanceof CppEnumeration) : to.getClass().getName();
                    } else assert (from instanceof CppRoutine && to instanceof CppRoutine) : from.getClass().getName() + " -> " + to.getClass().getName();
                    pdep = new CppDeclaresDependency(from, to);
                    break;
                }
                case BY_NAME: {
                    if (!(to instanceof CppClassStructUnionDefinition)) break;
                    pdep = new CppByNameDependency(from, to);
                    break;
                }
            }
            if (pdep != null) {
                from.addDependencyIfNotPresent(pdep);
            }
        }

        public void finish(boolean anySuccess) {
            if (anySuccess) {
                for (CppClassStructUnionDeclaration decl : this.m_structTypeDecls) {
                    if (decl.getDefinition() != null) continue;
                    RefreshJob.this.m_parserContext.addUndefinedClass(decl);
                }
                for (CppVariable var : this.m_undefinedVariables) {
                    if (var.isDefinition() || var.getDefinition() != null) continue;
                    RefreshJob.this.m_parserContext.addUndefinedVariable(var);
                }
                for (CppRoutine rout : this.m_routineDecls) {
                    if (rout.getDefinition() != null) continue;
                    RefreshJob.this.m_parserContext.addUndefinedRoutine(rout);
                }
            }
            this.m_structTypeDecls.clear();
            this.m_undefinedVariables.clear();
            this.m_routineDecls.clear();
        }

        private class ClassNamespaceProcessor
        implements IProcessor {
            private final CppProgrammingElementProxy m_element;
            private final CppClassStructUnionNamespace m_namedElement;

            private ClassNamespaceProcessor(CppProgrammingElementProxy element, CppClassStructUnionNamespace namedElement) {
                this.m_element = element;
                this.m_namedElement = namedElement;
            }

            @Override
            public void process() {
                CppClassStructUnion csu = (CppClassStructUnion)ParsingResultHandler.this.m_elementMap.get(this.m_element.getElement());
                if (csu != null) {
                    this.m_namedElement.setType(csu);
                } else {
                    LOGGER.error("Cannot resolve type " + this.m_element.getFullName() + " (" + this.m_element.getLocation() + ")");
                }
            }
        }

        private class DependencyCreator
        extends CppElement.Visitor
        implements CppProgrammingElement.IVisitor {
            private final ProgrammingElement m_modelElement;

            private DependencyCreator(ProgrammingElement modelElement) {
                assert (modelElement != null) : "Parameter 'modelElement' of method 'DependencyAndSignatureCreator' must not be null";
                this.m_modelElement = modelElement;
            }

            @Override
            public void visitCppProgrammingElement(CppProgrammingElement element) {
                boolean external = element.isExternal();
                if (element.hasDependencies()) {
                    for (CppElement.Dependency dep : element.getDependencies()) {
                        ProgrammingElement target = (ProgrammingElement)ParsingResultHandler.this.m_elementMap.get(dep.getTo());
                        if (target == null) {
                            CppSource src = (CppSource)((Object)this.m_modelElement.getParent(CppSource.class, new Class[0]));
                            int line = this.m_modelElement.getLineNumber();
                            if (dep.getTo() != null) {
                                if (src == null) {
                                    CppSourceFileElement source = element.getParent(CppSourceFileElement.class);
                                    LOGGER.error("Cannot resolve dependency endpoint (model not anchored) '" + dep.getTo().getName() + "' at " + source.getName() + ": " + line);
                                    continue;
                                }
                                LOGGER.error("Cannot resolve dependency endpoint '" + dep.getTo().getName() + "' at " + src.getName() + ": " + line);
                                continue;
                            }
                            LOGGER.error(String.format("Unexpected target of null for dependency of type %s at %s:%d", dep.getType().name(), src.getName(), line));
                            continue;
                        }
                        if (external && dep.getType() != CppDependencyType.DECLARES) continue;
                        ParsingResultHandler.this.addDependency(dep, this.m_modelElement, target);
                    }
                }
            }
        }

        private class KeyCollector
        extends CppElement.Visitor
        implements CppProgrammingElement.IVisitor {
            Set<String> m_keys = new THashSet();

            private KeyCollector() {
            }

            @Override
            public void visitCppProgrammingElement(CppProgrammingElement element) {
                if (element.isRelevantDefinition()) {
                    this.m_keys.add(element.getKey());
                }
            }
        }

        private final class MappingChecker
        extends CppElement.Visitor
        implements CppProgrammingElement.IVisitor,
        CppElementWithSignature.IVisitor,
        CppFunctionSpec.IVisitor,
        CppFunctionWithBody.IVisitor,
        CppStructuredType.IVisitor,
        CppSourceFileElement.IVisitor,
        CppProgrammingElementProxy.IVisitor {
            private NamedElement m_value;

            public MappingChecker(NamedElement m_value) {
                this.m_value = m_value;
            }

            @Override
            public void visitCppSourceFileElement(CppSourceFileElement element) {
                assert (this.m_value instanceof CppSource);
            }

            @Override
            public void visitCppProgrammingElementProxy(CppProgrammingElementProxy element) {
                assert (this.m_value instanceof CppClassStructUnionNamespace);
            }

            @Override
            public void visitCppStructuredType(CppStructuredType element) {
                List elements;
                if (this.m_value instanceof CppTypedef && !element.getName().equals("[anonymous]") && (elements = ParsingResultHandler.this.m_currentMap.get((Object)element.getKey().replace(element.getName(), "[anonymous]"))).size() == 1) {
                    this.m_value = (NamedElement)elements.iterator().next();
                }
                assert (this.m_value instanceof CppClassStructUnion);
            }

            @Override
            public void visitCppFunctionWithBody(CppFunctionWithBody element) {
                if (!(this.m_value instanceof CppRoutineDefinition)) {
                    this.m_value.remove();
                    this.m_value = null;
                }
            }

            @Override
            public void visitCppFunctionSpec(CppFunctionSpec element) {
                boolean isMatching = element.getType() == CppElementType.MEMBER_FUNCTION ? this.m_value instanceof CppMemberFunctionDeclaration : this.m_value instanceof CppFunctionDeclaration;
                if (!isMatching) {
                    this.m_value.remove();
                    this.m_value = null;
                }
            }

            @Override
            public void visitCppElementWithSignature(CppElementWithSignature element) {
                switch (element.getType()) {
                    case VAR: {
                        if (this.m_value instanceof CppVariable) break;
                        this.m_value.remove();
                        this.m_value = null;
                        break;
                    }
                    case FIELD: {
                        if (this.m_value instanceof CppField) break;
                        this.m_value.remove();
                        this.m_value = null;
                        break;
                    }
                    case TYPEDEF: {
                        if (this.m_value instanceof CppTypedef) break;
                        this.m_value.remove();
                        this.m_value = null;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }

            @Override
            public void visitCppProgrammingElement(CppProgrammingElement element) {
                switch (element.getType()) {
                    case ENUM: {
                        assert (this.m_value instanceof CppEnumeration);
                        break;
                    }
                    case CONSTANT: {
                        assert (this.m_value instanceof CppEnumerationConstant);
                        break;
                    }
                    case MACRO: {
                        assert (this.m_value instanceof CppMacro);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
        }

        private class ModelFactory
        extends CppElement.Visitor
        implements CppProgrammingElement.IVisitor,
        CppElementWithSignature.IVisitor,
        CppFunctionSpec.IVisitor,
        CppFunctionWithBody.IVisitor,
        CppStructuredType.IVisitor,
        CppProgrammingElementProxy.IVisitor {
            private final NamedElement m_currentParent;

            private ModelFactory(NamedElement currentParent) {
                assert (currentParent != null) : "Parameter 'currentParent' of method 'ModelFactory' must not be null";
                this.m_currentParent = currentParent;
            }

            @Override
            public void visitCppProgrammingElementProxy(CppProgrammingElementProxy element) {
                CppClassStructUnionNamespace child;
                CppClassStructUnion csu = (CppClassStructUnion)ParsingResultHandler.this.m_elementMap.get(element.getElement());
                if (csu == null) {
                    child = new CppClassStructUnionNamespace((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName());
                    ParsingResultHandler.this.m_processors.add(new ClassNamespaceProcessor(element, child));
                } else {
                    child = new CppClassStructUnionNamespace((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, csu);
                }
                this.m_currentParent.addChild((NamedElement)child);
                ParsingResultHandler.this.mapElement(element, (NamedElement)child);
                ParsingResultHandler.this.m_currentMap.put((Object)element.getFullName(), (Object)child);
                new ModelFactory((NamedElement)child).visitChildrenOf(element);
            }

            @Override
            public void visitCppStructuredType(CppStructuredType element) {
                CppClassStructUnion child = null;
                if (element.hasFlag(CppFlags.DEFINITION)) {
                    switch (element.getType()) {
                        case CLASS: {
                            child = new CppClass((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), (short)element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                            break;
                        }
                        case STRUCT: {
                            child = new CppStruct((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), (short)element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                            break;
                        }
                        case UNION: {
                            child = new CppUnion((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), (short)element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected type " + element.getType().name();
                            break;
                        }
                    }
                    if (!child.isExternal() && !((CppClassStructUnionDefinition)child).isAnonymous()) {
                        ((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_parserContext.addDefinition(child.getName(), (ProgrammingElement)child);
                    }
                } else {
                    switch (element.getType()) {
                        case CLASS: {
                            child = new CppClassDeclaration((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), (short)element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                            break;
                        }
                        case STRUCT: {
                            child = new CppStructDeclaration((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), (short)element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                            break;
                        }
                        case UNION: {
                            child = new CppUnionDeclaration((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), (short)element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected type " + element.getType().name();
                            break;
                        }
                    }
                    if (!child.isExternal()) {
                        ParsingResultHandler.this.m_structTypeDecls.add((CppClassStructUnionDeclaration)child);
                    }
                }
                this.m_currentParent.addChild(child);
                ParsingResultHandler.this.mapElement(element, (NamedElement)child);
                ParsingResultHandler.this.m_currentMap.put((Object)element.getKey(), (Object)child);
                if (element.getName().startsWith("[anonymous]")) {
                    String sourceFileName = element.getParent(CppSourceFileElement.class).getName();
                    ParsingResultHandler.this.m_anonymousStructsOrUnions.put((Object)(sourceFileName + ":" + element.getName()), (Object)child);
                }
                new ModelFactory((NamedElement)child).visitChildrenOf(element);
            }

            @Override
            public void visitCppFunctionWithBody(CppFunctionWithBody element) {
                CppRoutineDefinition child = null;
                if (element.getType() == CppElementType.FUNCTION) {
                    child = new CppFunction((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                } else {
                    child = new CppMemberFunction((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), element.getNumberOfTemplateArguments());
                    this.processMemberFunction(element, (ICppMemberFunction)((Object)child));
                }
                if (!this.m_currentParent.isExternal()) {
                    if (element.getCyclomaticComplexity() > 0) {
                        child.setNumberOfLogicalOperations(element.getNumberOfLogicalOperations());
                        child.setCyclomaticComplexity(element.getCyclomaticComplexity());
                        child.setNumberOfStatements(element.getNumberOfStatements());
                        child.setMaxNesting(element.getMaxNesting());
                        child.setModifiedCyclomaticComplexity(element.getModifiedCyclomaticComplexity());
                    }
                    child.setNumberOfParameters(element.getNumberOfParameters());
                }
                child.setStatic(element.hasFlag(CppFlags.STATIC));
                child.setSignature(element.getSignature());
                this.m_currentParent.addChild((NamedElement)child);
                ParsingResultHandler.this.mapElement(element, (NamedElement)child);
                ParsingResultHandler.this.m_currentMap.put((Object)element.getKey(), (Object)child);
                if (!child.isExternal()) {
                    ParsingResultHandler.this.m_definitions.add((ProgrammingElement)child);
                }
                new ModelFactory((NamedElement)child).visitChildrenOf(element);
            }

            private void processMemberFunction(CppFunctionSpec element, ICppMemberFunction mf) {
                if (element.hasFlag(CppFlags.SPECIAL_MEMBER_FUNCTION)) {
                    mf.setKind(CppMethodType.SPECIAL_MEMBER_FUNCTION);
                } else if (element.hasFlag(CppFlags.CONSTRUCTOR)) {
                    if (element.hasFlag(CppFlags.STATIC)) {
                        mf.setKind(CppMethodType.STATIC_CONSTRUCTOR);
                    } else {
                        mf.setKind(CppMethodType.CONSTRUCTOR);
                    }
                } else if (element.hasFlag(CppFlags.DESTRUCTOR)) {
                    mf.setKind(CppMethodType.DESTRUCTOR);
                } else if (element.hasFlag(CppFlags.STATIC)) {
                    mf.setKind(CppMethodType.STATIC_MEMBER_FUNCTION);
                } else {
                    mf.setKind(CppMethodType.MEMBER_FUNCTION);
                }
                if (element.hasFlag(CppFlags.PUBLIC)) {
                    mf.setAccessSpecifier(CppAccessSpecifier.PUBLIC);
                } else if (element.hasFlag(CppFlags.PROTECTED)) {
                    mf.setAccessSpecifier(CppAccessSpecifier.PROTECTED);
                } else {
                    mf.setAccessSpecifier(CppAccessSpecifier.PRIVATE);
                }
            }

            @Override
            public void visitCppFunctionSpec(CppFunctionSpec element) {
                CppRoutine child = null;
                if (element.getType() == CppElementType.FUNCTION) {
                    child = new CppFunctionDeclaration((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), element.getNumberOfTemplateArguments(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                } else {
                    child = new CppMemberFunctionDeclaration((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), element.getNumberOfTemplateArguments());
                    this.processMemberFunction(element, (ICppMemberFunction)((Object)child));
                }
                child.setNumberOfParameters(element.getNumberOfParameters());
                child.setStatic(element.hasFlag(CppFlags.STATIC));
                child.setInline(element.hasFlag(CppFlags.INLINE));
                child.setSignature(element.getSignature());
                this.m_currentParent.addChild((NamedElement)child);
                ParsingResultHandler.this.mapElement(element, (NamedElement)child);
                ParsingResultHandler.this.m_currentMap.put((Object)element.getKey(), (Object)child);
                if (!child.isExternal()) {
                    ParsingResultHandler.this.m_routineDecls.add(child);
                }
                new ModelFactory((NamedElement)child).visitChildrenOf(element);
            }

            @Override
            public void visitCppElementWithSignature(CppElementWithSignature element) {
                ProgrammingElement child = null;
                if (element.getType() == CppElementType.FIELD) {
                    CppField f;
                    child = f = new CppField((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo());
                    if (element.hasFlag(CppFlags.PUBLIC)) {
                        f.setAccessSpecifier(CppAccessSpecifier.PUBLIC);
                    } else if (element.hasFlag(CppFlags.PROTECTED)) {
                        f.setAccessSpecifier(CppAccessSpecifier.PROTECTED);
                    } else {
                        f.setAccessSpecifier(CppAccessSpecifier.PRIVATE);
                    }
                    f.setSignature(element.getSignature());
                } else if (element.getType() == CppElementType.VAR) {
                    CppVariable var = new CppVariable((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), element.hasFlag(CppFlags.DEFINITION), element.hasFlag(CppFlags.STATIC), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                    child = var;
                    if (element.hasFlag(CppFlags.PUBLIC)) {
                        var.setAccessSpecifier(CppAccessSpecifier.PUBLIC);
                    } else if (element.hasFlag(CppFlags.PROTECTED)) {
                        var.setAccessSpecifier(CppAccessSpecifier.PROTECTED);
                    } else {
                        var.setAccessSpecifier(CppAccessSpecifier.PRIVATE);
                    }
                    var.setSignature(element.getSignature());
                    if (!var.isExternal()) {
                        if (!var.isDefinition()) {
                            ParsingResultHandler.this.m_undefinedVariables.add(var);
                        } else {
                            ParsingResultHandler.this.m_definitions.add(var);
                        }
                    }
                } else if (element.getType() == CppElementType.TYPEDEF) {
                    child = new CppTypedef((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getSignature(), element.getLineNo(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                    RefreshJob.this.addTypedef((CppTypedef)child);
                }
                if (ParsingResultHandler.this.mapElement(element, (NamedElement)child)) {
                    this.m_currentParent.addChild((NamedElement)child);
                    ParsingResultHandler.this.m_currentMap.put((Object)element.getKey(), (Object)child);
                    new ModelFactory((NamedElement)child).visitChildrenOf(element);
                }
            }

            @Override
            public void visitCppProgrammingElement(CppProgrammingElement element) {
                ICppProgrammingElement child = null;
                switch (element.getType()) {
                    case CONSTANT: {
                        child = new CppEnumerationConstant((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo());
                        break;
                    }
                    case ENUM: {
                        child = new CppEnumeration((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo(), element.hasFlag(CppFlags.IN_ANONYMOUS_NAMESPACE));
                        break;
                    }
                    case MACRO: {
                        child = new CppMacro((IModelServiceProvider)((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_softwareSystem, this.m_currentParent, element.getName(), element.getLineNo());
                        break;
                    }
                    default: {
                        assert (false) : "Unexpected type " + element.getType().name();
                        break;
                    }
                }
                this.m_currentParent.addChild(child);
                ParsingResultHandler.this.mapElement(element, (NamedElement)child);
                ParsingResultHandler.this.m_currentMap.put((Object)element.getKey(), (Object)child);
                new ModelFactory((NamedElement)child).visitChildrenOf(element);
            }
        }

        private class ModelMapper
        extends CppElement.Visitor
        implements CppProgrammingElement.IVisitor,
        CppProgrammingElementProxy.IVisitor {
            private final MultipleValueMap<String, ProgrammingElement> m_mapping;
            private final Map<String, CppNamespaceFragment> m_nsMap;

            private ModelMapper(MultipleValueMap<String, ProgrammingElement> mapping, Map<String, CppNamespaceFragment> nsMap) {
                this.m_mapping = mapping;
                this.m_nsMap = nsMap;
            }

            @Override
            public void visitCppProgrammingElementProxy(CppProgrammingElementProxy element) {
                List pes = this.m_mapping.get((Object)element.getKey());
                if (pes.isEmpty() && element.getParent() instanceof CppSourceFileElement) {
                    CppHeader header = (CppHeader)ParsingResultHandler.this.m_elementMap.get(element.getParent());
                    assert (header != null);
                    ParsingResultHandler.this.createElement(this.m_nsMap, header, element);
                    return;
                }
                this.visitChildrenOf(element);
            }

            private String filterTemplateParams(String sig) {
                StringBuilder sb = new StringBuilder(sig.length());
                int ltCount = 0;
                int i = 0;
                while (i < sig.length()) {
                    char c = sig.charAt(i);
                    if (c == '<') {
                        ++ltCount;
                    } else if (c == '>') {
                        --ltCount;
                    } else if (ltCount == 0) {
                        sb.append(c);
                    }
                    ++i;
                }
                return sb.toString();
            }

            private boolean signatureEquals(String sig1, String sig2) {
                int pos1 = sig1.lastIndexOf(41);
                if (pos1 <= 0) {
                    return sig1.equals(sig2);
                }
                int pos2 = sig2.lastIndexOf(41);
                if (pos2 <= 0) {
                    return false;
                }
                sig1 = this.filterTemplateParams(sig1.substring(0, pos1));
                sig2 = this.filterTemplateParams(sig2.substring(0, pos2));
                return sig1.equals(sig2);
            }

            @Override
            public void visitCppProgrammingElement(CppProgrammingElement element) {
                List pes = this.m_mapping.get((Object)element.getKey());
                ProgrammingElement pe = null;
                for (ProgrammingElement p : pes) {
                    if (p instanceof CppTypedef) {
                        if (element.getType() != CppElementType.TYPEDEF) continue;
                        pe = p;
                        break;
                    }
                    if (p instanceof CppField) {
                        if (element.getType() != CppElementType.FIELD) continue;
                        pe = p;
                        break;
                    }
                    if (p instanceof CppVariable) {
                        if (element.getType() != CppElementType.VAR) continue;
                        pe = p;
                        break;
                    }
                    if (element instanceof CppElementWithSignature && p instanceof ICppHasSignature) {
                        CppElementWithSignature ews = (CppElementWithSignature)element;
                        ICppHasSignature pws = (ICppHasSignature)p;
                        if (!this.signatureEquals(pws.getSignature(), ews.getSignature())) continue;
                        pe = p;
                        break;
                    }
                    if (p instanceof CppClassStructUnion) {
                        if (!(element instanceof CppStructuredType)) continue;
                        pe = p;
                        break;
                    }
                    if (p instanceof CppEnumeration) {
                        if (element.getType() != CppElementType.ENUM) continue;
                        pe = p;
                        break;
                    }
                    pe = p;
                    break;
                }
                if (pe == null) {
                    CppElement parent = element.getParent();
                    if (parent instanceof CppSourceFileElement) {
                        CppHeader header = (CppHeader)ParsingResultHandler.this.m_elementMap.get(parent);
                        assert (header != null);
                        ParsingResultHandler.this.createElement(this.m_nsMap, header, element);
                    } else if (parent instanceof CppProgrammingElementProxy) {
                        neParent = (NamedElement)this.m_mapping.getFirstValue((Object)((CppProgrammingElementProxy)parent).getFullName());
                        if (neParent == null) {
                            source = element.getParent(CppSourceFileElement.class);
                            LOGGER.error(String.format("Cannot map nested proxy element '%s' in '%s' ", element.getName(), source.getName()));
                        } else {
                            element.accept(new ModelFactory(neParent));
                        }
                    } else {
                        neParent = ParsingResultHandler.this.m_elementMap.get(element.getParent());
                        if (parent == null) {
                            source = element.getParent(CppSourceFileElement.class);
                            LOGGER.error(String.format("Cannot map nested element '%s' in '%s' ", element.getName(), source.getName()));
                        } else {
                            assert (element.getNamespace() == null);
                            element.accept(new ModelFactory(neParent));
                        }
                    }
                } else if (ParsingResultHandler.this.mapElement(element, (NamedElement)pe) && pe instanceof CppVariable && element.hasFlag(CppFlags.DEFINITION)) {
                    CppVariable var = (CppVariable)pe;
                    if (!var.isDefinition()) {
                        var.markAsDefinition();
                    }
                    ((ParsingResultHandler)ParsingResultHandler.this).RefreshJob.this.m_parserContext.addDefinition(var.getName(), var);
                }
                this.visitChildrenOf(element);
            }
        }
    }

    private final class PrepareModelForReparseVisitor
    extends NamedElementVisitor
    implements CppHeader.IVisitor,
    ProgrammingElement.IVisitor,
    CppVariable.IVisitor,
    CppUnionDeclaration.IVisitor,
    CppClassStructUnionDefinition.IVisitor,
    CppStructDeclaration.IVisitor,
    CppClassDeclaration.IVisitor,
    CppMemberFunctionDeclaration.IVisitor,
    CppFunctionDeclaration.IVisitor,
    CppRoutineDefinition.IVisitor,
    CppClassStructUnionNamespace.IVisitor,
    CppTypedef.IVisitor {
        private MultipleValueMap<String, ProgrammingElement> m_currentMap = null;

        PrepareModelForReparseVisitor() {
        }

        private void cache(ICppProgrammingElement element) {
            if (this.m_currentMap != null) {
                this.m_currentMap.put((Object)element.getKey(), (Object)element.getProgrammingElement());
            }
        }

        @Override
        public void visitCppClassStructUnionNamespace(CppClassStructUnionNamespace element) {
            if (this.m_currentMap != null) {
                this.m_currentMap.put((Object)element.getName(), (Object)element);
            }
            this.visitChildrenOf((NamedElement)element);
        }

        @Override
        public void visitCppTypedef(CppTypedef element) {
            RefreshJob.this.addTypedef(element);
            this.visitProgrammingElement(element);
        }

        public void visitProgrammingElement(ProgrammingElement element) {
            if (element instanceof ICppProgrammingElement) {
                this.cache((ICppProgrammingElement)element);
            }
            this.visitChildrenOf((NamedElement)element);
        }

        @Override
        public void visitCppHeader(CppHeader element) {
            this.m_currentMap = RefreshJob.this.m_elementMappings.get((Object)element);
            assert (this.m_currentMap == null);
            this.m_currentMap = new MultipleValueMap();
            RefreshJob.this.m_elementMappings.put(element, this.m_currentMap);
            this.visitChildrenOf((NamedElement)element);
            this.m_currentMap = null;
        }

        @Override
        public void visitCppVariable(CppVariable v) {
            int defCount = v.clearInvalidDefinitions();
            if (!v.isExternal()) {
                if (v.isDefinition()) {
                    RefreshJob.this.m_parserContext.addDefinition(v.getName(), v);
                } else if (defCount == 0 || !v.isDefinition()) {
                    RefreshJob.this.m_parserContext.addUndefinedVariable(v);
                }
            }
            this.cache(v);
        }

        @Override
        public void visitCppClassStructUnionDefinition(CppClassStructUnionDefinition element) {
            if (!element.isExternal()) {
                RefreshJob.this.m_parserContext.addDefinition(element.getName(), (ProgrammingElement)element);
            }
            this.cache(element);
            this.visitChildrenOf((NamedElement)element);
        }

        private void visitClassStructUnion(CppClassStructUnionDeclaration cls) {
            int defCount = cls.clearInvalidDefinitions();
            if (defCount == 0 && !cls.isExternal()) {
                RefreshJob.this.m_parserContext.addUndefinedClass(cls);
            }
            this.cache(cls);
            this.visitChildrenOf((NamedElement)cls);
        }

        @Override
        public void visitCppUnionDeclaration(CppUnionDeclaration obj) {
            this.visitClassStructUnion(obj);
        }

        @Override
        public void visitCppStructDeclaration(CppStructDeclaration obj) {
            this.visitClassStructUnion(obj);
        }

        @Override
        public void visitCppClassDeclaration(CppClassDeclaration obj) {
            this.visitClassStructUnion(obj);
        }

        private void visitRoutine(CppRoutine routine) {
            int defCount;
            if (!(routine.isPureVirtual() || routine.isDefaulted() || routine.isExternal() || (defCount = routine.clearInvalidDefinitions()) != 0)) {
                RefreshJob.this.m_parserContext.addUndefinedRoutine(routine);
            }
            this.cache(routine);
            this.visitChildrenOf((NamedElement)routine);
        }

        @Override
        public void visitCppMemberFunctionDeclaration(CppMemberFunctionDeclaration obj) {
            this.visitRoutine(obj);
        }

        @Override
        public void visitCppFunctionDeclaration(CppFunctionDeclaration obj) {
            this.visitRoutine(obj);
        }

        @Override
        public void visitCppRoutineDefinition(CppRoutineDefinition element) {
            if (!element.isExternal()) {
                RefreshJob.this.m_parserContext.addDefinition(element.getName(), (ProgrammingElement)element);
            }
            this.cache(element);
            this.visitChildrenOf((NamedElement)element);
        }
    }

    private static class RemoveUnreferencedExternalsVisitor
    extends CppElementVisitor {
        private final Set<ProgrammingElement> m_toBeRemoved = new LinkedHashSet<ProgrammingElement>();
        private final Set<ProgrammingElement> m_survivors = new LinkedHashSet<ProgrammingElement>();
        private final List<CppClassStructUnionNamespace> m_proxies = new ArrayList<CppClassStructUnionNamespace>();
        private final ParserModel m_factsModel;
        private boolean m_inFakeExternal = false;

        RemoveUnreferencedExternalsVisitor(ParserModel factsModel) {
            assert (factsModel != null) : "Parameter 'factsModel' of method 'RemoveUnreferencedExternalsVisitor' must not be null";
            this.m_factsModel = factsModel;
        }

        private ProgrammingElement getRootProgrammingElement(ProgrammingElement element) {
            while (element.getParent() instanceof ProgrammingElement) {
                element = (ProgrammingElement)element.getParent();
            }
            return element;
        }

        private boolean hasNonExternalIncomingDependencies(ProgrammingElement element) {
            Iterator iterator = element.getIncomingDependencyIterator();
            while (iterator.hasNext()) {
                ParserDependency dep = (ParserDependency)iterator.next();
                if (!dep.getFrom().isValid()) {
                    ProgrammingElement invalid = dep.getFrom();
                    LOGGER.error("Found invalid element in RemoveUnreferencedExternalsVisitor: " + invalid.getClass().getName() + ": " + invalid.getShortName());
                    iterator.remove();
                    continue;
                }
                if (dep.getFrom().isExternal()) continue;
                return true;
            }
            return false;
        }

        private void handleProgrammingElements(NamedElement parent) {
            List roots = parent.getChildren(ProgrammingElement.class);
            for (ProgrammingElement root : roots) {
                assert (!this.m_survivors.contains(root));
                boolean isUsed = false;
                if (!this.m_inFakeExternal && !this.hasNonExternalIncomingDependencies(root)) {
                    List children = root.getChildrenRecursively(ProgrammingElement.class, new Class[0]);
                    for (ProgrammingElement child : children) {
                        if (!this.hasNonExternalIncomingDependencies(child)) continue;
                        isUsed = true;
                        break;
                    }
                    for (NamedElementProxy proxy : root.getChildrenRecursively(NamedElementProxy.class, new Class[0])) {
                        if (!this.hasNonExternalIncomingDependencies((ProgrammingElement)proxy.getElement())) continue;
                        isUsed = true;
                        break;
                    }
                } else {
                    isUsed = true;
                }
                if (!isUsed) {
                    this.m_toBeRemoved.add(root);
                    continue;
                }
                this.m_survivors.add(root);
            }
        }

        private void handleNamespaceFragments(NamedElement parent) {
            assert (parent != null) : "Parameter 'parent' of method 'handleNamespaceFragments' must not be null";
            for (Object namespaceFragment : parent.getChildren(NamespaceFragment.class)) {
                namespaceFragment.accept((NamedElement.INamedElementVisitor)this);
            }
            for (Object namespaceFragment : parent.getChildren(CppClassStructUnionNamespace.class)) {
                ((CppClassStructUnionNamespace)namespaceFragment).accept(this);
            }
        }

        @Override
        public void visitCppNamespaceFragment(CppNamespaceFragment obj) {
            this.handleProgrammingElements((NamedElement)obj);
            this.handleNamespaceFragments((NamedElement)obj);
        }

        @Override
        public void visitCppClassStructUnionNamespace(CppClassStructUnionNamespace obj) {
            this.m_proxies.add(obj);
            for (CppClassStructUnionNamespace namespaceFragment : obj.getChildren(CppClassStructUnionNamespace.class)) {
                namespaceFragment.accept(this);
            }
        }

        @Override
        public void visitCppExternalHeaderFile(CppExternalHeaderFile obj) {
            this.handleProgrammingElements((NamedElement)obj);
            this.handleNamespaceFragments((NamedElement)obj);
        }

        @Override
        public void visitCppHeaderFile(CppHeaderFile obj) {
        }

        @Override
        public void visitCppSourceFile(CppSourceFile obj) {
        }

        @Override
        public void visitCppIncludeDirectory(CppIncludeDirectory obj) {
            this.m_inFakeExternal = !obj.isSystemInclude();
            this.visitChildrenOf((NamedElement)obj);
            this.m_inFakeExternal = false;
        }

        public void visitWorkspace(Workspace workspace) {
            this.visitChildrenOf((NamedElement)workspace);
            ArrayList<ProgrammingElement> newSurvivors = new ArrayList<ProgrammingElement>();
            newSurvivors.addAll(this.m_survivors);
            while (true) {
                ProgrammingElement survivor2;
                if (!newSurvivors.isEmpty()) {
                    ArrayList<ProgrammingElement> addedSurvivors = new ArrayList<ProgrammingElement>();
                    for (ProgrammingElement survivor2 : newSurvivors) {
                        NamedElement parent = survivor2.getParent();
                        assert (!(parent instanceof ProgrammingElement)) : String.format("Parent: %s *(%s: %d), element %s", parent.getName(), ((SourceFile)parent.getParent(SourceFile.class, new Class[0])).getName(), ((ProgrammingElement)parent).getLineNumber(), survivor2.getName());
                        for (ParserDependency dep : survivor2.getOutgoingDependenciesRecursively()) {
                            ProgrammingElement targetRoot = this.getRootProgrammingElement(dep.getTo());
                            if (!this.m_toBeRemoved.contains(targetRoot)) continue;
                            boolean success = this.m_toBeRemoved.remove(targetRoot);
                            assert (success);
                            addedSurvivors.add(targetRoot);
                        }
                    }
                    newSurvivors = addedSurvivors;
                    continue;
                }
                survivor2 = this.m_proxies.iterator();
                while (survivor2.hasNext()) {
                    CppClassStructUnionNamespace proxy = survivor2.next();
                    ProgrammingElement root = this.getRootProgrammingElement((ProgrammingElement)proxy);
                    CppClassStructUnion type = proxy.getReferencedType();
                    ProgrammingElement refRoot = this.getRootProgrammingElement((ProgrammingElement)type);
                    if (this.m_toBeRemoved.contains(root) && !this.m_toBeRemoved.contains(refRoot)) {
                        this.m_toBeRemoved.remove(root);
                        newSurvivors.add(root);
                    } else if (this.m_toBeRemoved.contains(refRoot) && !this.m_toBeRemoved.contains(root)) {
                        this.m_toBeRemoved.remove(refRoot);
                        newSurvivors.add(refRoot);
                    }
                    assert (type.isValid() || this.m_toBeRemoved.contains(root));
                }
                if (newSurvivors.isEmpty()) break;
            }
            for (ProgrammingElement doomed : this.m_toBeRemoved) {
                doomed.remove();
            }
            External external = (External)workspace.getUniqueChild(CPlusPlusExternal.class);
            for (CppExternalHeaderFile header : external.getChildrenRecursively(CppExternalHeaderFile.class, new Class[]{ProgrammingElement.class})) {
                if (!header.isValid() || !header.getChildren().isEmpty()) continue;
                boolean delete = true;
                if (this.m_factsModel.getElementIssues((ElementWithIssues)header).size() > 0) continue;
                for (CppHeader included : header.getIncludedHeaders()) {
                    if (included.getChildren().isEmpty()) continue;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                header.discardChildren();
                header.remove();
            }
        }
    }

    private static class RemoveUnreferencedHeaderVisitor
    extends CppElementVisitor {
        private final List<CppHeader> m_headersToRemove = new ArrayList<CppHeader>();
        private boolean m_headerRemoved;

        RemoveUnreferencedHeaderVisitor() {
        }

        boolean headersWereRemoved() {
            return this.m_headerRemoved;
        }

        @Override
        public void visitCppHeaderFile(CppHeaderFile obj) {
        }

        @Override
        public void visitCppSourceFile(CppSourceFile obj) {
        }

        @Override
        public void visitCppExternalHeaderFile(CppExternalHeaderFile obj) {
            if (obj.getFragments().size() == 0) {
                this.m_headersToRemove.add(obj);
                this.m_headerRemoved = true;
            }
        }

        @Override
        public void visitCPlusPlusExternal(CPlusPlusExternal obj) {
            this.visitChildrenOf((NamedElement)obj);
            for (CppHeader header : this.m_headersToRemove) {
                header.remove();
            }
        }

        public void visitWorkspace(Workspace obj) {
            this.m_headerRemoved = false;
            this.visitChildrenOf((NamedElement)obj);
            if (this.m_headerRemoved) {
                this.m_headersToRemove.clear();
            }
        }
    }
}

