/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.RootDirectoryPathValidator;
import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusVisualStudioExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusVsProjectImportSourceDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectFileDelta;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusVsProjectFileBasedModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusVsProjectFileBasedModuleDeltaDetector
extends CPlusPlusDeltaDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusVsProjectFileBasedModuleDeltaDetector.class);

    public CPlusPlusVsProjectFileBasedModuleDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, boolean firstModificationOnly) {
        super(workerContext, languageProvider, filter, module, new ArrayList<String>(), firstModificationOnly);
    }

    @Override
    protected void scanDirectories(OperationResult result) {
        RootDirectoryPath toBeRemovedRoot;
        assert (result != null) : "Parameter 'result' of method 'scanDirectories' must not be null";
        CPlusPlusVisualStudioExtension extension = (CPlusPlusVisualStudioExtension)((SoftwareSystem)this.m_module.getParent(SoftwareSystem.class, new Class[0])).getExtension(CPlusPlusVisualStudioExtension.class);
        OperationResultWithOutcome<VisualStudioProjectFileDelta> projectFileResult = extension.synchronize((CPlusPlusVsProjectFileBasedModule)this.m_module);
        result.addMessagesFrom(projectFileResult);
        LOGGER.debug("Synchronization done");
        if (projectFileResult.isFailure()) {
            LOGGER.error("Failed to analyze Visual Project file for module '" + this.m_module.getName() + "'");
            return;
        }
        VisualStudioProjectFileDelta vsProjectFileDelta = (VisualStudioProjectFileDelta)projectFileResult.getOutcome();
        if (vsProjectFileDelta.getRootDirectoryToRemove() != null) {
            for (TFile removedFile : vsProjectFileDelta.getRemovedFiles()) {
                toRemove = (FilePath)this.m_existingFiles.get(removedFile);
                if (toRemove == null || this.m_delta.isDeleted(toRemove)) continue;
                this.m_delta.deleted(toRemove);
            }
            this.m_existingFiles.clear();
        } else {
            for (TFile removedFile : vsProjectFileDelta.getRemovedFiles()) {
                toRemove = (FilePath)this.m_existingFiles.get(removedFile);
                if (toRemove == null || this.m_delta.isDeleted(toRemove)) continue;
                this.m_delta.deleted(toRemove);
                if (this.m_firstModificationOnly) break;
            }
            for (TFile fileWithModifiedOptions : vsProjectFileDelta.getFilesWithModifiedOptions()) {
                FilePath modified = (FilePath)this.m_existingFiles.get(fileWithModifiedOptions);
                if (modified == null || this.m_delta.isModified(modified)) continue;
                this.m_delta.modified(modified);
                if (this.m_firstModificationOnly) break;
            }
        }
        LOGGER.debug("Before consume all files...");
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)((ModuleSettings)this.m_module.getUniqueExistingChild(ModuleSettings.class)).getUniqueExistingChild(VisualStudioProjectFile.class));
        ArrayList<CPlusPlusVsProjectImportSourceDirectoryPath> roots = new ArrayList<CPlusPlusVsProjectImportSourceDirectoryPath>();
        for (CPlusPlusVsProjectImportSourceDirectoryPath rootDirectory : this.m_module.getChildren(CPlusPlusVsProjectImportSourceDirectoryPath.class)) {
            if (rootDirectory == vsProjectFileDelta.getRootDirectoryToRemove()) {
                RootDirectoryPathValidator.removeIssues((RootDirectoryPath)rootDirectory);
                continue;
            }
            if (RootDirectoryPathValidator.validate((RootDirectoryPath)rootDirectory)) {
                roots.add(rootDirectory);
                continue;
            }
            LOGGER.warn("Root directory is not a directory or does not exist: {}", (Object)rootDirectory);
        }
        this.m_workerContext.beginBlockOfWork(roots.size());
        assert (roots.size() == 1) : "We expect only a single source root directory for Visual Studio project file base C++ module";
        this.m_currentRootDirectory = (RootDirectoryPath)roots.get(0);
        String rootPath = this.m_currentRootDirectory.getFile().getAbsolutePath();
        this.m_workerContext.working("Processing " + rootPath, true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing " + rootPath);
        }
        for (TFile sourceFile : projectFile.getSourceFiles()) {
            if (this.m_workerContext.hasBeenCanceled()) {
                this.m_delta = null;
                break;
            }
            if (CPlusPlusFileType.C_SOURCE.getDefaultExtension().equals(FileUtility.getExtension((TFile)sourceFile))) {
                this.consume(this.m_currentRootDirectory.getFile(), sourceFile, CPlusPlusFileType.C_SOURCE);
            } else {
                this.consume(this.m_currentRootDirectory.getFile(), sourceFile, CPlusPlusFileType.CPP_SOURCE);
            }
            if (this.scanningIsDone()) break;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("All files retrieved from Visual Studio " + rootPath);
        }
        if (this.m_delta != null) {
            this.m_workerContext.workItemCompleted();
            this.setCurrentModule((CPlusPlusModule)this.m_module);
            this.visitModifications();
            this.setCurrentModule(null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Modifications have been visited " + rootPath);
        }
        if ((toBeRemovedRoot = vsProjectFileDelta.getRootDirectoryToRemove()) != null) {
            toBeRemovedRoot.remove();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("scanDirectories finished " + rootPath);
        }
    }
}

