/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.MSBuildException;
import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IWorkspaceExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemMessageCause;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectReferenceInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettingsSignatureWithTimestamp;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.ModuleImportMessageCause;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusMSBuildExecutor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.ModuleCompilerOptionsValidator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.VisualStudioInstallationsExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.VisualStudioProjectFileValidator;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.VisualStudioProjectImporter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.settings.ICPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusVisualStudioExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.ActiveDefinitionVSMismatch;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusVsProjectImportSourceDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CompilationUnitFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsImportModuleDto;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsProjectImportDto;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileSettingsSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectFileDelta;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectReference;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.CPlusPlusMsBuildIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.VisualProjectFileNotFound;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.VisualStudioProjectFileProcessingIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModuleType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusVsProjectFileBasedModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.VsProjectFileBasedModuleDelta;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CPlusPlusVisualStudioExtension
extends Extension
implements ICPlusPlusVisualStudioExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusVisualStudioExtension.class);
    private static final String SEPARATOR = "; ";
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;

    public CPlusPlusVisualStudioExtension(SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'CPlusPlusVisualStudioExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'CPlusPlusVisualStudioExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
    }

    public static ModuleSettingsSignatureWithTimestamp createSignatureElement(CPlusPlusVsProjectFileBasedModule module) {
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)moduleSettings.getUniqueChild(VisualStudioProjectFile.class));
        StringBuilder signatureString = new StringBuilder(projectFile.getName());
        signatureString.append(SEPARATOR).append(projectFile.getConfiguration().toString());
        signatureString.append(SEPARATOR);
        String plainSignatureString = signatureString.toString();
        ModuleSettingsSignatureWithTimestamp signature = new ModuleSettingsSignatureWithTimestamp((NamedElement)moduleSettings, HashSupport.SHA.getHexString(plainSignatureString), plainSignatureString);
        signature.setTimestamp(projectFile.getFile().lastModified());
        return signature;
    }

    public static void finishModuleCreation(Installation installation, SoftwareSystem system, CPlusPlusVsProjectFileBasedModule module) {
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)moduleSettings.getUniqueChild(VisualStudioProjectFile.class));
        TFile file = projectFile.getFile();
        VisualStudioProjectImporter importer = new VisualStudioProjectImporter(file, projectFile.getSolutionDir());
        OperationResultWithOutcome<CPlusPlusVsProjectImportDto> result = importer.process();
        if (result.isFailure()) {
            moduleSettings.addIssue((Issue)new VisualStudioProjectFileProcessingIssue((NamedElement)moduleSettings, String.format("Failed to process file '%s'", file.getAbsolutePath())));
            return;
        }
        CPlusPlusVsProjectImportDto importDto = (CPlusPlusVsProjectImportDto)result.getOutcome();
        SolutionFileInfo.ConfigurationAndPlatform configuration = projectFile.getConfiguration();
        if (configuration != null && !importDto.getConfigurations().containsKey(configuration)) {
            moduleSettings.addIssue((Issue)new VisualStudioProjectFileProcessingIssue((NamedElement)moduleSettings, String.format("Specified configuration '%s' not found in project file '%s'", configuration.toString(), file.getAbsolutePath())));
            return;
        }
        projectFile.setHeaderFiles(importDto.getHeaderFiles());
        CPlusPlusVisualStudioExtension.initModuleSettings(installation, system, importDto, configuration, module, projectFile.getSolutionDir(), projectFile.getFilePathWithEnvVars());
    }

    private OperationResultWithOutcome<CPlusPlusVsProjectFileBasedModule> internCreateVisualStudioProjectFileBasedModule(CPlusPlusVsProjectImportDto importDto, String description, SolutionFileInfo.ConfigurationAndPlatform configuration, TFile solutionDir, EnumSet<Modification> modifications, String projectPathWithEnvVars) {
        assert (importDto != null) : "Parameter 'importDto' of method 'createVisualStudioProjectFileBasedModule' must not be null";
        assert (description != null) : "Parameter 'description' of method 'internCreateVisualStudioProjectFileBasedModule' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'createVisualStudioProjectFileBasedModule' must not be null";
        assert (modifications != null) : "Parameter 'modifications' of method 'internCreateVisualStudioProjectFileBasedModule' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create C++ module based on Visual Studio project file");
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        ValidationResult resultNameValidation = workspaceExtension.getModuleNameValidator().isValid(null, importDto.getProjectName());
        if (resultNameValidation.isFailure()) {
            result.addError((OperationResult.IMessageCause)SoftwareSystemMessageCause.FAILED_TO_CREATE_MODULE, StringUtility.concat((Collection)resultNameValidation.getErrors(), (String)SEPARATOR), new Object[0]);
            return result;
        }
        Module module = workspaceExtension.createModule((Module.IModuleType)CPlusPlusModuleType.VISUAL_STUDIO_PROJECT_FILE_IMPORT, importDto.getProjectName(), description, modifications);
        assert (module instanceof CPlusPlusVsProjectFileBasedModule) : "Unexpected class: " + module.getClass().getName();
        CPlusPlusVsProjectFileBasedModule projectModule = (CPlusPlusVsProjectFileBasedModule)module;
        module = null;
        result.setOutcome((Object)projectModule);
        CPlusPlusVisualStudioExtension.initModuleSettings(((ISoftwareSystemProvider)this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation(), this.m_softwareSystem, importDto, configuration, projectModule, solutionDir, projectPathWithEnvVars);
        return result;
    }

    private static void initModuleSettings(Installation installation, SoftwareSystem system, CPlusPlusVsProjectImportDto importDto, SolutionFileInfo.ConfigurationAndPlatform configuration, CPlusPlusVsProjectFileBasedModule projectModule, TFile solutionDir, String filePathWithEnvVars) {
        ModuleSettings moduleSettings = (ModuleSettings)projectModule.getUniqueChild(ModuleSettings.class);
        VisualStudioProjectFile visualStudioProjectFile = (VisualStudioProjectFile)((Object)moduleSettings.getUniqueChild(VisualStudioProjectFile.class));
        if (visualStudioProjectFile != null) {
            visualStudioProjectFile.remove();
        }
        visualStudioProjectFile = new VisualStudioProjectFile((NamedElement)moduleSettings, importDto.getProjectFile());
        moduleSettings.addChild((NamedElement)visualStudioProjectFile);
        TFile projectDirectory = importDto.getProjectFile().getParentFile();
        moduleSettings.addChild((NamedElement)new BasePathForIncludes((NamedElement)moduleSettings, projectDirectory));
        if (filePathWithEnvVars != null) {
            visualStudioProjectFile.setFilePathWithEnvVars(filePathWithEnvVars);
        }
        visualStudioProjectFile.setConfiguration(configuration);
        visualStudioProjectFile.setProjectGuid(importDto.getProjectGuid());
        visualStudioProjectFile.setProjectName(importDto.getProjectName());
        visualStudioProjectFile.setSolutionDir(solutionDir);
        visualStudioProjectFile.setHeaderFiles(importDto.getHeaderFiles());
        for (VisualStudioProjectReference reference : importDto.getProjectReferences()) {
            visualStudioProjectFile.addProjectReference(reference);
        }
        projectModule.addChild((NamedElement)new CPlusPlusVsProjectImportSourceDirectoryPath((IModelServiceProvider)system, (NamedElement)projectModule, projectDirectory));
        VisualStudioModuleCompilerOptions compilerOptions = null;
        InstCompilerDefinition activeDefinition = CPlusPlusVisualStudioExtension.getActiveCompilerDefinition(installation);
        if (activeDefinition != null) {
            String activeCompilerDefinition = activeDefinition.getName();
            compilerOptions = new VisualStudioModuleCompilerOptions((NamedElement)moduleSettings, activeCompilerDefinition);
        } else {
            compilerOptions = new VisualStudioModuleCompilerOptions((NamedElement)moduleSettings, "Default module compiler options");
        }
        moduleSettings.addChild((NamedElement)compilerOptions);
        CppSourceFileExtensions cppSourceFileExtensions = new CppSourceFileExtensions((NamedElement)moduleSettings, visualStudioProjectFile.getCppSourceFileExtensions());
        moduleSettings.addChild((NamedElement)cppSourceFileExtensions);
        moduleSettings.addChild((NamedElement)new CSourceFileExtensions((NamedElement)moduleSettings));
        moduleSettings.addChild((NamedElement)new SourceFileSettings((NamedElement)moduleSettings));
        ModuleSettingsSignatureWithTimestamp signatureElement = CPlusPlusVisualStudioExtension.createSignatureElement(projectModule);
        signatureElement.setTimestamp(-1L);
        moduleSettings.addChild((NamedElement)signatureElement);
    }

    private void refreshVisualStudioBasedModuleDependencies(CPlusPlusVsProjectFileBasedModule module, boolean setNeedsSave) {
        List currentDependencies;
        boolean changed;
        ArrayList<WorkspaceDependency> previousDependencies = new ArrayList<WorkspaceDependency>(module.getOutgoingWorkspaceDependencies());
        ((WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class)).clearOutgoingWorkspaceDependencies((IWorkspaceDependencyElement)module);
        ModuleSettings settings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        ICPlusPlusWorkspaceExtension workspaceExtension = (ICPlusPlusWorkspaceExtension)this.m_softwareSystem.getExtension(ICPlusPlusWorkspaceExtension.class);
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)settings.getUniqueChild(VisualStudioProjectFile.class));
        block0: for (VisualStudioProjectReference nextReference : projectFile.getProjectReferences()) {
            for (CPlusPlusVsProjectFileBasedModule nextModule : ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusVsProjectFileBasedModule.class)) {
                VisualStudioProjectFile nextProjectFile;
                if (nextModule == module || !FileUtility.areEqual((TFile)(nextProjectFile = (VisualStudioProjectFile)((Object)((ModuleSettings)nextModule.getUniqueChild(ModuleSettings.class)).getUniqueChild(VisualStudioProjectFile.class))).getFile(), (TFile)nextReference.getProjectFile()) && !nextProjectFile.getProjectGuid().equals(nextReference.getProjectKey())) continue;
                WorkspaceDependency dependency = workspaceExtension.createWorkspaceDependency(module, nextModule, CPlusPlusWorkspaceDependency.DependencyType.VISUAL_STUDIO_PROJECT_DEPENDENCY);
                module.addOutgoingWorkspaceDependency(dependency);
                continue block0;
            }
        }
        if (setNeedsSave && !this.m_softwareSystem.needsSave() && (changed = this.checkForChangedDependencies(previousDependencies, currentDependencies = module.getOutgoingWorkspaceDependencies()))) {
            this.m_softwareSystem.setNeedsSave(true);
        }
    }

    private static InstCompilerDefinition getActiveCompilerDefinition(Installation installation) {
        ICPlusPlusInstallationExtension instSettingsProvider = (ICPlusPlusInstallationExtension)installation.getExtension(ICPlusPlusInstallationExtension.class);
        InstCompilerDefinition activeCompilerDefinition = instSettingsProvider.getActiveCompilerDefinition();
        return activeCompilerDefinition;
    }

    private InstCompilerDefinition getActiveCompilerDefinition() {
        return CPlusPlusVisualStudioExtension.getActiveCompilerDefinition(((ISoftwareSystemProvider)this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation());
    }

    @Override
    public OperationResultWithOutcome<CPlusPlusVsProjectFileBasedModule> createVisualStudioProjectFileBasedModule(IWorkerContext workerContext, CPlusPlusVsProjectImportDto importDto, String description, SolutionFileInfo.ConfigurationAndPlatform configuration) {
        ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).cancelSaveSnapshot();
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        OperationResultWithOutcome<CPlusPlusVsProjectFileBasedModule> result = this.internCreateVisualStudioProjectFileBasedModule(importDto, description, configuration, null, modifications, null);
        for (CPlusPlusVsProjectFileBasedModule nextModule : ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusVsProjectFileBasedModule.class)) {
            this.refreshVisualStudioBasedModuleDependencies(nextModule, false);
        }
        ((WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class)).refreshWorkspaceDependencies(modifications);
        this.m_softwareSystem.setNeedsSave(true);
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
        ((ISnapshotController)this.m_softwareSystem.getExtension(ISnapshotController.class)).saveSnapshot();
        ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).runAutomatedAnalyzers(workerContext);
        return result;
    }

    @Override
    public OperationResult editVsProjectFileBasedModule(IWorkerContext workerContext, VsProjectFileBasedModuleDelta moduleDelta) {
        assert (moduleDelta != null) : "Parameter 'moduleDelta' of method 'editVsProjectFileBasedModule' must not be null";
        OperationResult result = new OperationResult("Edit Visual Studio Project File-based Module");
        if (!moduleDelta.getModuleName().equals(moduleDelta.getModule().getName()) || !moduleDelta.getDescription().equals(moduleDelta.getModule().getDescription())) {
            IWorkspaceExtension extension = (IWorkspaceExtension)this.m_softwareSystem.getExtension(IWorkspaceExtension.class);
            extension.editModule((IWorkerContext)DefaultWorkerContext.INSTANCE, (Module)moduleDelta.getModule(), moduleDelta.getModuleName(), moduleDelta.getDescription());
        }
        if (moduleDelta.getConfiguration().equals((Object)moduleDelta.getOriginalConfiguration())) {
            return result;
        }
        if (moduleDelta.getImportDto() == null) {
            IPathValidator validator = this.createVisualStudioProjectFileValidator(moduleDelta);
            validator.isValid(null, moduleDelta.getProjectFile());
        }
        ModuleSettings moduleSettings = (ModuleSettings)moduleDelta.getModule().getUniqueChild(ModuleSettings.class);
        SolutionFileInfo.ConfigurationAndPlatform configuration = moduleDelta.getConfiguration();
        assert (configuration != null) : "configuration must not be null!";
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)moduleSettings.getUniqueChild(VisualStudioProjectFile.class));
        ModuleSettingsSignatureWithTimestamp signature = (ModuleSettingsSignatureWithTimestamp)moduleSettings.getUniqueChild(ModuleSettingsSignatureWithTimestamp.class);
        if (projectFile.getFile().lastModified() == signature.getTimestamp() && configuration.equals((Object)moduleDelta.getOriginalConfiguration())) {
            LOGGER.debug("Visual Studio project file '" + projectFile.getName() + "' and configuration have not been modified");
            return result;
        }
        CPlusPlusVsProjectImportDto.ProjectConfiguration projectConfiguration = moduleDelta.getImportDto().getConfigurations().get(configuration);
        assert (projectConfiguration != null) : "Specified configuration must exist";
        projectFile.setConfiguration(configuration);
        this.m_softwareSystem.setNeedsSave(true);
        WorkspaceExtension.setNeedsReparse((SoftwareSystem)this.m_softwareSystem, (OperationResult)result);
        signature.setTimestamp(-1L);
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, EnumSet.of(Modification.WORKSPACE_SETUP_MODIFIED), result);
        return result;
    }

    @Override
    public IPathValidator createVisualStudioProjectFileValidator(VsProjectFileBasedModuleDelta moduleDelta) {
        return new VisualStudioProjectFileValidator(moduleDelta);
    }

    @Override
    public OperationResult createModulesFromSolutionFileImport(IWorkerContext workerContext, SolutionFileInfo solutionFileInfo, List<IVisualStudioProjectReferenceInfo> referencesToImport, String configurationName, String platformName, ICPlusPlusVisualStudioExtension.ModuleImportMode importMode) {
        assert (solutionFileInfo != null) : "Parameter 'solutionFileInfo' of method 'createModulesFromSolutionFileImport' must not be null";
        assert (referencesToImport != null && !referencesToImport.isEmpty()) : "Parameter 'referencesToImport' of method 'createModulesFromSolutionFileImport' must not be empty";
        assert (configurationName != null && configurationName.length() > 0) : "Parameter 'configurationName' of method 'createModulesFromSolutionFileImport' must not be empty";
        OperationResult result = new OperationResult(importMode.equals((Object)ICPlusPlusVisualStudioExtension.ModuleImportMode.SYSTEM_CREATION) ? "Create system from Visual Studio Solution file" : "Import modules from Visual Studio Solution file");
        EnumSet<Modification> modifications = EnumSet.noneOf(Modification.class);
        for (IVisualStudioProjectReferenceInfo reference : referencesToImport) {
            TFile solutionDir;
            VisualStudioProjectImporter importer;
            OperationResultWithOutcome<CPlusPlusVsProjectImportDto> importResult;
            if (workerContext.hasBeenCanceled()) break;
            workerContext.working("Importing module '" + reference.getName() + "'", true);
            TFile projectFile = reference.getFile();
            if (FileUtility.isRelativePath((String)projectFile.getPath())) {
                projectFile = new TFile((File)this.m_softwareSystem.getDirectoryFile(), projectFile.getPath()).getNormalizedAbsoluteFile();
            }
            if ((importResult = (importer = new VisualStudioProjectImporter(projectFile, solutionDir = solutionFileInfo.getFile().getParentFile())).process()).isFailure()) {
                result.addMessagesFrom(importResult);
                continue;
            }
            SolutionFileInfo.ConfigurationAndPlatform configurationForProject = solutionFileInfo.getConfigurationForProject(reference.getProjectKey(), new SolutionFileInfo.ConfigurationAndPlatform(configurationName, platformName));
            if (configurationForProject == null) {
                LOGGER.warn("Configuration|Platform not mapped in solution file {}: {}|{}", new Object[]{solutionFileInfo.getFile().getAbsolutePath(), configurationName, platformName});
                configurationForProject = new SolutionFileInfo.ConfigurationAndPlatform(configurationName, platformName);
            }
            OperationResultWithOutcome<CPlusPlusVsProjectFileBasedModule> createModuleResult = this.internCreateVisualStudioProjectFileBasedModule((CPlusPlusVsProjectImportDto)importResult.getOutcome(), "", configurationForProject, solutionDir, modifications, reference.getProjectFilePathWithEscapedEnvVars());
            result.addMessagesFrom(createModuleResult);
        }
        workerContext.working("Refreshing module dependencies...", true);
        for (CPlusPlusVsProjectFileBasedModule nextModule : ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusVsProjectFileBasedModule.class)) {
            this.refreshVisualStudioBasedModuleDependencies(nextModule, false);
        }
        ((WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class)).refreshWorkspaceDependencies(modifications);
        if (importMode.equals((Object)ICPlusPlusVisualStudioExtension.ModuleImportMode.SYSTEM_CREATION)) {
            workerContext.working("Saving system", true);
            result.addMessagesFrom(((ISoftwareSystemController)this.m_softwareSystem.getExtension(ISoftwareSystemController.class)).saveSoftwareSystem());
        } else if (importMode.equals((Object)ICPlusPlusVisualStudioExtension.ModuleImportMode.MODULE_ADDITION)) {
            this.m_softwareSystem.setNeedsSave(true);
        } else assert (false) : "Unexpected module import mode";
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, modifications, result);
        return result;
    }

    public Collection<Module> validateModulesConfiguration(PrepareRefreshResult result) {
        InstCompilerDefinition activeCompilerDefinition;
        assert (result != null) : "Parameter 'result' of method 'validateModulesConfiguration' must not be null";
        ArrayList<CPlusPlusVsProjectFileBasedModule> modulesWithIssues = new ArrayList<CPlusPlusVsProjectFileBasedModule>();
        List modules = ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusVsProjectFileBasedModule.class);
        for (CPlusPlusVsProjectFileBasedModule module : modules) {
            ModuleSettings settings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
            VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)settings.getUniqueChild(VisualStudioProjectFile.class));
            if (!projectFile.getFile().exists()) {
                result.addAboutToBeDeleted((Element)module);
                continue;
            }
            this.internValidateVisualStudioProjectBasedModule(module);
            this.refreshVisualStudioBasedModuleDependencies(module, true);
            if (((ModuleSettings)module.getUniqueChild(ModuleSettings.class)).getIssues().size() <= 0) continue;
            modulesWithIssues.add(module);
        }
        CPlusPlusSystemSettings systemSettings = (CPlusPlusSystemSettings)((Object)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusSystemSettings.class));
        systemSettings.removeIssues(new IIssueId[]{CPlusPlusIssueId.VISUAL_STUDIO_MODULE_COMPILER_DEFINITION_MISMATCH});
        if (((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(CPlusPlusVsProjectFileBasedModule.class).size() > 0 && (activeCompilerDefinition = this.getActiveCompilerDefinition()) != null) {
            Map<String, String> fixedProperties = activeCompilerDefinition.getFixedConfigProperties();
            TFile vsCompilerDir = null;
            String arch = null;
            if (fixedProperties != null) {
                String path = fixedProperties.get("instDir");
                if (path != null) {
                    vsCompilerDir = new TFile(path);
                }
                arch = fixedProperties.get("arch");
            }
            if (arch == null || vsCompilerDir == null || !vsCompilerDir.isDirectory() || !vsCompilerDir.exists()) {
                LOGGER.warn("Compiler definition for processing VS based projects contains invalid properties arch=" + arch + ", instDir=" + (vsCompilerDir != null ? vsCompilerDir.getNormalizedAbsolutePath() : "null"));
                systemSettings.addIssue((Issue)new ActiveDefinitionVSMismatch((NamedElement)systemSettings, "Active compiler definition '" + activeCompilerDefinition.getName() + "' cannot be used to parse modules based on Visual Studio project files."));
            }
        }
        return Collections.unmodifiableList(modulesWithIssues);
    }

    private boolean isProjectFileModified(ModuleSettings moduleSettings, VisualStudioProjectFile projectFile) {
        ModuleSettingsSignatureWithTimestamp signature = (ModuleSettingsSignatureWithTimestamp)moduleSettings.getUniqueChild(ModuleSettingsSignatureWithTimestamp.class);
        TFile vcxprojFile = projectFile.getFile();
        long lastModified = vcxprojFile.lastModified();
        return signature == null || signature.getTimestamp() != lastModified;
    }

    private void internValidateVisualStudioProjectBasedModule(CPlusPlusVsProjectFileBasedModule module) {
        assert (module != null) : "Parameter 'module' of method 'validateVisualStudioProjectBasedModule' must not be null";
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        ModuleCompilerOptions options = (ModuleCompilerOptions)((Object)moduleSettings.getUniqueChild(ModuleCompilerOptions.class));
        if (options == null) {
            return;
        }
        ModuleCompilerOptionsValidator validator = new ModuleCompilerOptionsValidator(options);
        validator.validate(true);
    }

    public OperationResultWithOutcome<VisualStudioProjectFileDelta> synchronize(CPlusPlusVsProjectFileBasedModule module) {
        List<TFile> includeDirectories;
        List<SourceFileBean> sourceFiles;
        assert (module != null) : "Parameter 'module' of method 'updateModuleDependenciesFromProjectFile' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Analyzing module based on Visual Studio Project file");
        VisualStudioProjectFileDelta delta = new VisualStudioProjectFileDelta();
        result.setOutcome((Object)delta);
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)moduleSettings.getUniqueChild(VisualStudioProjectFile.class));
        if (!this.isProjectFileModified(moduleSettings, projectFile)) {
            LOGGER.debug("No change in Visual Project file '" + projectFile.getAbsolutePath() + "' detected");
            return result;
        }
        projectFile.removeIssues();
        moduleSettings.removeIssues(new IIssueId[]{CPlusPlusIssueId.VISUAL_STUDIO_PROJECT_FILE_NOT_FOUND, CPlusPlusIssueId.VISUAL_STUDIO_PROJECT_FILE_PROCESSING_ERROR});
        TFile vcxprojFile = projectFile.getFile();
        if (!vcxprojFile.exists()) {
            String msg = String.format("Project file '%s' does not exist", vcxprojFile.getAbsolutePath());
            moduleSettings.addIssue((Issue)new VisualProjectFileNotFound((NamedElement)moduleSettings, msg));
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, msg, new Object[0]);
            return result;
        }
        if (!vcxprojFile.canRead()) {
            String msg = String.format("Cannot read project file '%s'", vcxprojFile.getAbsolutePath());
            moduleSettings.addIssue((Issue)new VisualStudioProjectFileProcessingIssue((NamedElement)moduleSettings, msg));
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, msg, new Object[0]);
            return result;
        }
        VisualStudioProjectImporter importer = new VisualStudioProjectImporter(vcxprojFile, projectFile.getSolutionDir());
        OperationResultWithOutcome<CPlusPlusVsProjectImportDto> importResult = importer.process();
        if (importResult.isFailure()) {
            String msg = String.format("Failed to process project file '%s': %s", vcxprojFile.getAbsolutePath(), StringUtility.concat((Collection)importResult.getErrorMessages(), (String)";"));
            VisualStudioProjectFileProcessingIssue issue = new VisualStudioProjectFileProcessingIssue((NamedElement)moduleSettings, msg);
            moduleSettings.addIssue((Issue)issue);
            result.addMessagesFrom(importResult);
            return result;
        }
        CPlusPlusVsProjectImportDto importDto = (CPlusPlusVsProjectImportDto)importResult.getOutcome();
        SolutionFileInfo.ConfigurationAndPlatform configuration = projectFile.getConfiguration();
        assert (configuration != null) : "Configuration of VS C++ project file '" + projectFile.getName() + "' must not be null";
        if (!importDto.getConfigurations().containsKey(configuration)) {
            String msg = String.format("Specified configuration '%s' not found in project file '%s'", configuration.toString(), vcxprojFile.getAbsolutePath());
            moduleSettings.addIssue((Issue)new VisualStudioProjectFileProcessingIssue((NamedElement)moduleSettings, msg));
            result.addError((OperationResult.IMessageCause)CppCauses.VS_PROJECT_FILE_PROCESSING_FAILED, msg, new Object[0]);
            return result;
        }
        projectFile.setProjectReferences(importDto.getProjectReferences());
        projectFile.setHeaderFiles(importDto.getHeaderFiles());
        this.refreshVisualStudioBasedModuleDependencies(module, true);
        ArrayList<TFile> removedSourceFiles = new ArrayList<TFile>();
        for (RootDirectoryPath nextRoot : module.getChildren(RootDirectoryPath.class)) {
            for (CppSourceFile sourceFile : nextRoot.getChildrenRecursively(CppSourceFile.class, new Class[]{CompilationUnitFragment.class})) {
                removedSourceFiles.add(new TFile((File)sourceFile.getFile().getNormalizedAbsoluteFile()));
            }
        }
        projectFile.removeSourceFiles();
        try {
            moduleSettings.removeIssues(new IIssueId[]{CPlusPlusIssueId.MSBUILD_FAILURE});
            CPlusPlusVsImportModuleDto dto = this.getSourceFilesViaMSBuild(projectFile.getConfiguration(), projectFile.getFile(), importDto.getToolsVersion(), projectFile.getSolutionDir());
            sourceFiles = dto.getSourceFiles();
            includeDirectories = dto.getModuleIncludeDirectoriese();
        }
        catch (MSBuildException ex) {
            String msg = ex.getMessage();
            LOGGER.error(msg);
            result.addError((OperationResult.IMessageCause)CppCauses.MSBUILD_EXCEPTION, msg, new Object[0]);
            moduleSettings.addIssue((Issue)new CPlusPlusMsBuildIssue((NamedElement)moduleSettings, msg));
            return result;
        }
        this.handleSourceFileSettings(delta, sourceFiles, removedSourceFiles, moduleSettings, projectFile);
        if (!sourceFiles.isEmpty()) {
            TFile commonRootDirectory = FileUtility.findCommonBaseDirectory(projectFile.getSourceFiles());
            if (commonRootDirectory == null) {
                result.addError((OperationResult.IMessageCause)ModuleImportMessageCause.FAILED_TO_COMPUTE_COMMON_ROOTDIRECTORY, "Source files of module '" + module.getName() + "' don't have a common root directory.", new Object[0]);
                return result;
            }
            CPlusPlusVsProjectImportSourceDirectoryPath rootDir = (CPlusPlusVsProjectImportSourceDirectoryPath)((Object)module.getUniqueChild(CPlusPlusVsProjectImportSourceDirectoryPath.class));
            if (rootDir == null) {
                module.addChild((NamedElement)new CPlusPlusVsProjectImportSourceDirectoryPath((IModelServiceProvider)this.m_softwareSystem, (NamedElement)module, commonRootDirectory));
            } else if (!FileUtility.areEqual((TFile)rootDir.getFile(), (TFile)commonRootDirectory)) {
                delta.setRootDirectoryToRemove(rootDir);
                module.addChild((NamedElement)new CPlusPlusVsProjectImportSourceDirectoryPath((IModelServiceProvider)this.m_softwareSystem, (NamedElement)module, commonRootDirectory));
                for (TFile sourceFile : projectFile.getSourceFiles()) {
                    if (removedSourceFiles.contains(sourceFile)) continue;
                    removedSourceFiles.add(sourceFile);
                }
            }
            delta.setRemovedFiles(removedSourceFiles);
            ModuleCompilerOptions previousCompilerOptions = (ModuleCompilerOptions)((Object)moduleSettings.getUniqueChild(ModuleCompilerOptions.class));
            if (previousCompilerOptions != null) {
                previousCompilerOptions.removeIssues();
                previousCompilerOptions.remove();
            }
            this.createCompilerOptionsForVsModule(moduleSettings, projectFile, includeDirectories);
            result.setOutcome((Object)delta);
            ((ModuleSettingsSignatureWithTimestamp)moduleSettings.getUniqueChild(ModuleSettingsSignatureWithTimestamp.class)).setTimestamp(projectFile.getFile().lastModified());
        } else {
            result.addWarning((OperationResult.IMessageCause)CppCauses.NO_SOURCE_FILES_FOUND_IN_MODULE, "Module: '" + module.getName() + "'.", new Object[0]);
        }
        return result;
    }

    private boolean checkForChangedDependencies(List<WorkspaceDependency> previousDependencies, List<WorkspaceDependency> currentDependencies) {
        if (previousDependencies.size() != currentDependencies.size()) {
            return true;
        }
        int i = 0;
        while (i < previousDependencies.size()) {
            if (!previousDependencies.get(i).getToId().equals(currentDependencies.get(i).getToId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void handleSourceFileSettings(VisualStudioProjectFileDelta delta, List<SourceFileBean> sourceFiles, List<TFile> removedSourceFiles, ModuleSettings moduleSettings, VisualStudioProjectFile projectFile) {
        SourceFileSettings sourceFileSettings = (SourceFileSettings)((Object)moduleSettings.getUniqueChild(SourceFileSettings.class));
        if (sourceFileSettings == null) {
            sourceFileSettings = new SourceFileSettings((NamedElement)moduleSettings);
            moduleSettings.addChild((NamedElement)sourceFileSettings);
        }
        ArrayList signaturesToRemove = new ArrayList(sourceFileSettings.getChildren(SourceFileSettingsSignature.class));
        ArrayList compilerOptionsToRemove = new ArrayList(sourceFileSettings.getChildren(SourceFileCompilerOptions.class));
        for (SourceFileBean nextSourceFile : sourceFiles) {
            TFile sourceFile = !FileUtility.isAbsolutePath((String)nextSourceFile.getFileName()) ? new TFile((File)projectFile.getFile().getParentFile(), nextSourceFile.getFileName()).getNormalizedAbsoluteFile() : new TFile(nextSourceFile.getFileName());
            String signatureString = HashSupport.SHA.getHexString(StringUtility.concat(nextSourceFile.getOptions(), (String)";"));
            String identifyingPath = FileUtility.getIdentifyingPath((TFile)sourceFile);
            String sourceIdentifier = SourceFileSettingsSignature.createIdentifier(identifyingPath, signatureString);
            SourceFileSettingsSignature signature = (SourceFileSettingsSignature)((Object)sourceFileSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(sourceIdentifier), SourceFileSettingsSignature.class));
            SourceFileCompilerOptions sourceFileOptions = (SourceFileCompilerOptions)((Object)sourceFileSettings.getUniqueChild((NamedElement.IFilter)new NameFilter(identifyingPath), SourceFileCompilerOptions.class));
            if (signature == null) {
                assert (sourceFileOptions == null) : "If no signature exists, also no SourceFileCompilerOptions are expected";
                sourceFileOptions = new SourceFileCompilerOptions((NamedElement)sourceFileSettings, sourceFile);
                sourceFileOptions.addOptions(nextSourceFile.getOptions());
                sourceFileSettings.addChild((NamedElement)sourceFileOptions);
                sourceFileSettings.addChild((NamedElement)new SourceFileSettingsSignature((NamedElement)sourceFileSettings, identifyingPath, signatureString));
                delta.addFileWithModifiedOptions(sourceFile);
            } else if (!sourceIdentifier.equalsIgnoreCase(signature.getName())) {
                signature.remove();
                assert (sourceFileOptions != null) : "'sourceFileOptions' must not be null";
                sourceFileOptions.remove();
                sourceFileOptions = new SourceFileCompilerOptions((NamedElement)sourceFileSettings, sourceFile);
                sourceFileOptions.addOptions(nextSourceFile.getOptions());
                sourceFileSettings.addChild((NamedElement)sourceFileOptions);
                sourceFileSettings.addChild((NamedElement)new SourceFileSettingsSignature((NamedElement)sourceFileSettings, identifyingPath, signatureString));
                delta.addFileWithModifiedOptions(sourceFile);
            } else if (sourceIdentifier.equalsIgnoreCase(signature.getName()) && sourceFileOptions == null) {
                sourceFileOptions = new SourceFileCompilerOptions((NamedElement)sourceFileSettings, sourceFile);
                sourceFileOptions.addOptions(nextSourceFile.getOptions());
                sourceFileSettings.addChild((NamedElement)sourceFileOptions);
            } else {
                signaturesToRemove.remove((Object)signature);
                compilerOptionsToRemove.remove((Object)sourceFileOptions);
            }
            removedSourceFiles.remove(sourceFile);
            projectFile.addSourceFile(sourceFile);
        }
        for (SourceFileSettingsSignature signature : signaturesToRemove) {
            signature.remove();
        }
        for (SourceFileCompilerOptions options : compilerOptionsToRemove) {
            options.remove();
        }
        for (TFile file : removedSourceFiles) {
            delta.addToRemovedFiles(file);
        }
    }

    private CPlusPlusVsImportModuleDto getSourceFilesViaMSBuild(SolutionFileInfo.ConfigurationAndPlatform configuration, TFile projectFile, String toolsVersion, TFile solutionDir) throws MSBuildException {
        assert (configuration != null) : "Parameter 'configuration' of method 'getSourceFilesViaMSBuild' must not be null";
        assert (projectFile != null) : "Parameter 'projectFile' of method 'getSourceFilesViaMSBuild' must not be null";
        assert (toolsVersion != null && toolsVersion.length() > 0) : "Parameter 'toolsVersion' of method 'getSourceFilesViaMSBuild' must not be empty";
        ICPlusPlusInstallationExtension instProvider = (ICPlusPlusInstallationExtension)((ISoftwareSystemProvider)this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class)).getInstallation().getExtension(ICPlusPlusInstallationExtension.class);
        InstCompilerDefinition activeDefinition = instProvider.getActiveCompilerDefinition();
        TFile instDir = new TFile(activeDefinition.getFixedConfigProperties().get("instDir"));
        String architecture = activeDefinition.getFixedConfigProperties().get("arch");
        TFile vcvarsall_bat = VisualStudioInstallationsExtension.getVcVarsallBat(instDir);
        if (vcvarsall_bat == null) {
            throw new MSBuildException("Failed to locate file 'vcvarsall.bat' in Visual Studio installation directory '" + instDir.getNormalizedAbsolutePath() + "'");
        }
        CPlusPlusMSBuildExecutor msbuildExecutor = new CPlusPlusMSBuildExecutor(vcvarsall_bat, architecture, projectFile, toolsVersion, solutionDir);
        CPlusPlusVsImportModuleDto importModuleDto = msbuildExecutor.runMsBuild(configuration.getConfiguration(), configuration.getPlatform());
        return importModuleDto;
    }

    private ModuleCompilerOptions createCompilerOptionsForVsModule(ModuleSettings moduleSettings, VisualStudioProjectFile projectFile, List<TFile> includeDirectories) {
        assert (moduleSettings != null) : "Parameter 'moduleSettings' of method 'createCompilerOptionsForVsModule' must not be null";
        assert (projectFile != null) : "Parameter 'projectFile' of method 'createCompilerOptionsForVsModule' must not be null";
        assert (includeDirectories != null) : "Parameter 'includeDirectories' of method 'createCompilerOptionsForVsModule' must not be null";
        InstCompilerDefinition activeDefinition = this.getActiveCompilerDefinition();
        VisualStudioModuleCompilerOptions compilerOptions = null;
        compilerOptions = activeDefinition != null ? new VisualStudioModuleCompilerOptions((NamedElement)moduleSettings, activeDefinition.getName()) : new VisualStudioModuleCompilerOptions((NamedElement)moduleSettings, "Default module compiler options");
        moduleSettings.addChild((NamedElement)compilerOptions);
        moduleSettings.removeChildren(new Class[]{CppSourceFileExtensions.class, CSourceFileExtensions.class});
        CppSourceFileExtensions cppSourceFileExtensions = new CppSourceFileExtensions((NamedElement)moduleSettings, projectFile.getCppSourceFileExtensions());
        moduleSettings.addChild((NamedElement)cppSourceFileExtensions);
        moduleSettings.addChild((NamedElement)new CSourceFileExtensions((NamedElement)moduleSettings));
        VisualStudioModuleCompilerOptions options = (VisualStudioModuleCompilerOptions)((Object)moduleSettings.getUniqueExistingChild(VisualStudioModuleCompilerOptions.class));
        for (TFile nextInclude : includeDirectories) {
            options.addOption("-I" + FileUtility.getCanonicalFilePath((TFile)nextInclude));
        }
        return compilerOptions;
    }

    public static void moveElements(CPlusPlusVsProjectFileBasedModule sourceModule, CPlusPlusVsProjectFileBasedModule targetModule) {
        ModuleCompilerOptions targetModuleOptions;
        assert (sourceModule != null) : "Parameter 'sourceModule' of method 'moveElements' must not be null";
        assert (targetModule != null) : "Parameter 'targetModule' of method 'moveElements' must not be null";
        ModuleSettings sourceSettings = (ModuleSettings)sourceModule.getUniqueChild(ModuleSettings.class);
        ModuleSettings targetSettings = (ModuleSettings)targetModule.getUniqueChild(ModuleSettings.class);
        ModuleCompilerOptions sourceModuleOptions = (ModuleCompilerOptions)((Object)sourceSettings.getUniqueChild(ModuleCompilerOptions.class));
        if (sourceModuleOptions == null) {
            targetSettings.remove();
            sourceSettings.changeParent((NamedElement)targetModule, true);
            return;
        }
        VisualStudioProjectFile targetProjectFile = (VisualStudioProjectFile)((Object)targetSettings.getUniqueChild(VisualStudioProjectFile.class));
        if (targetProjectFile != null) {
            targetProjectFile.remove();
        }
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)sourceSettings.getUniqueChild(VisualStudioProjectFile.class));
        projectFile.changeParent((NamedElement)targetSettings, true);
        ModuleSettingsSignatureWithTimestamp sourceSignature = (ModuleSettingsSignatureWithTimestamp)sourceSettings.getUniqueChild(ModuleSettingsSignatureWithTimestamp.class);
        if (sourceSignature != null) {
            ModuleSettingsSignatureWithTimestamp targetSignature = (ModuleSettingsSignatureWithTimestamp)targetSettings.getUniqueChild(ModuleSettingsSignatureWithTimestamp.class);
            if (targetSignature != null) {
                targetSignature.remove();
            }
            sourceSignature.setTimestamp(-1L);
            sourceSignature.changeParent((NamedElement)targetSettings, true);
        }
        if ((targetModuleOptions = (ModuleCompilerOptions)((Object)targetSettings.getUniqueChild(ModuleCompilerOptions.class))) != null) {
            targetModuleOptions.remove();
        }
        sourceModuleOptions.changeParent((NamedElement)targetSettings, true);
        BasePathForIncludes basePath = (BasePathForIncludes)((Object)sourceSettings.getUniqueChild(BasePathForIncludes.class));
        BasePathForIncludes targetBasePath = (BasePathForIncludes)((Object)targetSettings.getUniqueChild(BasePathForIncludes.class));
        if (targetBasePath != null) {
            targetBasePath.remove();
        }
        if (basePath != null) {
            basePath.changeParent((NamedElement)targetSettings, true);
        }
    }
}

