/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DiagnosticMode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDGVisitor;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusParser.class);
    private final DiagnosticMode m_diagnosticMode;
    private final TFile m_pchDir;
    private final TFile m_diagnosticsDir;

    public CPlusPlusParser(DiagnosticMode diagnosticMode, TFile projectDataDir, TFile cppDiagnosticsDir) {
        assert (diagnosticMode != null) : "Parameter 'diagnosticMode' of method 'CPlusPlusParser' must not be null";
        assert (projectDataDir != null) : "Parameter 'projectDataDir' of method 'CPlusPlusParser' must not be null";
        assert (cppDiagnosticsDir != null) : "Parameter 'cppDiagnosticsDir' of method 'CPlusPlusParser' must not be null";
        this.m_diagnosticMode = diagnosticMode;
        this.m_pchDir = new TFile((File)projectDataDir, "pch");
        this.m_diagnosticsDir = cppDiagnosticsDir;
        assert (this.m_diagnosticsDir.isDirectory());
    }

    public void invokePreprocesor(TFile sourceFile, List<String> options) {
        options.add(sourceFile.getAbsolutePath());
        this.writeDiagnosticFiles(null, sourceFile, options);
    }

    public int invokeParser(TFile sourceFile, List<String> options, EDGVisitor v) {
        assert (sourceFile != null) : "Parameter 'soureFile' of method 'invokeParser' must not be null";
        assert (options != null) : "Parameter 'options' of method 'invokeParser' must not be null";
        assert (v != null) : "v must not be null";
        if (options.contains("--pch")) {
            if (!this.m_pchDir.exists()) {
                this.m_pchDir.mkdir();
            }
            options.add(String.format("--pch_dir=%s", this.m_pchDir.getAbsolutePath()));
        }
        options.add(1, "--error_limit=50000");
        options.add(1, "--no_warnings");
        options.add(1, "--brief_diagnostics");
        options.add(sourceFile.getAbsolutePath());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking EDG parser on: " + sourceFile.getAbsolutePath());
            LOGGER.debug("Using compiler options: " + options.toString());
        }
        String[] extendedArgs = options.toArray(new String[options.size()]);
        int result = -1;
        try {
            String crashFolderName = "crash";
            if (LOGGER.isDebugEnabled()) {
                this.writeDiagnosticFiles("crash", sourceFile, options);
            }
            result = EDG.invokeParser(extendedArgs, v);
            if (LOGGER.isDebugEnabled()) {
                TFile crashFolder = new TFile((File)this.m_diagnosticsDir, "crash");
                try {
                    crashFolder.rm_r();
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected problem removing folder: " + crashFolder.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        catch (Throwable e) {
            LOGGER.error("Occured while parsing '" + sourceFile.getPath() + "'", e);
        }
        if (result != 0 && (this.m_diagnosticMode == DiagnosticMode.ALL_ERRORS || (result == -1 || result == 4) && this.m_diagnosticMode != DiagnosticMode.NO_DIAGNOSTICS)) {
            this.writeDiagnosticFiles(null, sourceFile, options);
        }
        return result;
    }

    private void cleanupOldDiagnostics() throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -7);
        Date cleanupDate = cal.getTime();
        String cleanupName = Iso8601DateFormat.formatDateAndTimeForFileName((Date)cleanupDate);
        TFile[] tFileArray = this.m_diagnosticsDir.listFiles();
        int n = tFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TFile oldDiagnosticDir = tFileArray[n2];
            if (oldDiagnosticDir.isDirectory() && oldDiagnosticDir.getName().compareTo(cleanupName) < 0) {
                oldDiagnosticDir.rm_r();
            }
            ++n2;
        }
    }

    private TFile createDiagnosticsFolder(String folderName) {
        TFile folder;
        if (folderName == null) {
            folderName = Iso8601DateFormat.formatDateAndTimeForFileName((Date)new Date());
        }
        if ((folder = new TFile((File)this.m_diagnosticsDir, folderName)).isDirectory()) {
            try {
                folder.rm_r();
            }
            catch (IOException e) {
                LOGGER.error("Unexpected problem removing folder: " + folder.getAbsolutePath(), (Throwable)e);
            }
        }
        folder.mkdir();
        return folder;
    }

    private void writeDiagnosticFiles(String folderName, TFile sourceFile, List<String> options) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'writeDiagnosticFiles' must not be null";
        assert (options != null && options.size() > 0) : "Parameter 'options' of method 'writeDiagnosticFiles' must not be empty";
        try {
            this.cleanupOldDiagnostics();
            TFile diagnosticDir = this.createDiagnosticsFolder(folderName);
            TFile expandedSource = new TFile((File)diagnosticDir, sourceFile.getName());
            TFile configurationFile = new TFile((File)diagnosticDir, "dump_configuration.h");
            String outputFileName = TFile.createTempFile((String)"edgout", (String)".txt").getPath();
            StringBuilder sb = new StringBuilder("// Options used\n");
            sb.append("//");
            String firstOption = options.get(0);
            assert (firstOption.startsWith("--error_output="));
            String errorFileName = firstOption.substring(firstOption.indexOf(61) + 1);
            options.remove(0);
            options.add(0, "--error_output=" + configurationFile.getAbsolutePath());
            options.add(1, "--dump_configuration");
            options.add(2, "-E");
            options.add(3, "--output=" + outputFileName);
            EDG.invokeParser(options.toArray(new String[options.size()]), null);
            for (String opt : options) {
                if (opt.startsWith("-D") || opt.startsWith("-E") || opt.startsWith("-I") || opt.startsWith("--sys_include") || opt.startsWith("--error_output") || opt.startsWith("--output") || opt.startsWith("--dump") || !opt.startsWith("-")) continue;
                sb.append(' ').append(opt);
            }
            sb.append('\n');
            FileUtility.combineFile((String)expandedSource.getAbsolutePath(), (Charset)Charset.defaultCharset(), (String)sb.toString(), (String)outputFileName);
            TFile messageFile = new TFile((File)diagnosticDir, "messages.txt");
            TFile errorMessageFile = new TFile(errorFileName);
            errorMessageFile.cp((File)messageFile);
        }
        catch (IOException ex) {
            LOGGER.error("Problem creating C++ diagnostics data", (Throwable)ex);
        }
    }
}

