/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.HeaderNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class Link {
    private final HeaderNode m_from;
    private final Node m_to;
    private final List<NamedElement> m_decls = new ArrayList<NamedElement>();

    Link(HeaderNode from, Node to) {
        this.m_from = from;
        this.m_to = to;
        this.m_to.addIncomingLink(this);
        this.m_from.addOutgoingLink(this);
    }

    HeaderNode getFrom() {
        return this.m_from;
    }

    Node getTo() {
        return this.m_to;
    }

    void addDeclaration(NamedElement decl) {
        this.m_decls.add(decl);
    }

    List<NamedElement> getDeclarations() {
        return Collections.unmodifiableList(this.m_decls);
    }

    int getWeight() {
        return this.m_decls.size();
    }

    public String toString() {
        return String.format("%s -> %s (%d)", this.m_from.toString(), this.m_to.toString(), this.getWeight());
    }
}

