/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Component;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.HeaderNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.Node;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.SourceNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.EmptySourceIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.SourceWithoutHeaderIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutineDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppVariable;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CppElementVisitor;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ComponentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentBuilder.class);
    private final Map<CppSource, SourceNode> m_sourceToSourceNodeMap = new LinkedHashMap<CppSource, SourceNode>();
    private final Map<CppSource, HeaderNode> m_sourceToHeaderNodeMap = new LinkedHashMap<CppSource, HeaderNode>();
    private HeaderNode m_currentHeader;

    ComponentBuilder(Collection<CppHeaderFile> headerFiles, Collection<CppSourceFile> sourceFiles, Map<TFile, CPlusPlusModule> headerToModuleMap, MultipleValueMap<TFile, CPlusPlusModule> rootsToModules) {
        assert (headerFiles != null) : "Parameter 'headerFiles' of method 'ComponentBuilder' must not be null";
        assert (sourceFiles != null) : "Parameter 'sourceFiles' of method 'ComponentBuilder' must not be null";
        assert (headerToModuleMap != null) : "Parameter 'headerToModuleMap' of method 'ComponentBuilder' must not be null";
        Collection roots = rootsToModules.keySet();
        for (CppHeaderFile nextHeader : headerFiles) {
            TFile headerFile = nextHeader.getFile();
            CPlusPlusModule module = headerToModuleMap.get(headerFile);
            if (module != null) {
                this.m_sourceToHeaderNodeMap.put(nextHeader, new HeaderNode(nextHeader, module));
            } else {
                List modules;
                List matchingRoots = roots.stream().filter(r -> r.isParentOf((File)headerFile)).collect(Collectors.toList());
                CPlusPlusModule myModule = null;
                if (matchingRoots.size() == 1 && (modules = rootsToModules.get((Object)((TFile)matchingRoots.get(0)))).size() == 1) {
                    myModule = (CPlusPlusModule)((Object)modules.iterator().next());
                }
                this.m_sourceToHeaderNodeMap.put(nextHeader, new HeaderNode(nextHeader, myModule));
            }
            for (CppVariable var : nextHeader.getChildren(CppVariable.class)) {
                var.removeIssues(new IIssueId[]{CPlusPlusIssueId.VAR_DEFINED_IN_HEADER});
            }
        }
        for (CppSourceFile source : sourceFiles) {
            this.m_sourceToSourceNodeMap.put(source, new SourceNode(source));
            source.removeIssues(new IIssueId[]{CPlusPlusIssueId.SOURCE_WITHOUT_HEADER, CPlusPlusIssueId.EMPTY_SOURCE});
        }
    }

    private void handleDeclaration(NamedElement decl, NamedElement def) {
        assert (decl != null);
        assert (def != null);
        CppSource source = (CppSource)((Object)def.getParent(CppSource.class, new Class[0]));
        if (source == null) {
            try {
                LOGGER.error("** Object has no source parent **", (Object)def.getDebugInfo());
                def.remove();
            }
            catch (Throwable t) {
                LOGGER.error("Could  not print debug info ", t);
            }
            return;
        }
        Node targetSourceNode = this.m_sourceToSourceNodeMap.get((Object)source);
        if (targetSourceNode == null) {
            Node targetHeaderNode = this.m_sourceToHeaderNodeMap.get((Object)source);
            if (targetHeaderNode != null) {
                if (targetHeaderNode != this.m_currentHeader) {
                    this.m_currentHeader.addLinkTo(targetHeaderNode, decl);
                }
            } else {
                def.remove();
            }
        } else {
            this.m_currentHeader.addLinkTo(targetSourceNode, decl);
        }
    }

    private void handleSolitarySource(SourceNode sourceNode, List<Component> components, List<HeaderNode> headerNodes) {
        CppSourceFile source = sourceNode.getSource();
        if (!source.hasChildren(false, new Class[]{CppRoutineDefinition.class, CppVariable.class, CppClassStructUnionNamespace.class})) {
            source.addIssue((Issue)new EmptySourceIssue((NamedElement)sourceNode.getSource()));
        }
        boolean reportSourceWithoutHeader = false;
        if (sourceNode.getIncoming().size() == 0) {
            boolean foundMain = false;
            String[] stringArray = new String[]{"main", "wmain", "WinMain", "wWinMain"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mainName = stringArray[n2];
                if (sourceNode.getSource().getFirstChild((NamedElement.IFilter)new ShortNameFilter(mainName), CppFunction.class) != null) {
                    foundMain = true;
                    break;
                }
                ++n2;
            }
            if (!foundMain) {
                reportSourceWithoutHeader = true;
            }
        }
        Component component = new Component();
        components.add(component);
        component.addSource(sourceNode);
        if (reportSourceWithoutHeader) {
            source.addIssue((Issue)new SourceWithoutHeaderIssue((NamedElement)sourceNode.getSource()));
        }
    }

    List<Component> buildComponents() {
        HeaderVisitor visitor = new HeaderVisitor();
        ArrayList<Component> components = new ArrayList<Component>();
        ArrayList<HeaderNode> headers = new ArrayList<HeaderNode>(this.m_sourceToHeaderNodeMap.values());
        Iterator<Object> iterator = headers.iterator();
        while (iterator.hasNext()) {
            HeaderNode headerNode;
            this.m_currentHeader = headerNode = (HeaderNode)iterator.next();
            headerNode.getSource().accept(visitor);
        }
        this.m_currentHeader = null;
        for (HeaderNode headerNode : headers) {
            if (headerNode.getComponent() != null) continue;
            Component component = new Component();
            headerNode.buildComponent(component);
            if (component.mustBeSplit()) {
                components.addAll(component.split());
                continue;
            }
            components.add(component);
        }
        components.forEach(Component::createdMisplacedDeclarationWarnings);
        for (SourceNode sourceNode : this.m_sourceToSourceNodeMap.values()) {
            if (sourceNode.getComponent() != null) continue;
            this.handleSolitarySource(sourceNode, components, headers);
        }
        return components;
    }

    private class HeaderVisitor
    extends CppElementVisitor
    implements NamedElementProxy.IVisitor {
        HeaderVisitor() {
        }

        @Override
        public void visitCppMemberFunctionDeclaration(CppMemberFunctionDeclaration declaration) {
            assert (declaration != null) : "Parameter 'declaration' of method 'visitCppMemberFunctionDeclaration' must not be null";
            CppRoutine definition = declaration.getDefinition();
            if (!(definition == null || definition.isInline() && definition.getParent(CppSourceFile.class, new Class[0]) == null)) {
                ComponentBuilder.this.handleDeclaration((NamedElement)declaration, (NamedElement)definition);
            }
        }

        @Override
        public void visitCppFunctionDeclaration(CppFunctionDeclaration declaration) {
            assert (declaration != null) : "Parameter 'declaration' of method 'visitCppFunctionDeclaration' must not be null";
            CppRoutine definition = declaration.getDefinition();
            if (!(definition == null || definition.isInline() && definition.getParent(CppSourceFile.class, new Class[0]) == null)) {
                ComponentBuilder.this.handleDeclaration((NamedElement)declaration, (NamedElement)definition);
            }
        }

        @Override
        public void visitCppVariable(CppVariable variable) {
            CppVariable variableDefinition;
            if (!variable.isDefinition() && (variableDefinition = variable.getDefinition()) != null) {
                ComponentBuilder.this.handleDeclaration((NamedElement)variable, (NamedElement)variableDefinition);
            }
        }

        public void visitNamedElementProxy(NamedElementProxy element) {
            ComponentBuilder.this.handleDeclaration((NamedElement)element, element.getElement());
        }
    }
}

