/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.PluginExecutionPhase;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementWithDescriptionImpl;
import java.util.Collections;
import java.util.Set;

public class PluginImpl
extends ElementWithDescriptionImpl
implements IPlugin {
    private static final long serialVersionUID = 2844288755616364951L;
    private final String vendor;
    private final String version;
    private final boolean isLicensed;
    private final boolean isEnabled;
    private final Set<PluginExecutionPhase> supportedExecutionPhases;
    private final Set<PluginExecutionPhase> activeExecutionPhases;

    public PluginImpl(String name, String presentationName, String description, String vendor, String version, boolean isLicensed, boolean isEnabled, Set<PluginExecutionPhase> supportedExecutionPhases, Set<PluginExecutionPhase> activeExecutionPhases) {
        super(name, presentationName, description);
        assert (vendor != null && vendor.length() > 0) : "Parameter 'vendor' of method 'PluginImpl' must not be empty";
        assert (version != null) : "Parameter 'version' of method 'PluginImpl' must not be null";
        assert (supportedExecutionPhases != null && !supportedExecutionPhases.isEmpty()) : "Parameter 'supportedExecutionPhases' of method 'PluginImpl' must not be empty";
        assert (activeExecutionPhases != null) : "Parameter 'activeExecutionPhases' of method 'PluginImpl' must not be null";
        this.vendor = vendor;
        this.version = version;
        this.isLicensed = isLicensed;
        this.isEnabled = isEnabled;
        this.supportedExecutionPhases = supportedExecutionPhases;
        this.activeExecutionPhases = activeExecutionPhases;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isLicensed() {
        return this.isLicensed;
    }

    @Override
    public Set<PluginExecutionPhase> getActiveExecutionPhases() {
        return Collections.unmodifiableSet(this.activeExecutionPhases);
    }

    @Override
    public Set<PluginExecutionPhase> getSupportedExecutionPhases() {
        return Collections.unmodifiableSet(this.supportedExecutionPhases);
    }
}

