/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.apitest;

import com.hello2morrow.sonargraph.integration.access.controller.ControllerFactory;
import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISonargraphSystemController;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public final class ModuleInfoProcessorRefactoringsTest {
    @Test
    public void getSourceFilesAffectedByRefactorings() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClockMain_Refactorings.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
        Map<String, IModule> moduleMap = controller.getSoftwareSystem().getModules();
        IModule alarmClock = moduleMap.get("AlarmClock");
        Assert.assertNotNull((String)"Module 'AlarmClock' not found", (Object)alarmClock);
        IModuleInfoProcessor moduleInfoProcessor = controller.createModuleInfoProcessor(alarmClock);
        Map<ISourceFile, Map<IResolution, List<IIssue>>> resolutionsForSourceFiles = moduleInfoProcessor.getIssuesForResolutionsForSourceFiles(r -> r.getType() == ResolutionType.REFACTORING);
        Assert.assertEquals((String)"Wrong number of source files with refactorings", (long)2L, (long)resolutionsForSourceFiles.size());
        Optional<Map.Entry> c1Opt = resolutionsForSourceFiles.entrySet().stream().filter(e -> ((ISourceFile)e.getKey()).getName().equals("C1.java")).findFirst();
        Assert.assertTrue((String)"Refactoring for C1.java not found", (boolean)c1Opt.isPresent());
        Map.Entry entryC1 = c1Opt.get();
        Map resolutionToIssues = (Map)entryC1.getValue();
        List resolutionToIssue = resolutionToIssues.entrySet().stream().collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong number of refactorings for C1", (long)1L, (long)resolutionToIssue.size());
        IResolution resolution = (IResolution)((Map.Entry)resolutionToIssue.get(0)).getKey();
        Assert.assertEquals((String)"Wrong resolution text", (Object)"", (Object)resolution.getDescription());
        Assert.assertEquals((String)"Wrong issue description", (Object)"Rename to 'C1_2'", (Object)((IIssue)((List)((Map.Entry)resolutionToIssue.get(0)).getValue()).get(0)).getDescription());
        Optional<Map.Entry> alarmClockSourceOpt = resolutionsForSourceFiles.entrySet().stream().filter(e -> ((ISourceFile)e.getKey()).getName().equals("AlarmClock.java")).findFirst();
        Assert.assertTrue((String)"Refactoring for C1.java not found", (boolean)alarmClockSourceOpt.isPresent());
        Map.Entry entryAlarmClock = alarmClockSourceOpt.get();
        Map resolutionToIssues2 = (Map)entryAlarmClock.getValue();
        List resolutionToIssue2 = resolutionToIssues2.entrySet().stream().collect(Collectors.toList());
        Assert.assertEquals((String)"Wrong number of refactorings for AlarmClock", (long)1L, (long)resolutionToIssue2.size());
        IResolution resolution2 = (IResolution)((Map.Entry)resolutionToIssue2.get(0)).getKey();
        Assert.assertEquals((String)"Wrong resolution text", (Object)"", (Object)resolution2.getDescription());
        Assert.assertEquals((String)"Wrong issue description", (Object)"Rename to 'AlarmClock2'", (Object)((IIssue)((List)((Map.Entry)resolutionToIssue2.get(0)).getValue()).get(0)).getDescription());
    }

    @Test
    public void processReportWithDuplicateFqNames() {
        ISonargraphSystemController controller = ControllerFactory.createController();
        Result result = controller.loadSystemReport(new File("./src/test/resources/AlarmClockMain_Refactorings_DuplicateFqName.xml"));
        Assert.assertTrue((String)("Failed to read report: " + result.toString()), (boolean)result.isSuccess());
    }
}

