/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.Collection;
import java.util.Iterator;

public final class Joiner {
    private static <T> String join(T[] list, ToString<T> converter, String separator) {
        assert (list != null) : "Parameter 'list' of method 'join' must not be null";
        assert (converter != null) : "Parameter 'converter' of method 'join' must not be null";
        assert (separator != null) : "Parameter 'separator' of method 'join' must not be null";
        StringBuilder builder = new StringBuilder();
        if (list.length > 0) {
            builder.append(converter.convert(list[0]));
            int i = 1;
            while (i < list.length) {
                builder.append(separator);
                builder.append(converter.convert(list[i]));
                ++i;
            }
        }
        return builder.toString();
    }

    private static <T> String join(Collection<T> cltn, ToString<T> converter, String separator) {
        assert (cltn != null) : "Parameter 'cltn' of method 'join' must not be null";
        assert (converter != null) : "Parameter 'converter' of method 'join' must not be null";
        assert (separator != null) : "Parameter 'separator' of method 'join' must not be null";
        StringBuilder builder = new StringBuilder();
        Iterator<T> iter = cltn.iterator();
        if (iter.hasNext()) {
            builder.append(converter.convert(iter.next()));
            while (iter.hasNext()) {
                builder.append(separator);
                builder.append(converter.convert(iter.next()));
            }
        }
        return builder.toString();
    }

    public static <T> String join(T[] list) {
        return Joiner.join(list, (T obj) -> obj.toString(), ", ");
    }

    public static <T> String join(Collection<T> cltn, ToString<T> converter) {
        return Joiner.join(cltn, converter, ", ");
    }

    public static <T> String join(Collection<T> cltn) {
        return Joiner.join(cltn, (T obj) -> obj.toString(), ", ");
    }

    public static interface ToString<T> {
        public String convert(T var1);
    }
}

