/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class Iso8601DateFormat {
    public static final String ISO_8601_DATE_FORMAT_STRING = "yyyy-MM-dd";
    private static final String ISO_8601_TIME_FORMAT_STRING = "HH:mm:ss";
    public static final String ISO_8601_DATE_AND_TIME_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    private static final String ISO_8601_DATA_AND_TIME_UNIVERSAL_TIMEZONE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss Z";
    private static final String ISO_8601_DATE_AND_TIME_FORMAT_STRING_FOR_FILENAME = "yyyy-MM-dd_HH-mm-ss_SSS";

    public static String formatDate(Date date) {
        assert (date != null) : "'date' must not be null";
        return new SimpleDateFormat(ISO_8601_DATE_FORMAT_STRING).format(date);
    }

    public static Date parseDate(String date) {
        assert (date != null) : "'date' must not be null";
        assert (date.length() > 0) : "'date' must not be empty";
        try {
            return new SimpleDateFormat(ISO_8601_DATE_FORMAT_STRING).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatTime(Date date) {
        assert (date != null) : "'date' must not be null";
        return new SimpleDateFormat(ISO_8601_TIME_FORMAT_STRING).format(date);
    }

    public static Date parseTime(String date) {
        assert (date != null) : "'date' must not be null";
        assert (date.length() > 0) : "'date' must not be empty";
        try {
            return new SimpleDateFormat(ISO_8601_TIME_FORMAT_STRING).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDateAndTimeForUniversalTimezone(Date date) {
        assert (date != null) : "Parameter 'date' of method 'formatDateAndTime' must not be null";
        return new SimpleDateFormat(ISO_8601_DATA_AND_TIME_UNIVERSAL_TIMEZONE_FORMAT_STRING).format(date);
    }

    public static Date parseDateAndTimeForUniversalTimezone(String date) {
        assert (date != null) : "'date' must not be null";
        assert (date.length() > 0) : "'date' must not be empty";
        try {
            return new SimpleDateFormat(ISO_8601_DATA_AND_TIME_UNIVERSAL_TIMEZONE_FORMAT_STRING).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDateAndTime(Date date) {
        assert (date != null) : "'date' must not be null";
        return new SimpleDateFormat(ISO_8601_DATE_AND_TIME_FORMAT_STRING).format(date);
    }

    public static Date parseDateAndTime(String date) {
        assert (date != null) : "'date' must not be null";
        assert (date.length() > 0) : "'date' must not be empty";
        try {
            return new SimpleDateFormat(ISO_8601_DATE_AND_TIME_FORMAT_STRING).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDateAndTimeForFileName(Date date) {
        assert (date != null) : "'date' must not be null";
        return new SimpleDateFormat(ISO_8601_DATE_AND_TIME_FORMAT_STRING_FOR_FILENAME).format(date);
    }

    public static DateFormat createStandardDateTimeFormat() {
        return new SimpleDateFormat(ISO_8601_DATE_AND_TIME_FORMAT_STRING);
    }

    public static Date parseDataAndTime(String date, String format) {
        assert (date != null && date.length() > 0) : "Parameter 'date' of method 'parseDataAndTime' must not be empty";
        assert (format != null && format.length() > 0) : "Parameter 'format' of method 'parseDataAndTime' must not be empty";
        try {
            return new SimpleDateFormat(format).parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

