/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashSupport
extends Enum<HashSupport> {
    public static final /* enum */ HashSupport MD5 = new HashSupport("MD5");
    public static final /* enum */ HashSupport SHA = new HashSupport("SHA-256");
    private static final char[] HEX_CHARS;
    private final String m_algorithm;
    private static final /* synthetic */ HashSupport[] ENUM$VALUES;

    static {
        ENUM$VALUES = new HashSupport[]{MD5, SHA};
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    private HashSupport(String algorithm) {
        assert (algorithm != null && algorithm.length() > 0) : "Parameter 'algorithm' of method 'HashSupport' must not be empty";
        this.m_algorithm = algorithm;
    }

    public String getHexString(String input) {
        byte[] hash = this.getHash(input);
        if (hash == null) {
            return null;
        }
        char[] buf = new char[hash.length * 2];
        int i = 0;
        int x = 0;
        while (i < hash.length) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public byte[] getHash(String input) {
        assert (input != null && input.length() > 0) : "Parameter 'input' of method 'getMD5Hash' must not be empty";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.m_algorithm);
            messageDigest.update(input.getBytes("UTF-8"));
            return messageDigest.digest();
        }
        catch (UnsupportedEncodingException ex) {
            assert (false) : "Encoding unknown: UTF-8";
            return null;
        }
        catch (NoSuchAlgorithmException ex) {
            assert (false) : "Algorithm unknown: " + this.m_algorithm;
            return null;
        }
    }

    public static HashSupport[] values() {
        HashSupport[] hashSupportArray = ENUM$VALUES;
        int n = hashSupportArray.length;
        HashSupport[] hashSupportArray2 = new HashSupport[n];
        System.arraycopy(ENUM$VALUES, 0, hashSupportArray2, 0, n);
        return hashSupportArray2;
    }

    public static HashSupport valueOf(String string) {
        return Enum.valueOf(HashSupport.class, string);
    }
}

