/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.text;

import com.hello2morrow.sonargraph.foundation.text.IntBasedHash;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class Levenshtein {
    private static final int[] EMTPY = new int[]{"".hashCode()};
    private static final Pattern SPLIT_LINE_INTO_WORDS = Pattern.compile("[\\p{Punct}\\p{Blank}\\p{Space}]+");
    private static final Pattern SPLIT_CAMELCASE = Pattern.compile("(?<=[a-z])(?=[A-Z])|(?<=[A-Z])(?=[A-Z][a-z])");

    private Levenshtein() {
    }

    public static StrictPair<Double, Integer> similarity(List<String> content1, List<String> content2) {
        assert (content1 != null) : "Parameter 'content1' of method 'similarity' must not be null";
        assert (content2 != null) : "Parameter 'content2' of method 'similarity' must not be null";
        IntBasedHash hash1 = Levenshtein.createIntHash(content1.toArray(new String[0]));
        IntBasedHash hash2 = Levenshtein.createIntHash(content2.toArray(new String[0]));
        return Levenshtein.similarity(hash1, hash2);
    }

    public static StrictPair<Double, Integer> similarity(IntBasedHash h1, IntBasedHash h2) {
        assert (h1 != null) : "Parameter 'h1' of method 'similarity' must not be null";
        assert (h2 != null) : "Parameter 'h2' of method 'similarity' must not be null";
        int distance = Levenshtein.computeDistance(h1.getArray(), h2.getArray());
        double similarity = 1.0 - (double)distance / (double)Math.max(h1.length(), h2.length());
        return new StrictPair<Double, Integer>(similarity, distance);
    }

    public static StrictPair<Double, Integer> similarity(String s1, String s2) {
        int distance = Levenshtein.computeDistance(s1, s2);
        double similarity = 1.0 - (double)distance / (double)Math.max(s1.length(), s2.length());
        return new StrictPair<Double, Integer>(similarity, distance);
    }

    public static StrictPair<Double, Integer> similarity(String s1, String s2, double minimumRequiredSimilarity) {
        assert (s1 != null) : "Parameter 's1' of method 'similarity' must not be null";
        assert (s2 != null) : "Parameter 's2' of method 'similarity' must not be null";
        int minimumPossibleDistance = Math.abs(s1.length() - s2.length());
        double maxPossibleSimilarity = 1.0 - (double)minimumPossibleDistance / (double)Math.max(s1.length(), s2.length());
        if (Double.compare(maxPossibleSimilarity, minimumRequiredSimilarity) < 0) {
            return null;
        }
        StrictPair<Double, Integer> similarity = Levenshtein.similarity(s1, s2);
        if (Double.compare(similarity.getFirst(), minimumRequiredSimilarity) < 0) {
            return null;
        }
        return similarity;
    }

    public static IntBasedHash createIntHash(String[] lines) {
        assert (lines != null) : "Parameter 'content' of method 'createIntHash' must not be null";
        int[] hashes = new int[lines.length];
        int i = 0;
        while (i < lines.length) {
            hashes[i] = Levenshtein.createIntHash(lines[i]);
            ++i;
        }
        return new IntBasedHash(hashes);
    }

    public static int createIntHash(String line) {
        assert (line != null) : "Parameter 'line' of method 'createHash' must not be null";
        String trimmed = line.trim();
        return trimmed.hashCode();
    }

    public static int computeDistance(CharSequence leftSeq, CharSequence rightSeq) {
        assert (leftSeq != null) : "Parameter 'left' of method 'computeDistance' must not be null";
        assert (rightSeq != null) : "Parameter 'right' of method 'computeDistance' must not be null";
        int leftLength = leftSeq.length();
        int rightLength = rightSeq.length();
        if (leftLength == 0) {
            return rightLength;
        }
        if (rightLength == 0) {
            return leftLength;
        }
        if (leftLength > rightLength) {
            CharSequence tmp = leftSeq;
            leftSeq = rightSeq;
            rightSeq = tmp;
            leftLength = rightLength;
            rightLength = rightSeq.length();
        }
        int[] costs = new int[leftLength + 1];
        int leftIndex = 0;
        while (leftIndex <= leftLength) {
            costs[leftIndex] = leftIndex;
            ++leftIndex;
        }
        int rightIndex = 1;
        while (rightIndex <= rightLength) {
            int upperLeft = costs[0];
            char rightChar = rightSeq.charAt(rightIndex - 1);
            costs[0] = rightIndex;
            leftIndex = 1;
            while (leftIndex <= leftLength) {
                int upper = costs[leftIndex];
                int cost = leftSeq.charAt(leftIndex - 1) == rightChar ? 0 : 1;
                costs[leftIndex] = Math.min(Math.min(costs[leftIndex - 1] + 1, costs[leftIndex] + 1), upperLeft + cost);
                upperLeft = upper;
                ++leftIndex;
            }
            ++rightIndex;
        }
        return costs[leftLength];
    }

    public static int computeDistance(int[] left, int[] right) {
        assert (left != null) : "Parameter 'left' of method 'computeDistance' must not be null";
        assert (right != null) : "Parameter 'right' of method 'computeDistance' must not be null";
        int leftLength = left.length;
        int rightLength = right.length;
        if (leftLength == 0) {
            return rightLength;
        }
        if (rightLength == 0) {
            return leftLength;
        }
        if (leftLength > rightLength) {
            int[] tmp = left;
            left = right;
            right = tmp;
            leftLength = rightLength;
            rightLength = right.length;
        }
        int[] costs = new int[leftLength + 1];
        int leftIndex = 0;
        while (leftIndex <= leftLength) {
            costs[leftIndex] = leftIndex;
            ++leftIndex;
        }
        int rightIndex = 1;
        while (rightIndex <= rightLength) {
            int upperLeft = costs[0];
            int rightInt = right[rightIndex - 1];
            costs[0] = rightIndex;
            leftIndex = 1;
            while (leftIndex <= leftLength) {
                int upper = costs[leftIndex];
                int cost = left[leftIndex - 1] == rightInt ? 0 : 1;
                costs[leftIndex] = Math.min(Math.min(costs[leftIndex - 1] + 1, costs[leftIndex] + 1), upperLeft + cost);
                upperLeft = upper;
                ++leftIndex;
            }
            ++rightIndex;
        }
        return costs[leftLength];
    }

    public static int[] createHashForWordsOfLine(String line) {
        assert (line != null) : "Parameter 'lines' of method 'createHashsForWordsOfLines' must not be null";
        String input = line.trim();
        if (input.length() == 0) {
            return EMTPY;
        }
        ArrayList<String> words = new ArrayList<String>();
        String[] stringArray = SPLIT_LINE_INTO_WORDS.split(input);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nextWord = stringArray[n2];
            String[] stringArray2 = SPLIT_CAMELCASE.split(nextWord);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String nextPart = stringArray2[n4];
                words.add(nextPart.trim());
                ++n4;
            }
            ++n2;
        }
        if (words.isEmpty()) {
            return EMTPY;
        }
        int[] result = new int[words.size()];
        int i = 0;
        while (i < words.size()) {
            result[i] = ((String)words.get(i)).hashCode();
            ++i;
        }
        return result;
    }

    public static IntBasedHash createHashsForWordsOfLines(String[] lines) {
        assert (lines != null) : "Parameter 'lines' of method 'createHashForWordsOfLines' must not be null";
        int[] hashCodes = new int[]{};
        int i = 0;
        while (i < lines.length) {
            int[] newHashes = Levenshtein.createHashForWordsOfLine(lines[i]);
            int[] update = new int[hashCodes.length + newHashes.length];
            System.arraycopy(hashCodes, 0, update, 0, hashCodes.length);
            System.arraycopy(newHashes, 0, update, hashCodes.length, newHashes.length);
            hashCodes = update;
            ++i;
        }
        return new IntBasedHash(hashCodes);
    }
}

