/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import com.hello2morrow.sonargraph.foundation.file.DeletingFileVisitor;
import com.hello2morrow.sonargraph.foundation.file.DirectoryMapping;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.SmartReader;
import com.hello2morrow.sonargraph.foundation.file.TFilenameFilter;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtility {
    private static final String[] INVALID_RESOURCE_CHARACTERS = new String[]{"/", "\n", "\r", "\t", "\u0000", "\f", "`", "?", "*", "\\", "<", ">", "|", "\"", ":", " "};
    private static final String[] INVALID_RESOURCE_BASENAMES = new String[]{"aux", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
    private static final String[] INVALID_RESOURCE_FULLNAMES = new String[]{"clock$"};
    public static final char PATH_SEPARATOR_CHAR = '/';
    private static final char WINDOWS_PATH_SEPARATOR_CHAR = '\\';
    public static final char EXTENSION_SEPARATOR_CHAR = '.';
    public static final String REL_PATH_START = "./";
    public static final String PATH_SEPARATOR = "/";
    public static final String RELATIVE_PATH_CURRENT = ".";
    public static final String RELATIVE_PATH_UP = "..";
    public static final char PATH_SEPARATOR_CHAR_TO_BE_CONVERTED = '\\';
    public static final String SYSTEM_PATH_SEPARATOR = System.getProperty("file.separator");
    public static final String STANDARD_DIRECTORY_NAME_PATTERN = "[\\w\\-]+[ \\w\\-]*";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtility.class);

    private FileUtility() {
    }

    public static String removeExtension(String fileName) {
        int index;
        assert (fileName != null) : "Parameter 'fileName' of method 'removeExtension' must not be null";
        if (FileUtility.hasExtension(fileName) && (index = fileName.lastIndexOf(46)) > 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    private static boolean onDifferentRootNodes(String pathOne, String pathTwo, boolean ignoreCase) {
        assert (pathOne != null) : "'pathOne' must not be null";
        assert (pathOne.length() > 0) : "'pathOne' must not be empty";
        assert (pathTwo != null) : "'pathTwo' must not be null";
        assert (pathTwo.length() > 0) : "'pathTwo' must not be empty";
        if (!Platform.isOperatingSystemUnixBased()) {
            if (ignoreCase) {
                return pathOne.toLowerCase().charAt(0) != pathTwo.toLowerCase().charAt(0);
            }
            return pathOne.charAt(0) != pathTwo.charAt(0);
        }
        return false;
    }

    public static List<String> getPathParts(String path) {
        assert (path != null) : "'path' must not be null";
        StringTokenizer tokenizer = new StringTokenizer(path, PATH_SEPARATOR);
        ArrayList<String> relativePathParts = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            relativePathParts.add(tokenizer.nextToken());
        }
        return relativePathParts;
    }

    public static void copyDirectory(TFile from, TFile to, boolean overwriteTarget, OperationResult result) {
        TFile[] tFileArray = from.listFiles();
        int n = tFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            TFile entry = tFileArray[n2];
            TFile target = new TFile((File)to, entry.getName());
            if (entry.isDirectory()) {
                target.mkdirs();
                FileUtility.copyDirectory(entry, target, overwriteTarget, result);
            } else if (overwriteTarget || !target.exists()) {
                try {
                    entry.cp((File)target);
                }
                catch (IOException e) {
                    result.addError(IOMessageCause.FAILED_TO_COPY, e);
                }
            }
            ++n2;
        }
    }

    public static String calculateRelativePath(TFile path, TFile basePath) {
        boolean ignoreCase;
        int length;
        assert (path != null) : "Parameter 'path' of method 'calculateRelativePath' must not be null";
        if (basePath == null) {
            return FileUtility.getIdentifyingPath(path);
        }
        String basePathAsString = FileUtility.getIdentifyingPath(basePath);
        if (basePathAsString.charAt((length = basePathAsString.length()) - 1) == '/') {
            basePathAsString = basePathAsString.substring(0, length - 1);
        }
        String pathAsString = FileUtility.getIdentifyingPath(path);
        boolean bl = ignoreCase = !Platform.isOperatingSystemCaseSensitive();
        if (ignoreCase ? pathAsString.toLowerCase().startsWith(basePathAsString.toLowerCase()) : pathAsString.startsWith(basePathAsString)) {
            int offset = basePathAsString.length();
            if (pathAsString.length() == offset) {
                return RELATIVE_PATH_CURRENT;
            }
            if (pathAsString.charAt(offset) == '/') {
                return RELATIVE_PATH_CURRENT + pathAsString.substring(offset);
            }
        }
        if (!FileUtility.onDifferentRootNodes(basePathAsString, pathAsString, ignoreCase)) {
            return FileUtility.getRelativePath(FileUtility.getPathParts(basePathAsString), FileUtility.getPathParts(pathAsString), ignoreCase);
        }
        return pathAsString;
    }

    public static String convertPathToUniversalForm(String path) {
        assert (path != null) : "Parameter 'path' of method 'calculatePath' must not be null";
        return path.replace('\\', '/');
    }

    public static boolean normalizedPathMightDenoteFilePath(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'normalizedPathMightDenoteAFilePath' must not be empty";
        String converted = FileUtility.convertPathToUniversalForm(path);
        char lastChar = converted.charAt(converted.length() - 1);
        return lastChar != '.' && lastChar != '/';
    }

    public static boolean isNormalizedPathAbsolute(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'isNormalizedPathAbsolute' must not be empty";
        String converted = FileUtility.convertPathToUniversalForm(path);
        if (converted.startsWith(PATH_SEPARATOR)) {
            return true;
        }
        if (converted.length() >= 3) {
            return Pattern.matches("[A-Za-z]:/", converted.substring(0, 3));
        }
        return false;
    }

    private static String getRelativePath(List<String> basePathParts, List<String> convertToRelativePathParts, boolean ignoreCase) {
        StringBuffer buffer;
        block8: {
            int numberOfEqualParts;
            block7: {
                assert (basePathParts != null) : "'basePathParts' must not be null";
                assert (convertToRelativePathParts != null) : "'convertToRelativePathParts' must not be null";
                numberOfEqualParts = 0;
                int i = 0;
                while (i < basePathParts.size() && i < convertToRelativePathParts.size()) {
                    if (!(ignoreCase ? basePathParts.get(i).equalsIgnoreCase(convertToRelativePathParts.get(i)) : basePathParts.get(i).equals(convertToRelativePathParts.get(i)))) break;
                    ++numberOfEqualParts;
                    ++i;
                }
                buffer = new StringBuffer();
                if (numberOfEqualParts != basePathParts.size()) break block7;
                if (numberOfEqualParts >= convertToRelativePathParts.size()) break block8;
                int i2 = numberOfEqualParts;
                while (i2 < convertToRelativePathParts.size()) {
                    if (i2 > numberOfEqualParts) {
                        buffer.append('/');
                    }
                    buffer.append(convertToRelativePathParts.get(i2));
                    ++i2;
                }
                break block8;
            }
            int i = 0;
            while (i < basePathParts.size() - numberOfEqualParts - 1) {
                buffer.append(RELATIVE_PATH_UP);
                buffer.append('/');
                ++i;
            }
            buffer.append(RELATIVE_PATH_UP);
            i = numberOfEqualParts;
            while (i < convertToRelativePathParts.size()) {
                buffer.append('/');
                buffer.append(convertToRelativePathParts.get(i));
                ++i;
            }
        }
        return buffer.toString();
    }

    public static String getCanonicalFilePath(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getCanonicalFile' must not be null";
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getNormalizedAbsolutePath();
        }
    }

    public static boolean refersToSameFile(TFile file1, TFile file2) {
        if (file1 == file2) {
            return true;
        }
        if (file1 != null && file2 != null) {
            String pathFile1 = FileUtility.convertPathToUniversalForm(FileUtility.getCanonicalFilePath(file1));
            String pathFile2 = FileUtility.convertPathToUniversalForm(FileUtility.getCanonicalFilePath(file2));
            return Platform.isCaseSensitive() ? pathFile1.equals(pathFile2) : pathFile1.equalsIgnoreCase(pathFile2);
        }
        return false;
    }

    public static boolean refersToSameFileName(String fileName1, String fileName2) {
        assert (fileName1 != null && fileName1.length() > 0) : "Parameter 'fileName1' of method 'refersToSameFileName' must not be empty";
        assert (fileName2 != null && fileName2.length() > 0) : "Parameter 'fileName2' of method 'refersToSameFileName' must not be empty";
        return Platform.isCaseSensitive() ? fileName1.equals(fileName2) : fileName1.equalsIgnoreCase(fileName2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void combineFile(String path, Charset encoding, String header, String pathToFile) throws IOException {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'combineFile' must not be empty";
        assert (encoding != null) : "Parameter 'encoding' of method 'combineFile' must not be null";
        assert (header != null) : "Parameter 'header' of method 'combineFile' must not be null";
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            OutputStream out = Files.newOutputStream(Paths.get(path, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            try {
                try (InputStream input = Files.newInputStream(Paths.get(pathToFile, new String[0]), StandardOpenOption.READ);){
                    int bytesRead;
                    out.write(header.getBytes());
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = input.read(buffer)) >= 0) {
                        if (bytesRead <= 0) continue;
                        out.write(buffer, 0, bytesRead);
                    }
                }
                if (out == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            out.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static boolean pathExists(String path) {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'readFile' must not be empty";
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static void writeFileContent(String content, OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            writer.write(content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void writeFileContent(String content, TFile file) throws IOException {
        FileUtility.writeFileContent(content, (OutputStream)new TFileOutputStream((File)file));
    }

    public static List<String> getFileLinesWithLineBreaks(TFile file) throws IOException {
        assert (file != null) : "Parameter 'file' of method 'getFileContentWithLineBreaks' must not be null";
        Throwable throwable = null;
        Object var2_3 = null;
        try (SmartReader reader = new SmartReader((InputStream)new TFileInputStream((File)file));){
            List<String> lines = reader.readLinesAndNormalizeLineBreaks();
            TrueZipFacade.clear(file);
            return lines;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static List<String> getFileLinesWithoutLineBreaks(TFile file) throws IOException {
        assert (file != null) : "Parameter 'file' of method 'getFileLinesWithoutLineBreaks' must not be null";
        Throwable throwable = null;
        Object var2_3 = null;
        try (SmartReader reader = new SmartReader((InputStream)new TFileInputStream((File)file));){
            List<String> lines = reader.readLines();
            TrueZipFacade.clear(file);
            return lines;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFileContent(InputStream inputStream) throws IOException {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'getFileContent' must not be null";
        Throwable throwable = null;
        Object var2_3 = null;
        try (SmartReader reader = new SmartReader(inputStream);){
            return reader.readContent();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFileContent(TFile file) throws IOException {
        assert (file != null) : "Parameter 'file' of method 'getFileContent' must not be null";
        try {
            String string;
            block14: {
                Throwable throwable = null;
                Object var2_3 = null;
                TFileInputStream inputStream = new TFileInputStream((File)file);
                try {
                    String content;
                    string = content = FileUtility.getFileContent((InputStream)inputStream);
                    if (inputStream == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                inputStream.close();
            }
            return string;
        }
        finally {
            TrueZipFacade.clear(file);
        }
    }

    public static String getContentFromResourceOnClassPath(Class<?> clazz, String resource) throws IOException {
        assert (clazz != null) : "Parameter 'clazz' of method 'getContentFromClassPath' must not be null";
        assert (resource != null && resource.length() > 0) : "Parameter 'resource' of method 'getContentFromClassPath' must not be empty";
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = clazz.getResourceAsStream(resource);){
            if (inputStream != null) {
                return FileUtility.getFileContent(inputStream);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new IOException("Resource not found: " + resource);
    }

    public static void writeFile(String path, Charset encoding, String content, boolean append) throws IOException {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'writeFile' must not be empty";
        assert (encoding != null) : "Parameter 'encoding' of method 'writeFile' must not be null";
        assert (content != null) : "Parameter 'content' of method 'writeFile' must not be null";
        Path targetPath = Paths.get(path, new String[0]);
        Path parentOfTargetPath = targetPath.getParent();
        if (parentOfTargetPath != null) {
            Files.createDirectories(parentOfTargetPath, new FileAttribute[0]);
        }
        Throwable throwable = null;
        Object var7_9 = null;
        try (BufferedWriter writer = Files.newBufferedWriter(targetPath, encoding, new OpenOption[0]);){
            if (append) {
                writer.append(content, 0, content.length());
            } else {
                writer.write(content, 0, content.length());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Properties loadProperties(URL url, String resourceName, List<String> resourcePaths) {
        assert (url != null) : "Parameter 'url' of method 'loadProperties' must not be null";
        assert (resourceName != null) : "Parameter 'resourceName' of method 'loadProperties' must not be null";
        assert (resourcePaths != null) : "Parameter 'resourcePaths' of method 'loadProperties' must not be null";
        Properties loadedProperties = new Properties();
        URLConnection urlConnection = null;
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException ex) {
            LOGGER.error("unable to process '" + String.valueOf(resourcePaths) + "' - ", (Throwable)ex);
        }
        if (urlConnection == null) {
            return loadedProperties;
        }
        try {
            Throwable ex = null;
            Object var6_9 = null;
            try (InputStream in = urlConnection.getInputStream();){
                loadedProperties.load(in);
            }
            catch (Throwable throwable) {
                if (ex == null) {
                    ex = throwable;
                } else if (ex != throwable) {
                    ex.addSuppressed(throwable);
                }
                throw ex;
            }
        }
        catch (IOException e) {
            LOGGER.error("unable to process '" + String.valueOf(resourcePaths) + "' - " + e.getMessage());
        }
        return loadedProperties;
    }

    public static String getFileNameWithoutExtension(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getFileNameWithoutType' must not be null";
        String fileName = file.getName();
        return FileUtility.removeExtension(fileName);
    }

    public static String getExtension(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getExtension' must not be null";
        if (file.getName().isEmpty()) {
            return "";
        }
        return FileUtility.getExtension(file.getName());
    }

    public static String getExtension(String fileName) {
        return !FileUtility.hasExtension(fileName) ? "" : fileName.substring(fileName.lastIndexOf(46));
    }

    public static TFile getAbsolutePath(TFile basePath, String relativePath) {
        assert (basePath != null) : "'basePath' must not be null";
        assert (basePath.isDirectory()) : "'basePath' must be a directory";
        assert (relativePath != null) : "'relativePath' must not be null";
        assert (relativePath.length() > 0) : "'relativePath' must not be empty";
        TFile absolutePath = new TFile(relativePath);
        if (!absolutePath.isAbsolute()) {
            String fullPath = basePath.getAbsolutePath() + PATH_SEPARATOR + relativePath;
            TFile calculatedPath = new TFile(fullPath);
            return calculatedPath;
        }
        return absolutePath;
    }

    public static boolean isAbsolutePath(String path) {
        assert (path != null) : "Parameter 'path' of method 'isAbsolutePath' must not be null";
        return new TFile(path).isAbsolute();
    }

    public static boolean isRelativePath(String path) {
        assert (path != null) : "Parameter 'path' of method 'isRelativePath' must not be null";
        return path.startsWith(RELATIVE_PATH_CURRENT) || path.startsWith(RELATIVE_PATH_UP);
    }

    public static String getIdentifyingPath(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getIdentifyingPath' must not be null";
        return FileUtility.convertPathToUniversalForm(file.getNormalizedAbsolutePath());
    }

    public static boolean areEqual(TFile path1, TFile path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 != null && path2 != null) {
            return FileUtility.getIdentifyingPath(path1).equals(FileUtility.getIdentifyingPath(path2));
        }
        return false;
    }

    public static boolean areEqual(String path1, String path2) {
        if (path1 == null && path2 == null) {
            return true;
        }
        if (path1 != null && path2 != null) {
            return FileUtility.areEqual(new TFile(path1), new TFile(path2));
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static boolean filesHaveSameContent(TFile file1, TFile file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TFile[] listFilesInDir(TFile dir, String regex) {
        return FileUtility.listFilesInDir(dir, regex, null);
    }

    public static TFile[] listFilesInDir(TFile dir, String regex, TArchiveDetector archiveDetector) {
        assert (dir != null) : "Parameter 'dir' of method 'listFilesInDir' must not be null";
        if (!dir.exists() || !dir.isDirectory()) {
            LOGGER.error("Directory '" + dir.getNormalizedAbsolutePath() + "' does not exist.");
            return new TFile[0];
        }
        if (!dir.canRead()) {
            LOGGER.error("No permission to read from directory '" + dir.getNormalizedAbsolutePath() + "'");
            return new TFile[0];
        }
        final Pattern pattern = Pattern.compile(regex);
        TFilenameFilter filter = new TFilenameFilter(){

            @Override
            protected boolean accept(TFile dir, String name) {
                boolean matches = pattern.matcher(name).matches();
                return matches;
            }
        };
        TFile[] files = archiveDetector != null ? dir.listFiles((FilenameFilter)filter) : dir.listFiles((FilenameFilter)filter, archiveDetector);
        if (files == null) {
            return new TFile[0];
        }
        return files;
    }

    public static List<TFile> getSubDirectories(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'listFilesInDir' must not be null";
        if (!dir.exists() || !dir.isDirectory()) {
            LOGGER.error("Directory '" + dir.getNormalizedAbsolutePath() + "' does not exist.");
            return Collections.emptyList();
        }
        if (!dir.canRead()) {
            assert (false) : "No permission to read from directory '" + dir.getNormalizedAbsolutePath() + "'";
            LOGGER.error("No permission to read from directory '" + dir.getNormalizedAbsolutePath() + "'");
            return Collections.emptyList();
        }
        TFile[] files = dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<TFile> subdirectories = new ArrayList<TFile>();
        TFile[] tFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            TFile file = tFileArray[n2];
            if (file.isDirectory()) {
                subdirectories.add(file);
            }
            ++n2;
        }
        return subdirectories;
    }

    public static List<TFile> getBaseDirectoriesOf(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'getBaseDirectoriesOf' must not be null";
        TFile parent = file.getParentFile();
        ArrayList<TFile> result = new ArrayList<TFile>();
        if (parent == null && !file.isAbsolute()) {
            result.add(new TFile(RELATIVE_PATH_CURRENT));
        } else {
            result.add(parent);
            while ((parent = parent.getParentFile()) != null) {
                result.add(parent);
            }
        }
        return result;
    }

    public static TFile findCommonBaseDirectory(List<TFile> files) {
        assert (files != null) : "Parameter 'files' of method 'findCommonBaseDirectory' must not be null";
        List<TFile> commonBaseDirectories = null;
        for (TFile file : files) {
            file = file.getNormalizedFile();
            if (commonBaseDirectories == null) {
                commonBaseDirectories = FileUtility.getBaseDirectoriesOf(file);
                continue;
            }
            commonBaseDirectories.retainAll(FileUtility.getBaseDirectoriesOf(file));
        }
        if (commonBaseDirectories == null || commonBaseDirectories.size() == 0) {
            return null;
        }
        return (TFile)commonBaseDirectories.get(0);
    }

    public static List<DirectoryMapping> findRootDirectories(Collection<TFile> files) {
        assert (files != null) : "Parameter 'files' of method 'findRootDirectories' must not be null";
        ArrayList<List<Object>> groups = new ArrayList<List<Object>>();
        ArrayList<TFile> onlySingleBaseDirectory = new ArrayList<TFile>();
        HashMap<TFile, Integer> groupMap = new HashMap<TFile, Integer>();
        for (TFile file : files) {
            List<TFile> baseDirs = FileUtility.getBaseDirectoriesOf(file);
            if (baseDirs.size() == 1) {
                onlySingleBaseDirectory.add(file);
                continue;
            }
            if (groups.size() == 0) {
                groupMap.put(file, 0);
                groups.add(baseDirs);
                continue;
            }
            List group = null;
            int i = 0;
            while (i < groups.size()) {
                ArrayList<TFile> remainingBaseDirs = new ArrayList<TFile>();
                group = (List)groups.get(i);
                remainingBaseDirs.addAll(baseDirs);
                remainingBaseDirs.retainAll(group);
                if (remainingBaseDirs.size() > 1) {
                    groups.set(i, remainingBaseDirs);
                    groupMap.put(file, i);
                    break;
                }
                group = null;
                ++i;
            }
            if (group != null) continue;
            groupMap.put(file, groups.size());
            groups.add(baseDirs);
        }
        ArrayList<DirectoryMapping> result = new ArrayList<DirectoryMapping>();
        for (List list : groups) {
            result.add(new DirectoryMapping((TFile)list.get(0)));
        }
        for (TFile tFile : files) {
            Integer groupIndex = (Integer)groupMap.get(tFile);
            DirectoryMapping mapping = (DirectoryMapping)result.get(groupIndex);
            mapping.addFile(tFile);
        }
        return result;
    }

    public static boolean isArchive(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'isArchive' must not be null";
        if (!file.isArchive()) {
            return false;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream((File)file)));){
                int test = in.readInt();
                boolean bl = test == 1347093252;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isArchiveOrContainedInArchive(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'isArchiveOrContainedInArchive' must not be null";
        TFile current = file;
        while (current != null) {
            if (current.isArchive()) {
                return true;
            }
            current = current.getParentFile();
        }
        return false;
    }

    public static OperationResult removeRecursively(TFile directory, OperationResult result) {
        assert (directory != null) : "Parameter 'directory' of method 'removeRecursively' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeRecursively' must not be null";
        if (directory.exists()) {
            try {
                directory.rm_r();
            }
            catch (IOException ex) {
                result.addError(IOMessageCause.FAILED_TO_DELETE_DIRECTORY, ex);
            }
        }
        return result;
    }

    public static TFile removeRecursivelyJava7(TFile directory) throws IOException {
        assert (directory != null) : "Parameter 'directory' of method 'removeRecursivelyJava7' must not be null";
        assert (directory.isDirectory()) : "Parameter 'directory' of method 'removeRecursivelyJava7' must be a directory";
        DeletingFileVisitor delFileVisitor = new DeletingFileVisitor();
        Files.walkFileTree(Paths.get(directory.getPath(), new String[0]), delFileVisitor);
        return directory;
    }

    public static void removeRecursivelyDontFollowSymlinks(TFile file) throws IOException {
        if (!file.exists()) {
            return;
        }
        Path path = Paths.get(file.getPath(), new String[0]);
        if (!Files.isSymbolicLink(path) && file.isDirectory()) {
            TFile[] tFileArray = file.listFiles();
            int n = tFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                TFile children = tFileArray[n2];
                FileUtility.removeRecursivelyDontFollowSymlinks(children);
                ++n2;
            }
        }
        file.rm();
    }

    public static TFile getOrCreateDirectory(TFile directory, OperationResult result) {
        boolean success;
        assert (directory != null) : "Parameter 'directory' of method 'getDirectory' must not be null";
        assert (result != null) : "Parameter 'result' of method 'assureDirectory' must not be null";
        TFile normalizedDir = directory.getNormalizedAbsoluteFile();
        if (!normalizedDir.exists() && !(success = normalizedDir.mkdirs())) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, normalizedDir.getAbsolutePath(), new Object[0]);
            return null;
        }
        if (!normalizedDir.isDirectory()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_DIRECTORY, normalizedDir.getAbsolutePath(), new Object[0]);
            return null;
        }
        return normalizedDir;
    }

    public static TFile getOrCreateFile(TFile file, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'createFile' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createFile' must not be null";
        try {
            file.createNewFile();
        }
        catch (IOException ex) {
            result.addError(IOMessageCause.FAILED_TO_CREATE_FILE, ex);
            return null;
        }
        return file;
    }

    public static boolean hasExtension(IFileType fileType, String extension) {
        assert (fileType != null) : "Parameter 'fileType' of method 'hasExtension' must not be null";
        assert (extension != null) : "Parameter 'extension' of method 'hasExtension' must not be null";
        String[] stringArray = fileType.getExtensions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (extension.equals(ext)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean hasExtension(String outputPath) {
        int lastIndexOfWindowsPathSeparator;
        assert (outputPath != null && outputPath.length() > 0) : "Parameter 'outputPath' of method 'hasExtension' must not be empty";
        int lastIndexOfDot = outputPath.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return false;
        }
        int lastIndexOfUnixPathSeparator = outputPath.lastIndexOf(47);
        int lastIndexOfPathSeparator = Math.max(lastIndexOfUnixPathSeparator, lastIndexOfWindowsPathSeparator = outputPath.lastIndexOf(92));
        if (lastIndexOfPathSeparator > lastIndexOfDot) {
            return false;
        }
        return lastIndexOfDot < outputPath.length() - 1;
    }

    public static void createPropertiesFile(TFile inDirectory, String fileName, List<Pair<String, String>> properties, OperationResult result) {
        assert (inDirectory != null) : "Parameter 'inDirectory' of method 'createNameTagFile' must not be null";
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'createPropertiesFile' must not be empty";
        assert (properties != null && properties.size() > 0) : "Parameter 'properties' of method 'createNameTagFile' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'createPropertiesFile' must not be null";
        try {
            StringBuilder builder = new StringBuilder();
            for (Pair<String, String> nextProperty : properties) {
                builder.append(nextProperty.getFirst());
                builder.append("=");
                builder.append(nextProperty.getSecond());
                builder.append(StringUtility.LINE_SEPARATOR);
            }
            FileUtility.writeFile(inDirectory.getNormalizedAbsolutePath() + PATH_SEPARATOR + fileName, StandardCharsets.UTF_8, builder.toString(), false);
        }
        catch (IOException ex) {
            result.addError(IOMessageCause.FAILED_TO_CREATE_FILE, ex);
        }
    }

    public static void deleteRecursively(String path) throws IOException {
        FileUtility.deleteRecursively(path, false);
    }

    public static void deleteRecursively(String path, final boolean excludeSelf) throws IOException {
        assert (path != null && path.length() > 0) : "Parameter 'path' of method 'delete' must not be empty";
        final Path fileOrDirectory = Paths.get(path, new String[0]);
        Files.walkFileTree(fileOrDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!excludeSelf || !dir.equals(fileOrDirectory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static List<TFile> getAllFilesRecursively(TFile dir) throws IOException {
        assert (dir != null) : "Parameter 'dir' of method 'getAllFilesRecursively' must not be null";
        Path directory = Paths.get(dir.getNormalizedAbsolutePath(), new String[0]);
        final ArrayList<TFile> files = new ArrayList<TFile>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(new TFile(file.toFile()));
                return FileVisitResult.CONTINUE;
            }
        });
        return files;
    }

    public static boolean isWriteableDirectory(TFile directory) {
        if (directory == null) {
            return false;
        }
        if (directory.isArchive()) {
            return false;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        return directory.canWrite();
    }

    public static boolean mkParentDirs(String filePath) {
        TFile parent;
        TFile file = new TFile(filePath);
        if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            return parent.mkdirs();
        }
        return false;
    }

    public static void extractArchiveToDir(TFile archive, TFile targetDir) throws IOException {
        assert (archive != null) : "Parameter 'archive' of method 'extractArchiveToDir' must not be null";
        assert (targetDir != null) : "Parameter 'targetDir' of method 'extractArchiveToDir' must not be null";
        assert (targetDir.isDirectory()) : "Parameter 'targetDir' must be a directory";
        TFile.cp_rp((File)archive, (File)targetDir, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)TArchiveDetector.NULL);
    }

    public static boolean isValidName(String name) {
        if (name.equals(RELATIVE_PATH_CURRENT) || name.equals(RELATIVE_PATH_UP)) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        char lastChar = name.charAt(length - 1);
        if (lastChar == '.') {
            return false;
        }
        if (Character.isWhitespace(lastChar)) {
            return false;
        }
        String basename = FileUtility.removeExtension(name);
        if (Arrays.binarySearch(INVALID_RESOURCE_BASENAMES, basename.toLowerCase()) >= 0) {
            return false;
        }
        String[] stringArray = INVALID_RESOURCE_CHARACTERS;
        int n = INVALID_RESOURCE_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            String invalid = stringArray[n2];
            if (basename.contains(invalid)) {
                return false;
            }
            ++n2;
        }
        return Arrays.binarySearch(INVALID_RESOURCE_FULLNAMES, name.toLowerCase()) < 0;
    }

    public static String removeInvalidCharactersFromFileName(String fileName) {
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'removeInvalidCharactersFromFileName' must not be empty";
        String result = fileName.replaceAll("[/\\\\:*?\"<>|]", "");
        return result;
    }

    public static boolean isDirSameOrParentOf(TFile potentialParentDir, TFile potentialChild) {
        String parentPath;
        assert (potentialParentDir != null) : "Parameter 'potentialParentDir' of method 'isDirParentOf' must not be null";
        assert (potentialChild != null) : "Parameter 'potentialChild' of method 'isDirParentOf' must not be null";
        String childPath = FileUtility.getCanonicalFilePath(potentialChild);
        return childPath.equals(parentPath = FileUtility.getCanonicalFilePath(potentialParentDir)) || childPath.startsWith(parentPath + SYSTEM_PATH_SEPARATOR);
    }
}

