/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.commandline;

import com.hello2morrow.sonargraph.foundation.commandline.ICallback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Option {
    static final String HYPHEN = "-";
    private static boolean s_wasSyntaxCorrect;
    private static Set<String> s_optionIdentifier;
    private static List<OptionIdentifierCheck> s_optionIdentifierChecks;
    private static Option s_head;
    private static Option s_tail;
    private static Map<String, String> s_optionToArgument;
    private static Set<String> s_processedOptions;
    private final String m_optionIdentifier;
    private final String m_description;
    private final boolean m_mandatory;
    private boolean m_processed;
    private boolean m_suplicateOption;
    private Option m_successor;
    private final String m_argumentDescription;

    static {
        s_optionIdentifier = new HashSet<String>();
        s_optionIdentifierChecks = new ArrayList<OptionIdentifierCheck>();
        s_optionToArgument = new HashMap<String, String>();
        s_processedOptions = new HashSet<String>();
    }

    Option(String optionIdentifier, String argumentDescription, String description, boolean mandatory) {
        assert (optionIdentifier != null) : "optionIdentifier != null (46)";
        assert (optionIdentifier.length() > 0) : "optionIdentifier.length() > 0 (47)";
        assert (optionIdentifier.startsWith(HYPHEN)) : "optionIdentifier.startsWith(HYPHEN) (48)";
        assert (!s_optionIdentifier.contains(optionIdentifier)) : "!s_OptionIdentifier.contains(optionIdentifier) (49)";
        this.m_optionIdentifier = optionIdentifier;
        s_optionIdentifier.add(this.m_optionIdentifier);
        this.m_description = description;
        this.m_mandatory = mandatory;
        this.linkOption(this);
        assert (this.isOptionValid()) : "isOptionValid() (57)";
        assert (s_head != null) : "s_Head != null (58)";
        assert (s_tail != null) : "s_Tail != null (59)";
        this.m_argumentDescription = argumentDescription;
    }

    Option(String optionIdentifier, String description, boolean mandatory) {
        this(optionIdentifier, null, description, mandatory);
    }

    private boolean isOptionValid() {
        boolean result = true;
        int i = 0;
        while (i < s_optionIdentifierChecks.size()) {
            OptionIdentifierCheck check = s_optionIdentifierChecks.get(i);
            check.setCurrentOption(this);
            result = result && check.checkOptionIdentifier(this);
            check.setCurrentOption(null);
            ++i;
        }
        return result;
    }

    boolean isMandatory() {
        return this.m_mandatory;
    }

    static void init() {
        s_optionIdentifier.clear();
        s_optionIdentifierChecks.clear();
        s_head = null;
        s_tail = null;
        s_optionToArgument.clear();
        s_processedOptions.clear();
    }

    final String getDescription() {
        return this.m_description;
    }

    final String getArgumentDescription() {
        return this.m_argumentDescription;
    }

    protected final String getOptionIdentifier() {
        return this.m_optionIdentifier;
    }

    protected final void setProcessed() {
        this.m_processed = true;
        boolean success = s_processedOptions.add(this.m_optionIdentifier);
        assert (success) : "success (105)";
    }

    protected final boolean alreadyProcessed() {
        return this.m_processed;
    }

    protected final void setDuplicateOption() {
        this.m_suplicateOption = true;
    }

    protected String getArgument() {
        return null;
    }

    protected static void addCheck(OptionIdentifierCheck check) {
        assert (check != null) : "check != null (125)";
        assert (!s_optionIdentifierChecks.contains(check)) : "!s_OptionIdentifierChecks.contains(check) (126)";
        s_optionIdentifierChecks.add(check);
    }

    private void linkOption(Option option) {
        assert (option != null) : "option != null (132)";
        if (s_head == null) {
            s_head = option;
            s_tail = option;
        } else {
            Option.s_tail.m_successor = option;
            s_tail = option;
        }
    }

    static int processNextArgument(String[] args, int index) {
        assert (s_head != null) : "s_Head != null (148)";
        int result = -1;
        Option currentOption = s_head;
        while (result == -1 && currentOption != null) {
            result = currentOption.process(args, index);
            currentOption = currentOption.m_successor;
        }
        return result;
    }

    protected int process(String[] args, int index) {
        assert (args != null) : "args != null (164)";
        assert (args.length > 0) : "args.length > 0 (165)";
        assert (index >= 0) : "index >= 0 (166)";
        assert (index < args.length) : "index < args.length (167)";
        int resultingIndex = -1;
        if (args[index].equals(this.getOptionIdentifier())) {
            if (this.alreadyProcessed()) {
                this.setDuplicateOption();
            } else {
                this.setProcessed();
            }
            resultingIndex = index;
        }
        return resultingIndex;
    }

    static boolean areStatesValid(ICallback cb) {
        if (s_head != null) {
            boolean wasSyntaxCorrect = true;
            Option currentOption = s_head;
            while (currentOption != null) {
                if (!currentOption.isStateValid(cb)) {
                    wasSyntaxCorrect = false;
                }
                currentOption = currentOption.m_successor;
            }
            s_wasSyntaxCorrect = wasSyntaxCorrect;
            if (s_wasSyntaxCorrect) {
                Option.collectOptionData();
            }
            return s_wasSyntaxCorrect;
        }
        return true;
    }

    private static void collectOptionData() {
        assert (s_head != null) : "s_Head != null (220)";
        Option currentOption = s_head;
        while (currentOption != null) {
            String optionIdentifier = currentOption.getOptionIdentifier();
            String argument = currentOption.getArgument();
            assert (!s_optionToArgument.containsKey(optionIdentifier)) : "!s_OptionToArgument.containsKey(optionIdentifier) (229)";
            assert (optionIdentifier != null) : "optionIdentifier != null (230)";
            assert (optionIdentifier.length() > 0) : "optionIdentifier.length() > 0 (231)";
            assert (argument == null || argument.length() > 0);
            if (argument != null) {
                s_optionToArgument.put(optionIdentifier, argument);
            }
            currentOption = currentOption.m_successor;
        }
    }

    protected boolean isStateValid(ICallback cb) {
        boolean result = true;
        if (this.m_mandatory && !this.m_processed) {
            cb.mandatoryOptionMissing(this.m_optionIdentifier);
            result = false;
        }
        if (this.m_suplicateOption) {
            cb.duplicateOption(this.m_optionIdentifier);
            result = false;
        }
        return result;
    }

    static boolean wasOptionProvided(String option) {
        boolean provided = s_processedOptions.contains(option);
        return provided;
    }

    static boolean hasOptionAnArgument(String option) {
        return s_optionToArgument.get(option) != null;
    }

    static String getArgumentForOption(String option) {
        return s_optionToArgument.get(option);
    }

    static String[] getOptionDescriptions() {
        assert (s_head != null) : "s_Head != null (294)";
        Option currentOption = s_head;
        ArrayList<String> descriptions = new ArrayList<String>();
        while (currentOption != null) {
            descriptions.add(currentOption.toString());
            currentOption = currentOption.m_successor;
        }
        return descriptions.toArray(new String[0]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getOptionIdentifier());
        String argumentDescription = this.getArgumentDescription();
        if (argumentDescription != null) {
            buffer.append(" <" + argumentDescription + ">");
        }
        buffer.append(": ");
        buffer.append(this.getDescription());
        buffer.append(this.m_mandatory ? ", mandatory" : "");
        return buffer.toString();
    }

    static abstract class OptionIdentifierCheck {
        private Option m_CurrentOption;

        OptionIdentifierCheck() {
        }

        void setCurrentOption(Option option) {
            this.m_CurrentOption = option;
        }

        Option getCurrentOption() {
            return this.m_CurrentOption;
        }

        abstract boolean checkOptionIdentifier(Option var1);
    }
}

