/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.systemdiff;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import com.hello2morrow.sonargraph.ui.swt.dialog.StandardDialog;
import com.hello2morrow.sonargraph.ui.swt.dialog.UiSwtDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class CreateBaselineReportDialog
extends StandardDialog {
    private TFile m_baselineDirectory;
    private String m_description;
    private String m_fileName;

    public CreateBaselineReportDialog(Shell shell, String fileName, TFile baselineDirectory) {
        super(shell, "Create and Apply New Baseline Report");
        assert (fileName != null && fileName.length() > 0) : "Parameter 'fileName' of method 'CreateBaselineReportDialog' must not be empty";
        assert (baselineDirectory != null) : "Parameter 'baselineDirectory' of method 'CreateBaselineReportDialog' must not be null";
        this.m_fileName = fileName;
        this.m_baselineDirectory = baselineDirectory;
    }

    @Override
    protected IDialogId getDialogId() {
        return UiSwtDialogId.CREATE_BASELINE_REPORT_DIALOG;
    }

    @Override
    protected void fillDialogArea(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        Label fileNameLabel = new Label(composite, 0);
        fileNameLabel.setText("Name: ");
        fileNameLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        ValidatingTextWidget fileName = new ValidatingTextWidget(composite, new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                TFile baseline;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null || newInput.trim().length() == 0) {
                    result.addError("Must not be empty");
                    return result;
                }
                String fileName = newInput.trim();
                String extension = CoreFileType.BASELINE.getDefaultExtension();
                if (fileName.toLowerCase().endsWith(extension)) {
                    result.addWarning("Extension " + extension + " will be added automatically");
                }
                if ((baseline = new TFile((File)CreateBaselineReportDialog.this.m_baselineDirectory, fileName + extension)).exists()) {
                    result.addWarning("Baseline with the same name already exists and will be overwritten");
                    return result;
                }
                return result;
            }
        }, new ValidatingTextOrComboWidget.IConsumer(){

            @Override
            public void setText(ValidatingTextOrComboWidget source, String input, boolean inputModified) {
                if (inputModified) {
                    CreateBaselineReportDialog.this.m_fileName = input;
                }
            }
        }, this.m_fileName, 4);
        fileName.setLayoutData(new GridData(4, 4, true, false));
        Label directoryLabel = new Label(composite, 0);
        directoryLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        directoryLabel.setText("Directory:");
        ValidatingPathWidget directory = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            @Override
            public void setPath(TFile input, boolean inputModified) {
                if (inputModified) {
                    CreateBaselineReportDialog.this.m_baselineDirectory = input;
                    CreateBaselineReportDialog.this.inputChanged();
                }
            }
        }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ_WRITE), 1, this.m_baselineDirectory, false);
        directory.setLayoutData(new GridData(4, 4, true, false));
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText("Description:");
        descriptionLabel.setLayoutData((Object)new GridData(4, Platform.isWindows() ? 128 : 0x1000000, false, false));
        final Text description = new Text(composite, 2818);
        description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBaselineReportDialog.this.m_description = description.getText();
            }
        });
        description.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @Override
    protected int getNumberOfColumns() {
        return 2;
    }

    @Override
    protected void applyData() {
        this.inputChanged();
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public TFile getBaselineReportDirectory() {
        return this.m_baselineDirectory;
    }

    @Override
    public boolean hasValidData() {
        return this.m_fileName != null && this.m_baselineDirectory != null;
    }

    private void inputChanged() {
        this.getButton(0).setEnabled(this.hasValidData());
    }

    public String getReportDescription() {
        return this.m_description;
    }

    @Override
    protected Point getPreferredSize() {
        return new Point(500, 350);
    }
}

