/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graphview;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.graphview.GraphViewNode;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawCache;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvasLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewCircularLayouter;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.graphview.GraphViewSpringEmbedderLayouter;
import com.hello2morrow.sonargraph.ui.swt.graphview.IGraphViewCycleLayouter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphViewLayout
extends DrawNodeAndConnectionFigureCanvasLayout<GraphViewNode, GraphViewNode.GraphViewDependency> {
    public static final int START_OFFSET_X = 10;
    public static final int START_OFFSET_Y = 10;
    public static final int OFFSET_X = 20;
    public static final int OFFSET_Y = 40;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphViewLayout.class);
    private final GraphViewSpringEmbedderLayouter m_springEmbedderLayouter = new GraphViewSpringEmbedderLayouter();
    private final GraphViewCircularLayouter m_circularLayouter = new GraphViewCircularLayouter();
    private CycleLayout m_layout;
    private boolean m_autoResize;

    public GraphViewLayout(CycleLayout cycleLayout) {
        super(0.01, 0.05);
        assert (cycleLayout != null) : "Parameter 'cycleLayout' of method 'GraphViewLayout' must not be null";
        this.m_layout = cycleLayout;
    }

    public void setAutoResize(boolean autoResize) {
        this.m_autoResize = autoResize;
    }

    public boolean autoResize() {
        return this.m_autoResize;
    }

    public boolean setLayout(CycleLayout layout) {
        assert (layout != null) : "Parameter 'layout' of method 'setLayout' must not be null";
        if (!this.m_layout.equals((Object)layout)) {
            this.m_layout = layout;
            return true;
        }
        return false;
    }

    public CycleLayout getLayout() {
        return this.m_layout;
    }

    private IGraphViewCycleLayouter getCycleLayouter() {
        switch (this.m_layout) {
            case CIRCULAR: {
                return this.m_circularLayouter;
            }
            case SPRING_EMBEDDER: {
                return this.m_springEmbedderLayouter;
            }
        }
        assert (false) : "Unhandled layout: " + String.valueOf((Object)this.m_layout);
        return null;
    }

    @Override
    protected void calculateSizeAndScale(List<DrawNodeFigure<GraphViewNode>> nodes, List<DrawConnectionFigure<GraphViewNode.GraphViewDependency>> connections, DrawNodeAndConnectionFigureCanvasLayout.SizeAndScale sizeAndScale, DrawCache cache) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'calculateSizeAndScale' must not be empty";
        assert (connections != null) : "Parameter 'connections' of method 'calculateSizeAndScale' must not be null";
        assert (sizeAndScale != null) : "Parameter 'sizeAndScale' of method 'calculateSizeAndScale' must not be null";
        assert (cache != null) : "Parameter 'cache' of method 'calculateSizeAndScale' must not be null";
        assert (cache.isEmpty()) : "Cache not empty";
        Dimension availableSize = sizeAndScale.getAvailableSize();
        LOGGER.debug("Calculate size and scale for '" + String.valueOf((Object)this.m_layout) + "' layout [available: " + String.valueOf(availableSize) + "]");
        IGraphViewCycleLayouter layouter = this.getCycleLayouter();
        int requiredWidth = 0;
        int requiredHeight = 10;
        int currentLevel = nodes.get(0).getNode().getLevel();
        int maxHeightOfCurrentLevel = 0;
        int requiredWidthOfCurrentLevel = 10;
        for (DrawNodeFigure<GraphViewNode> nextDrawNodeFigure : nodes) {
            Dimension nextPreferredSize;
            assert (nextDrawNodeFigure != null && nextDrawNodeFigure instanceof GraphViewNodeFigure) : "Unexpected class in method 'calculateSizeAndScale': " + String.valueOf(nextDrawNodeFigure);
            GraphViewNodeFigure nextNodeFigure = (GraphViewNodeFigure)nextDrawNodeFigure;
            if (((GraphViewNode)nextNodeFigure.getNode()).isCyclic()) continue;
            List<GraphViewNodeFigure> nextChildNodeFigures = nextNodeFigure.getChildNodeFigures();
            if (nextChildNodeFigures.isEmpty()) {
                nextPreferredSize = new Dimension(nextNodeFigure.getPreferredSize());
            } else {
                nextPreferredSize = layouter.getPreferredSize(nextChildNodeFigures, cache).expand(0, 18);
                nextPreferredSize.width = Math.max(nextPreferredSize.width, nextNodeFigure.getPreferredSize().width);
            }
            int nextLevel = ((GraphViewNode)nextNodeFigure.getNode()).getLevel();
            LOGGER.debug(((GraphViewNode)nextNodeFigure.getNode()).getName() + ": " + nextLevel);
            if (currentLevel == nextLevel) {
                requiredWidthOfCurrentLevel += nextPreferredSize.width + 20;
                maxHeightOfCurrentLevel = Math.max(maxHeightOfCurrentLevel, nextPreferredSize.height);
                continue;
            }
            requiredWidth = Math.max(requiredWidth, requiredWidthOfCurrentLevel);
            requiredHeight += maxHeightOfCurrentLevel + 40;
            requiredWidthOfCurrentLevel = 10 + nextPreferredSize.width;
            maxHeightOfCurrentLevel = nextPreferredSize.height;
            currentLevel = nextLevel;
        }
        requiredWidth = Math.max(requiredWidth, requiredWidthOfCurrentLevel);
        Dimension size = new Dimension(requiredWidth, requiredHeight += maxHeightOfCurrentLevel + 40);
        sizeAndScale.setSize(size);
        if (this.m_autoResize) {
            float scaleX = 1.0f;
            float scaleY = 1.0f;
            boolean scale = false;
            if (requiredWidth > availableSize.width) {
                scaleX = (float)availableSize.width / (float)requiredWidth;
                scale = true;
            }
            if (requiredHeight > availableSize.height) {
                scaleY = (float)availableSize.height / (float)requiredHeight;
                scale = true;
            }
            if (scale) {
                sizeAndScale.setScale(Math.max((double)Math.min(scaleX, scaleY), this.getMinScale()));
            } else {
                sizeAndScale.setScale(1.0);
            }
        }
        LOGGER.debug("Calculate size and scale for '" + String.valueOf((Object)this.m_layout) + "' layout - done [size: " + String.valueOf(size) + "]");
    }

    @Override
    protected void layout(List<DrawNodeFigure<GraphViewNode>> nodes, List<DrawConnectionFigure<GraphViewNode.GraphViewDependency>> connections, DrawCache cache) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'layout' must not be empty";
        assert (connections != null) : "Parameter 'connections' of method 'layout' must not be null";
        LOGGER.debug("Apply '" + String.valueOf((Object)this.m_layout) + "' layout");
        IGraphViewCycleLayouter layouter = this.getCycleLayouter();
        int currentOffsetX = 10;
        int currentOffsetY = 10;
        int currentLevel = nodes.get(0).getNode().getLevel();
        int maxHeightOfCurrentLevel = 0;
        for (DrawNodeFigure<GraphViewNode> nextDrawNodeFigure : nodes) {
            Rectangle nextBoundingBox;
            Dimension nextPreferredSize;
            assert (nextDrawNodeFigure != null && nextDrawNodeFigure instanceof GraphViewNodeFigure) : "Unexpected class in method 'layout': " + String.valueOf(nextDrawNodeFigure);
            GraphViewNodeFigure nextNodeFigure = (GraphViewNodeFigure)nextDrawNodeFigure;
            if (((GraphViewNode)nextNodeFigure.getNode()).isCyclic()) continue;
            List<GraphViewNodeFigure> nextChildNodeFigures = nextNodeFigure.getChildNodeFigures();
            if (nextChildNodeFigures.isEmpty()) {
                nextPreferredSize = new Dimension(nextNodeFigure.getPreferredSize());
            } else {
                nextPreferredSize = layouter.getPreferredSize(nextChildNodeFigures, cache);
                nextPreferredSize.width = Math.max(nextPreferredSize.width, nextNodeFigure.getPreferredSize().width);
                nextPreferredSize.expand(0, 18);
            }
            int nextLevel = ((GraphViewNode)nextNodeFigure.getNode()).getLevel();
            if (currentLevel == nextLevel) {
                nextBoundingBox = Rectangle.SINGLETON;
                nextBoundingBox.x = currentOffsetX;
                nextBoundingBox.y = currentOffsetY;
                nextBoundingBox.width = nextPreferredSize.width;
                nextBoundingBox.height = nextPreferredSize.height;
                nextNodeFigure.setBounds(nextBoundingBox);
                if (!nextChildNodeFigures.isEmpty()) {
                    layouter.layout(currentOffsetX, currentOffsetY + 16, nextChildNodeFigures, cache);
                }
                currentOffsetX += nextPreferredSize.width + 20;
                maxHeightOfCurrentLevel = Math.max(maxHeightOfCurrentLevel, nextPreferredSize.height);
                continue;
            }
            currentOffsetX = 10;
            nextBoundingBox = Rectangle.SINGLETON;
            nextBoundingBox.x = currentOffsetX;
            nextBoundingBox.y = currentOffsetY += maxHeightOfCurrentLevel + 40;
            nextBoundingBox.width = nextPreferredSize.width;
            nextBoundingBox.height = nextPreferredSize.height;
            nextNodeFigure.setBounds(nextBoundingBox);
            if (!nextChildNodeFigures.isEmpty()) {
                layouter.layout(currentOffsetX, currentOffsetY + 16, nextChildNodeFigures, cache);
            }
            maxHeightOfCurrentLevel = nextPreferredSize.height;
            currentOffsetX += nextPreferredSize.width + 20;
            currentLevel = nextLevel;
        }
        LOGGER.debug("Apply '" + String.valueOf((Object)this.m_layout) + "' layout - done");
    }

    public static enum CycleLayout implements IStandardEnumeration
    {
        SPRING_EMBEDDER,
        CIRCULAR;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

