/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.NameMode;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableNode;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class GraphNodeFigure
extends DrawableNode {
    private Color m_backgroundColor;

    public GraphNodeFigure(IDrawableFigure.IDrawableFigureListener listener, RepresentationNode node, Image image, NameMode nameMode, Color bg) {
        super(listener, node, image, nameMode);
        this.m_backgroundColor = bg;
    }

    @Override
    protected Color getForgroundColorForNode() {
        return UiResourceManager.getInstance().getGraphNodeTextColor();
    }

    public void updateBackgroundColor(Color bg) {
        this.m_backgroundColor = bg;
        this.revalidate();
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        Rectangle boundingBox = this.getBounds();
        graphics.setLineWidth(1);
        int fillAreaReduction = this.isHighlighted() ? 2 : 1;
        Rectangle fillArea = new Rectangle(boundingBox);
        fillArea.x += fillAreaReduction;
        fillArea.y += fillAreaReduction;
        fillArea.width -= fillAreaReduction * 2;
        fillArea.height -= fillAreaReduction * 2;
        if (this.isHighlighted()) {
            graphics.setLineWidth(3);
            graphics.setLineStyle(2);
            graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHT_BROWN));
        } else {
            graphics.setLineWidth(1);
            graphics.setForegroundColor(UiResourceManager.getInstance().getDisabledColor());
            graphics.setLineStyle(1);
        }
        if (this.isSelected()) {
            graphics.setBackgroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.LIGHTER_PAPAYA_WHIP));
        } else if (this.m_backgroundColor != null) {
            graphics.setBackgroundColor(this.m_backgroundColor);
        } else {
            graphics.setBackgroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.VERY_LIGHT_BLUE));
        }
        graphics.fillRoundRectangle(fillArea, 7, 7);
        graphics.drawRoundRectangle(fillArea, 7, 7);
        super.paintFigure(graphics);
    }

    @Override
    public String createTooltip() {
        StringBuilder tooltip = new StringBuilder();
        NamedElement namedElementOfNode = this.getRepresentationElement().getElement();
        String info = namedElementOfNode.getInformation();
        if (info != null && !info.isEmpty()) {
            tooltip.append(info);
            tooltip.append(" ");
        }
        tooltip.append(namedElementOfNode.getPresentationName(false));
        Object levelAsObject = this.getData("Level");
        if (levelAsObject != null) {
            assert (levelAsObject != null && levelAsObject instanceof Integer) : "Unexpected class in method 'createTooltip': " + String.valueOf(levelAsObject);
            tooltip.append(" (level: ");
            tooltip.append((Integer)levelAsObject);
            tooltip.append(")");
        }
        return tooltip.toString();
    }
}

