/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.graph;

import com.hello2morrow.draw2d.AbstractConnectionAnchor;
import com.hello2morrow.draw2d.Geometry;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.PointList;
import com.hello2morrow.draw2d.PrecisionPoint;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationEdge;
import com.hello2morrow.sonargraph.core.model.representation.RepresentationNode;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.DrawableEdge;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw2d.IDrawableNode;
import org.eclipse.swt.graphics.Color;

public final class DrawableCurvedEdge<T extends IDrawableNode>
extends DrawableEdge<T> {
    private PointList m_pointList;
    private int m_depth;

    public DrawableCurvedEdge(IDrawableFigure.IDrawableFigureListener listener, RepresentationEdge<? extends RepresentationNode> edge, AbstractConnectionAnchor from, AbstractConnectionAnchor to, boolean architectureEnabled) {
        super(listener, edge, from, to, true, architectureEnabled);
    }

    private boolean isInverse() {
        return this.m_depth < 0;
    }

    public final void setDepth(int depth) {
        this.m_depth = depth;
    }

    protected final PointList updateArc(PointList pointList) {
        if (pointList.size() < 2) {
            return pointList;
        }
        Point start = pointList.getFirstPoint();
        Point end = pointList.getLastPoint();
        if (this.m_depth == 0) {
            return pointList;
        }
        PointList points = new PointList();
        double arcStart = 0.0;
        double arcEnd = 0.0;
        double arcLength = 0.0;
        double cartCenterX = 0.0;
        double cartCenterY = 0.0;
        double r = 0.0;
        double x1 = start.x;
        double y1 = -start.y;
        double x2 = end.x;
        double y2 = -end.y;
        double depth = this.m_depth;
        if (start.equals(end)) {
            arcStart = -1.5707963267948966;
            arcLength = Math.PI * 2;
            cartCenterX = x1;
            cartCenterY = y1 + depth / 2.0;
            r = depth / 2.0;
        } else {
            if (x1 >= x2) {
                depth = -depth;
            }
            double cartChordX = (x2 + x1) / 2.0;
            double cartChordY = (y2 + y1) / 2.0;
            double chordLength = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
            if (Math.abs(depth) >= chordLength / 2.0) {
                depth = chordLength / 3.0 * (depth / Math.abs(depth));
            }
            r = (chordLength / 2.0 * (chordLength / 2.0) + depth * depth) / (2.0 * depth);
            double chordNormal = 0.0;
            chordNormal = Math.abs(x1 - x2) <= 1.0E-6 ? Double.NaN : (Math.abs(y1 - y2) <= 1.0E-6 ? Double.POSITIVE_INFINITY : -1.0 * (y2 - y1) / (x2 - x1));
            if (Double.isNaN(chordNormal)) {
                cartCenterX = y1 > y2 ? cartChordX - r + depth : cartChordX + r - depth;
                cartCenterY = cartChordY;
                th1 = 1.5707963267948966;
            } else if (Double.isInfinite(chordNormal)) {
                cartCenterX = cartChordX;
                cartCenterY = cartChordY + r - depth;
                th1 = 0.0;
            } else {
                th1 = Math.atan(chordNormal);
                cartCenterX = (r - depth) * Math.sin(th1) + cartChordX;
                cartCenterY = (r - depth) * Math.cos(th1) + cartChordY;
            }
            double cartArcX1 = x1 - cartCenterX;
            double cartArcY1 = y1 - cartCenterY;
            double cartArcX2 = x2 - cartCenterX;
            double cartArcY2 = y2 - cartCenterY;
            arcStart = this.angleRadians(cartArcX1, cartArcY1);
            arcEnd = this.angleRadians(cartArcX2, cartArcY2);
            if (arcEnd < arcStart) {
                arcEnd = arcEnd + Math.PI + Math.PI;
            }
            arcLength = arcEnd - arcStart;
            double pad = Math.PI / Math.abs(r);
            arcLength = (arcEnd -= pad) - (arcStart += pad);
            if (this.isInverse()) {
                arcLength = Math.PI * 2 - arcLength;
            }
        }
        r = Math.abs(r);
        double x = 0.0;
        double y = 0.0;
        PrecisionPoint p = null;
        points.addPoint(start);
        double length = arcLength * r;
        int steps = (int)length / 16;
        if (steps < 10 && length > 10.0) {
            steps = 10;
        }
        if (arcLength < 0.7853981633974483 && steps > 6) {
            steps = 6;
        }
        if (steps < 4 && length > 4.0) {
            steps = 4;
        }
        double stepSize = arcLength / (double)steps;
        if (this.isInverse()) {
            step = arcStart - stepSize;
            int i = 1;
            while (i < steps) {
                x = r * Math.cos(step) + cartCenterX;
                y = r * Math.sin(step) + cartCenterY;
                p = new PrecisionPoint(x, -y);
                points.addPoint(p);
                ++i;
                step -= stepSize;
            }
        } else {
            step = stepSize + arcStart;
            int i = 1;
            while (i < steps) {
                x = r * Math.cos(step) + cartCenterX;
                y = r * Math.sin(step) + cartCenterY;
                p = new PrecisionPoint(x, -y);
                points.addPoint(p);
                ++i;
                step += stepSize;
            }
        }
        points.addPoint(end);
        return points;
    }

    private final double angleRadians(double x, double y) {
        double theta = Math.atan(y / x);
        switch (this.findQuadrant(x, y)) {
            case 1: {
                return theta;
            }
            case 2: 
            case 3: {
                return theta + Math.PI;
            }
            case 4: {
                return theta + Math.PI + Math.PI;
            }
        }
        assert (false) : "Should not be reached";
        return theta;
    }

    protected final int findQuadrant(double x, double y) {
        if (y > 0.0) {
            if (x > 0.0) {
                return 1;
            }
            return 2;
        }
        if (x > 0.0) {
            return 4;
        }
        return 3;
    }

    private Rectangle getBoundsForArc(Rectangle fromBounds, Rectangle toBounds) {
        assert (fromBounds != null) : "Parameter 'fromBounds' of method 'getBoundsForArc' must not be null";
        assert (toBounds != null) : "Parameter 'toBounds' of method 'getBoundsForArc' must not be null";
        float fromX = fromBounds.x + fromBounds.width / 2;
        float fromY = fromBounds.y + fromBounds.height / 2;
        float toX = toBounds.x + toBounds.width / 2;
        float toY = toBounds.y + toBounds.height / 2;
        int x = Math.round(Math.min(fromX, toX)) - 8;
        int y = Math.round(Math.min(fromY, toY)) - 8;
        int width = Math.round(Math.max(fromX, toX) - (float)x) + 8;
        int height = Math.round(Math.max(fromY, toY) - (float)y) + 8;
        if (this.m_depth > 0) {
            x -= this.m_depth + 5;
            y -= this.m_depth + 5;
            width += this.m_depth * 2 + 10;
            height += this.m_depth * 2 + 10;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public void setPoints(PointList list) {
        assert (list != null) : "Parameter 'list' of method 'setPoints' must not be null";
        assert (list.size() == 2) : "Two points expected in 'setPoints'";
        Point first = list.getFirstPoint().getCopy();
        Point last = list.getLastPoint().getCopy();
        Object from = this.getFrom();
        Object to = this.getTo();
        Rectangle boundingBox = this.getBoundsForArc(from.getBounds(), to.getBounds());
        this.getPointList().removeAllPoints();
        this.getPointList().addPoint(first);
        this.getPointList().addPoint(last);
        this.setBounds(boundingBox);
        this.firePropertyChange("points", null, this.getPointList());
        this.repaint();
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.m_pointList != null) {
            return Geometry.polylineContainsPoint(this.m_pointList, x, y, this.computeLineWidth() + 1);
        }
        return false;
    }

    private boolean participatesInCycleOfTwo() {
        if (this.m_depth > 0) {
            Object to = this.getTo();
            for (IDrawableNode.IDrawableEdge<? extends IDrawableNode> nextOut : to.getOutgoingEdges()) {
                if (nextOut.getTo() != this.getFrom()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        if (this.shouldHideOnPaintViolationsOnly()) {
            this.setVisible(false);
            return;
        }
        Rectangle boundingBox = this.getBounds();
        int lineWidth = this.computeLineWidth();
        Rectangle clip = new Rectangle(boundingBox);
        graphics.setClip(clip);
        graphics.setAntialias(1);
        Color color = this.isSelected() || this.isHighlighted() ? (this.paintViolationsOnly() ? UiResourceManager.getInstance().getViolatingConnectionColor() : (this.participatesInCycleOfTwo() && this.getViolationWeight() == 0 ? UiResourceManager.getInstance().getColor(UiResourceManager.BLUE) : this.getActiveLineColor())) : this.getInactiveLineColor();
        graphics.setLineWidth(lineWidth);
        graphics.setForegroundColor(color);
        this.getDecoration().setForegroundColor(color);
        this.m_pointList = this.updateArc(this.getPoints());
        if (this.m_pointList.size() == 2) {
            graphics.drawLine(this.m_pointList.getFirstPoint(), this.m_pointList.getLastPoint());
        } else {
            graphics.drawPolyline(this.m_pointList);
        }
        this.getDecoration().setReferencePoint(this.m_pointList.getMidpoint());
        super.paintFigure(graphics);
    }
}

