/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.dialog.feedback;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.system.SendFeedbackCommand;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.swt.dialog.feedback.FeedbackDialog;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardFeedbackInteraction
implements SendFeedbackCommand.IInteraction {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardFeedbackInteraction.class);
    private final FeedbackDialog m_dialog;
    private final TFile m_logFile;
    private final TFile m_workspaceMetaDataDirectory;

    public StandardFeedbackInteraction(FeedbackDialog dialog, TFile logFile, TFile workspaceMetaDataDirectory) {
        assert (dialog != null) : "Parameter 'dialog' of method 'StandardFeedbackInteraction' must not be null";
        assert (logFile != null) : "Parameter 'logFile' of method 'StandardFeedbackInteraction' must not be null";
        assert (workspaceMetaDataDirectory != null) : "Parameter 'workspaceMetaDataDirectory' of method 'StandardFeedbackInteraction' must not be null";
        this.m_dialog = dialog;
        this.m_logFile = logFile;
        this.m_workspaceMetaDataDirectory = workspaceMetaDataDirectory;
    }

    public INavigationState getNavigationState() {
        return null;
    }

    public boolean collect(SendFeedbackCommand.FeedbackData data) {
        assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
        if (this.isNullOrEmpty(this.m_dialog.getContactName()) || this.isNullOrEmpty(this.m_dialog.getEmail()) || this.isNullOrEmpty(this.m_dialog.getSubject()) || this.isNullOrEmpty(this.m_dialog.getFeedbackText())) {
            return false;
        }
        data.setSalutation(this.m_dialog.getSalutation());
        data.setContactName(this.m_dialog.getContactName());
        data.setEmail(this.m_dialog.getEmail());
        data.setPhone(this.m_dialog.getPhone());
        data.setSubject(this.m_dialog.getSubject());
        StringBuilder feedbackText = new StringBuilder(this.m_dialog.getFeedbackText());
        feedbackText.append(StringUtility.LINE_SEPARATOR);
        feedbackText.append(StringUtility.LINE_SEPARATOR);
        String executionContextInfo = CommandRegistry.getInstance().getExecutionContextInfo();
        feedbackText.append(executionContextInfo);
        data.setContextInfo(feedbackText.toString());
        if (this.m_dialog.attachLogFile()) {
            LOGGER.error("Additional command execution info (also included in feedback email):" + StringUtility.LINE_SEPARATOR + executionContextInfo);
            data.setLogFile(this.m_logFile);
            ArrayList<TFile> additionalFiles = new ArrayList<TFile>(1);
            TFile dotLog = new TFile((File)this.m_workspaceMetaDataDirectory, ".log");
            additionalFiles.add(dotLog);
            data.setAdditionalFiles(additionalFiles);
        }
        return true;
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

