/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.common;

import com.hello2morrow.sonargraph.core.foundation.common.tree.TreeNode;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShowInViewNode
extends TreeNode<ShowInViewNode> {
    private final List<IStandardEnumeration> m_options = new ArrayList<IStandardEnumeration>();
    private final List<Element> m_elements;
    private final String m_text;
    private final String m_imageName;
    private final String m_secondaryId;
    private final String m_sortName;
    private boolean m_addSeparatorAfter;

    public ShowInViewNode(String text, String imageName) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'ShowInViewNode' must not be empty";
        assert (imageName != null && imageName.length() > 0) : "Parameter 'imageName' of method 'ShowInViewNode' must not be empty";
        this.m_elements = Collections.emptyList();
        this.m_text = text;
        this.m_imageName = imageName;
        this.m_secondaryId = null;
        this.m_sortName = null;
    }

    public ShowInViewNode(String text, String imageName, List<? extends Element> elements, IStandardEnumeration ... options) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'ShowInViewNode' must not be empty";
        assert (imageName != null && imageName.length() > 0) : "Parameter 'imageName' of method 'ShowInViewNode' must not be empty";
        this.m_elements = new ArrayList<Element>(elements);
        if (options != null && options.length > 0) {
            IStandardEnumeration[] iStandardEnumerationArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                IStandardEnumeration next = iStandardEnumerationArray[n2];
                this.m_options.add(next);
                ++n2;
            }
        }
        this.m_text = text;
        this.m_imageName = imageName;
        this.m_secondaryId = null;
        this.m_sortName = null;
    }

    public ShowInViewNode(List<? extends Element> elements, String text, String imageName, boolean useDefaultShowInViewText) {
        assert (elements != null) : "Parameter 'elements' of method 'ShowInViewNode' must not be null";
        assert (text != null) : "Parameter 'text' of method 'ShowInViewNode' must not be null";
        assert (imageName != null) : "Parameter 'imageName' of method 'ShowInViewNode' must not be null";
        this.m_elements = new ArrayList<Element>(elements);
        this.m_text = useDefaultShowInViewText ? "Show in " + text + " View" : text;
        this.m_imageName = imageName;
        this.m_secondaryId = null;
        this.m_sortName = null;
    }

    public ShowInViewNode(List<? extends Element> elements, String text, String imageName, boolean useDefaultShowInViewText, String secondaryId) {
        assert (elements != null) : "Parameter 'elements' of method 'ShowInViewNode' must not be null";
        assert (text != null) : "Parameter 'text' of method 'ShowInViewNode' must not be null";
        assert (imageName != null) : "Parameter 'imageName' of method 'ShowInViewNode' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'ShowInViewNode' must not be empty";
        this.m_elements = new ArrayList<Element>(elements);
        this.m_text = useDefaultShowInViewText ? "Show in " + text + " View" : text;
        this.m_imageName = imageName;
        this.m_secondaryId = secondaryId;
        this.m_sortName = null;
    }

    public ShowInViewNode(List<Element> elements, String text, String imageName, String secondaryId, String sortName) {
        assert (elements != null) : "Parameter 'elements' of method 'ShowInViewNode' must not be null";
        assert (text != null) : "Parameter 'text' of method 'ShowInViewNode' must not be null";
        assert (imageName != null) : "Parameter 'imageName' of method 'ShowInViewNode' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'ShowInViewNode' must not be empty";
        assert (sortName == null || !sortName.isEmpty()) : "Parameter 'sortName' of method 'ShowInViewNode' must either be null or not empty";
        this.m_elements = new ArrayList<Element>(elements);
        this.m_text = text;
        this.m_imageName = imageName;
        this.m_secondaryId = secondaryId;
        this.m_sortName = sortName;
    }

    public final String getSortName() {
        return this.m_sortName != null ? this.m_sortName : this.getName();
    }

    public final String getSecondaryId() {
        ShowInViewNode parent;
        if (this.m_secondaryId == null && (parent = (ShowInViewNode)this.getParent()) != null) {
            return parent.getSecondaryId();
        }
        return this.m_secondaryId;
    }

    public final boolean accept(IShowInViewNodeVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        return visitor.visit(this);
    }

    public final List<Element> getElements() {
        return this.m_elements;
    }

    public final List<IStandardEnumeration> getOptions() {
        if (this.getParent() != null) {
            this.m_options.addAll(((ShowInViewNode)this.getParent()).getOptions());
        }
        return this.m_options;
    }

    public final void addOption(IStandardEnumeration value) {
        assert (value != null) : "Parameter 'value' of method 'addOption' must not be null";
        this.m_options.add(value);
    }

    public final void addAllOptions(List<IStandardEnumeration> options) {
        assert (options != null) : "Parameter 'options' of method 'addAllOptions' must not be null";
        this.m_options.addAll(options);
    }

    public final String getImageResourceName() {
        return this.m_imageName;
    }

    public final String getName() {
        return this.m_text;
    }

    public final void setAddSeparatorAfter(boolean addSeparatorAfter) {
        this.m_addSeparatorAfter = addSeparatorAfter;
    }

    public final boolean addSeparatorAfter() {
        return this.m_addSeparatorAfter;
    }

    public final int getDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        return ((ShowInViewNode)this.getParent()).getDepth() + 1;
    }

    public static interface IShowInViewNodeVisitor {
        public boolean visit(ShowInViewNode var1);
    }
}

