/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.ui.swt.base.view.INavigationStateLifeCycleListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import com.hello2morrow.sonargraph.ui.swt.common.IViewAccesor;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import com.hello2morrow.sonargraph.ui.swt.common.ViewKey;
import com.hello2morrow.sonargraph.ui.swt.common.ViewNavigationManager;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ViewAccessor
implements IViewAccesor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ViewAccessor.class);
    private final IEclipseContext m_eclipseContext;
    private final IEventBroker m_eventBroker;
    private final Display m_display;
    private final List<IWorkbenchView> m_viewSelectionChain = new ArrayList<IWorkbenchView>();
    private IWorkbenchView m_currentlySelectedView;
    private Control m_currentlySelectedComponent;
    private boolean m_inRestoreState;

    ViewAccessor(IEclipseContext eclipseContext, IEventBroker eventBroker, Display display) {
        assert (eclipseContext != null) : "Parameter 'eclipseContext' of method 'ViewAccessor' must not be null";
        assert (eventBroker != null) : "Parameter 'eventBroker' of method 'ViewAccessor' must not be null";
        assert (display != null) : "Parameter 'display' of method 'ViewAccessor' must not be null";
        this.m_eclipseContext = eclipseContext;
        this.m_eventBroker = eventBroker;
        this.m_display = display;
    }

    IEclipseContext getEclipseContext() {
        return this.m_eclipseContext;
    }

    @Override
    public synchronized boolean inNavigationStateRestore() {
        return this.m_inRestoreState;
    }

    void refreshUIElements() {
        this.m_eventBroker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
    }

    void selectView(IWorkbenchView view, Control control) {
        assert (view != null) : "Parameter 'view' of method 'selectView' must not be null";
        LOGGER.debug("Select view '" + String.valueOf(view.getViewId()) + "'");
        if (view.isActive()) {
            boolean differentViewSelected;
            List<Control> viewComponents = view.getViewComponents();
            if (LOGGER.isTraceEnabled()) {
                if (control == null) {
                    LOGGER.trace("No component selected");
                } else {
                    LOGGER.trace("Component selected: " + control.getClass().getSimpleName() + " [" + Integer.toHexString(control.hashCode()) + "]");
                    if (!viewComponents.isEmpty()) {
                        LOGGER.trace("View's components:");
                        for (Control nextComponent : viewComponents) {
                            LOGGER.trace(" - " + nextComponent.getClass().getSimpleName() + " [" + Integer.toHexString(nextComponent.hashCode()) + "]");
                        }
                    }
                }
            }
            boolean bl = differentViewSelected = this.m_currentlySelectedView != view;
            if (differentViewSelected) {
                this.m_currentlySelectedComponent = null;
                if (!viewComponents.isEmpty()) {
                    control = view.getSelectedViewComponent();
                }
            }
            boolean differentComponentSelected = false;
            if (control != null && viewComponents.contains(control) && this.m_currentlySelectedComponent != control) {
                differentComponentSelected = true;
                this.m_currentlySelectedComponent = control;
            }
            if (differentViewSelected || differentComponentSelected) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("View/component selection changed to " + (differentViewSelected ? "different view '" : "same view '") + String.valueOf(view.getViewId()) + "'" + (differentComponentSelected ? " different component '" : " same component '") + (String)(control == null ? "NONE'" : control.getClass().getSimpleName() + "' [" + Integer.toHexString(control.hashCode()) + "]"));
                }
                this.m_currentlySelectedView = view;
                this.m_viewSelectionChain.remove(view);
                this.m_viewSelectionChain.add(view);
                for (IWorkbenchView next : RcpUtility.getWorkbenchViews(this.m_eclipseContext)) {
                    next.viewSelected(this.m_currentlySelectedView, differentComponentSelected ? this.m_currentlySelectedComponent : null, differentViewSelected);
                }
            } else {
                LOGGER.debug("View/component selection not changed");
            }
        } else {
            LOGGER.debug("View is not active");
        }
        LOGGER.debug("Select view '" + String.valueOf(view.getViewId()) + "' - done");
    }

    void viewClosed(IWorkbenchView view) {
        assert (view != null) : "Parameter 'view' of method 'viewClosed' must not be null";
        LOGGER.debug("Close view '" + String.valueOf(view.getViewId()) + "'");
        List<IWorkbenchView> views = RcpUtility.getWorkbenchViews(this.m_eclipseContext);
        if (this.m_currentlySelectedView == view) {
            for (IWorkbenchView next : views) {
                if (next == view || !next.isActive()) continue;
                next.viewSelectionChanged(view, Collections.emptyList());
            }
            for (IWorkbenchView next : views) {
                if (next == view || !next.isActive()) continue;
                next.viewSelected(null, null, false);
            }
            this.m_currentlySelectedView = null;
            this.m_currentlySelectedComponent = null;
        }
        this.m_viewSelectionChain.remove(view);
        for (IWorkbenchView next : views) {
            if (next == view || !next.isActive()) continue;
            next.viewClosed(view);
        }
        ViewNavigationManager.getInstance().clear(view.getViewId(), view.getSecondaryId());
        LOGGER.debug("Close view '" + String.valueOf(view.getViewId()) + "' - done");
    }

    Display getDisplay() {
        return this.m_display;
    }

    List<IWorkbenchView> getViewSelectionChain() {
        return Collections.unmodifiableList(this.m_viewSelectionChain);
    }

    IWorkbenchView getCurrentlySelectedView() {
        return this.m_currentlySelectedView;
    }

    Control getCurrentlySelectedViewComponent() {
        return this.m_currentlySelectedComponent;
    }

    <T extends IWorkbenchView> T getCurrentlySelectedView(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getCurrentlySelectedView' must not be null";
        if (this.m_currentlySelectedView != null && clazz.isAssignableFrom(this.m_currentlySelectedView.getClass())) {
            return (T)this.m_currentlySelectedView;
        }
        return null;
    }

    @Override
    public void navigationStatesRemoved(List<NavigationState> states) {
        assert (states != null) : "Parameter 'state' of method 'navigationStateRemoved' must not be null";
        EPartService partService = (EPartService)this.m_eclipseContext.get(EPartService.class);
        assert (partService != null) : "Parameter 'partService' of method 'restoreNavigationState' must not be null";
        THashMap keyToState = new THashMap();
        for (NavigationState navigationState : states) {
            if (!navigationState.getViewKey().getId().hasProperty(IViewId.Property.REQUIRES_STATE_LIFECYCLE_NOTIFICATION)) continue;
            ViewKey viewKey = navigationState.getViewKey();
            ArrayList<NavigationState> statesForKey = (ArrayList<NavigationState>)keyToState.get(viewKey);
            if (statesForKey == null) {
                statesForKey = new ArrayList<NavigationState>();
            }
            statesForKey.add(navigationState);
            keyToState.put(viewKey, statesForKey);
        }
        for (List statesForView : keyToState.values()) {
            NavigationState state = (NavigationState)statesForView.get(0);
            MPart part = RcpUtility.findPart(this.m_eclipseContext, state.getViewKey().getId(), state.getViewKey().getSecondaryId());
            if (part == null) continue;
            IWorkbenchView view = RcpUtility.getWorkbenchView(part, IWorkbenchView.class);
            assert (view != null) : "'workbenchView' of method 'restoreNavigationState' must not be null";
            assert (view instanceof INavigationStateLifeCycleListener) : "Unexpected class in method 'navigationStateAdded': " + String.valueOf(view);
            ((INavigationStateLifeCycleListener)((Object)view)).navigationStatesRemoved(statesForView);
        }
    }

    @Override
    public void navigationStateAdded(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'navigationStateAdded' must not be null";
        ViewKey viewKey = state.getViewKey();
        if (viewKey.getId().hasProperty(IViewId.Property.REQUIRES_STATE_LIFECYCLE_NOTIFICATION)) {
            EPartService partService = (EPartService)this.m_eclipseContext.get(EPartService.class);
            assert (partService != null) : "'partService' of method 'navigationStateAdded' must not be null";
            MPart part = RcpUtility.findPart(this.m_eclipseContext, viewKey.getId(), viewKey.getSecondaryId());
            if (part != null) {
                IWorkbenchView view = RcpUtility.getWorkbenchView(part, IWorkbenchView.class);
                assert (view != null) : "'view' of method 'navigationStateAdded' must not be null for '" + String.valueOf(viewKey) + "'";
                assert (view instanceof INavigationStateLifeCycleListener) : "Unexpected class '" + view.getClass().getName() + "' in method 'navigationStateAdded' for '" + String.valueOf(viewKey) + "'";
                ((INavigationStateLifeCycleListener)((Object)view)).navigationStateAdded(state);
            } else {
                LOGGER.warn("'MPart' not found for '" + String.valueOf(viewKey) + "' in 'navigationStateAdded()':\n" + ExceptionUtility.collectAll((Throwable)new Throwable()));
            }
        }
    }

    @Override
    public void navigationStatesChanged() {
        this.refreshUIElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreNavigationState(NavigationState state) {
        assert (state != null) : "Parameter 'state' of method 'restoreNavigationState' must not be null";
        ViewKey viewKey = state.getViewKey();
        LOGGER.debug("[" + String.valueOf(viewKey) + "] Restore navigation state");
        ViewAccessor viewAccessor = this;
        synchronized (viewAccessor) {
            this.m_inRestoreState = true;
        }
        EPartService partService = (EPartService)this.m_eclipseContext.get(EPartService.class);
        assert (partService != null) : "Parameter 'partService' of method 'restoreNavigationState' must not be null";
        MPart part = RcpUtility.findPart(this.m_eclipseContext, viewKey.getId(), viewKey.getSecondaryId());
        boolean viewCreated = false;
        IWorkbenchView view = null;
        if (viewKey.getId().hasProperty(IViewId.Property.ALLOWS_MULTIPLE_INSTANCES)) {
            if (part == null) {
                view = RcpUtility.createView(this.m_eclipseContext, partService, viewKey.getId(), viewKey.getSecondaryId());
                if (view != null) {
                    viewCreated = true;
                }
            } else {
                view = RcpUtility.getWorkbenchView(part, IWorkbenchView.class);
            }
        } else {
            assert (part != null) : "'part' of method 'restoreNavigationState' must not be null";
            if (part.getObject() == null) {
                view = RcpUtility.createView(this.m_eclipseContext, partService, viewKey.getId());
                viewCreated = true;
            } else {
                view = RcpUtility.getWorkbenchView(part, IWorkbenchView.class);
            }
        }
        if (view != null) {
            LOGGER.debug("[" + String.valueOf(viewKey) + "] view " + (viewCreated ? "created" : "found"));
            view.restoreNavigationState(state, viewCreated);
        } else {
            LOGGER.warn("[" + String.valueOf(viewKey) + "] Unable to find/create");
        }
        ViewAccessor viewAccessor2 = this;
        synchronized (viewAccessor2) {
            this.m_inRestoreState = false;
        }
        LOGGER.debug("[" + String.valueOf(viewKey) + "] Restore navigation state");
    }
}

