/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.command.common.ICommandResultConsumerForwarder;
import com.hello2morrow.sonargraph.core.model.common.SonargraphException;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.event.ExportFinishedEvent;
import com.hello2morrow.sonargraph.foundation.activity.Activity;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.WorkerContext;
import com.hello2morrow.sonargraph.foundation.common.RunnableWithResult;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.event.IEventForwarder;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.ActivityEvent;
import com.hello2morrow.sonargraph.ui.swt.base.view.ActivityEventBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ModalDialog;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WaitForCommandCompletion;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.dialog.MessageDialogWithContent;
import com.hello2morrow.sonargraph.ui.swt.dialog.OperationResultDialog;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserInterfaceAdapter
implements IEventForwarder,
ICommandResultConsumerForwarder,
Window.IExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserInterfaceAdapter.class);
    private static final String RUNNING = "...";
    private static UserInterfaceAdapter s_instance;
    private final CommandResultConsumer m_commandResultConsumer = new CommandResultConsumer();
    private final NoneProgressMonitor m_noneProgressMonitor = new NoneProgressMonitor();
    private final org.eclipse.e4.core.services.log.Logger m_logger;
    private IProgressMonitor m_statusLineProgressMonitor;
    private IProgressMonitor m_currentProgressMonitor;
    private int m_currentWorked;
    private boolean m_processEventsSynchronously;

    private UserInterfaceAdapter(org.eclipse.e4.core.services.log.Logger logger, boolean processEventsSynchronously) {
        assert (logger != null) : "Parameter 'logger' of method 'UserInterfaceAdapter' must not be null";
        this.m_logger = logger;
        this.m_processEventsSynchronously = processEventsSynchronously;
        EventManager.getInstance().attach((EventHandler)new EventHandler<ActivityEvent>(ActivityEvent.class, (Object)this){

            public void handleEvent(ActivityEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                if (WorkbenchRegistry.isRunning()) {
                    UserInterfaceAdapter.this.handleActivity(event);
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ExportFinishedEvent>(ExportFinishedEvent.class, (Object)this){

            public void handleEvent(ExportFinishedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                OperationResultWithOutcome result = event.getResult();
                if (result.isFailure()) {
                    UserInterfaceAdapter.this.process((OperationResult)result);
                    return;
                }
                final TFile targetFile = (TFile)result.getOutcome();
                if (!$assertionsDisabled && targetFile == null) {
                    throw new AssertionError((Object)"'targetFile' of export must not be null");
                }
                if (Feedback.CONFIRMED == UserInterfaceAdapter.getInstance().question("Export has been saved to: \n\n" + targetFile.getNormalizedAbsolutePath() + "\n\nDo you want to open it?", false)) {
                    UserInterfaceAdapter.this.displayUiElement(new Runnable(){

                        @Override
                        public void run() {
                            Program.launch((String)targetFile.getNormalizedAbsolutePath());
                        }
                    });
                }
            }
        });
        EventManager.getInstance().attach((EventHandler)new EventHandler<ExceptionEvent>(ExceptionEvent.class, (Object)this){

            public void handleEvent(ExceptionEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'handleEvent' must not be null");
                }
                SonargraphException exception = event.getException();
                Throwable cause = exception.getCause();
                if (exception.getSeverity() == SonargraphException.Severity.WARNING) {
                    if (cause != null) {
                        LOGGER.warn(ExceptionUtility.collectFirstAndLast((Throwable)cause));
                    }
                    UserInterfaceAdapter.this.m_logger.warn((Throwable)exception);
                } else {
                    if (cause != null) {
                        LOGGER.error(ExceptionUtility.collectFirstAndLast((Throwable)cause));
                    }
                    UserInterfaceAdapter.this.m_logger.error((Throwable)exception);
                }
            }
        });
        Window.setExceptionHandler((Window.IExceptionHandler)this);
        EventManager.getInstance().setEventForwarder((IEventForwarder)this);
        CommandRegistry.getInstance().setCommandResultConsumerForwarder((ICommandResultConsumerForwarder)this);
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static void createInstance(org.eclipse.e4.core.services.log.Logger logger, boolean processEventSynchronously) {
        assert (!UserInterfaceAdapter.hasInstance()) : "Instance already created";
        assert (logger != null) : "Parameter 'logger' of method 'createInstance' must not be null";
        assert (WorkbenchRegistry.hasInstance()) : "Workbench registry not yet created";
        s_instance = new UserInterfaceAdapter(logger, processEventSynchronously);
    }

    public static UserInterfaceAdapter getInstance() {
        assert (UserInterfaceAdapter.hasInstance()) : "Instance not created";
        return s_instance;
    }

    public static void delete() {
        if (s_instance != null) {
            EventManager.getInstance().detach(ActivityEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(ExportFinishedEvent.class, (Object)s_instance);
            EventManager.getInstance().detach(ExceptionEvent.class, (Object)s_instance);
            s_instance = null;
        }
    }

    public void runCommandResultConsumption(OperationResult result, Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'runCommandResultConsumption' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            if (result != null) {
                this.process(result);
            }
            WorkbenchRegistry.getInstance().getDisplay().syncExec(runnable);
        }
    }

    public void runEventDispatch(Class<? extends Event> eventClass, Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'runEventDispatch' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            if (ExceptionEvent.class.isAssignableFrom(eventClass)) {
                runnable.run();
            } else if (this.m_processEventsSynchronously) {
                WorkbenchRegistry.getInstance().getDisplay().syncExec(runnable);
            } else {
                WorkbenchRegistry.getInstance().getDisplay().asyncExec(runnable);
            }
        }
    }

    public void runRegistrantRequestPerformed(Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'runRegistrantRequestPerformed' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            WorkbenchRegistry.getInstance().getDisplay().syncExec(runnable);
        }
    }

    public void displayUiElement(Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'displayUiElement' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            WorkbenchRegistry.getInstance().getDisplay().syncExec(runnable);
        }
    }

    public void displayUiElementAsync(Runnable runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'displayUiElementAsync' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            WorkbenchRegistry.getInstance().getDisplay().asyncExec(runnable);
        }
    }

    public <T> T displayUiElementWithResult(RunnableWithResult<T> runnable) {
        assert (runnable != null) : "Parameter 'runnable' of method 'displayUiElementWithResult' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            WorkbenchRegistry.getInstance().getDisplay().syncExec(runnable);
            return runnable.getResult();
        }
        return null;
    }

    public void process(final OperationResult result) {
        assert (result != null) : "'result' must not be null";
        if (!result.isEmpty()) {
            this.displayUiElement(new Runnable(){

                @Override
                public void run() {
                    OperationResultDialog.open(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), result);
                }
            });
        }
    }

    public void openDialog(int type, String message, String content) {
        assert (message != null) : "'message' must not be null";
        assert (message.length() > 0) : "'message' must not be empty";
        new MessageDialogWithContent(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), message, type, content).open();
    }

    private int openQuestionDialog(int dialogType, String message, String content, String[] buttonLabels) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'openQuestionDialog' must not be empty";
        assert (buttonLabels != null && buttonLabels.length > 0) : "Parameter 'buttonLabels' of method 'openQuestionDialog' must not be empty";
        MessageDialogWithContent d = new MessageDialogWithContent(WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), message, dialogType, buttonLabels, content);
        return d.open();
    }

    private Feedback openQuestionDialog(String message, boolean offerCancel) {
        String[] stringArray;
        assert (message != null) : "'message' must not be null";
        assert (message.length() > 0) : "'message' must not be empty";
        Shell shell = WorkbenchRegistry.getInstance().getMainApplicationWindowShell();
        if (offerCancel) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = IDialogConstants.YES_LABEL;
            stringArray2[1] = IDialogConstants.NO_LABEL;
            stringArray = stringArray2;
            stringArray2[2] = IDialogConstants.CANCEL_LABEL;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = IDialogConstants.YES_LABEL;
            stringArray = stringArray3;
            stringArray3[1] = IDialogConstants.NO_LABEL;
        }
        MessageDialogWithContent d = new MessageDialogWithContent(shell, message, 3, stringArray, null);
        switch (d.open()) {
            case 0: {
                return Feedback.CONFIRMED;
            }
            case 1: {
                return Feedback.DISAGREED;
            }
        }
        return Feedback.CANCELLED;
    }

    public void information(final String message, final String detailMessage) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'information' must not be empty";
        this.displayUiElement(new Runnable(){

            @Override
            public void run() {
                UserInterfaceAdapter.this.openDialog(2, message, detailMessage);
            }
        });
    }

    public void warning(final String message, final String detailMessage) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'warning' must not be empty";
        this.displayUiElement(new Runnable(){

            @Override
            public void run() {
                UserInterfaceAdapter.this.openDialog(4, message, detailMessage);
            }
        });
    }

    public void error(final String message, final String detailMessage) {
        assert (message != null && message.length() > 0) : "Parameter 'message' of method 'warning' must not be empty";
        this.displayUiElement(new Runnable(){

            @Override
            public void run() {
                UserInterfaceAdapter.this.openDialog(1, message, detailMessage);
            }
        });
    }

    public Feedback question(final String question, final boolean offerCancel) {
        assert (question != null && question.length() > 0) : "Parameter 'question' of method 'question' must not be empty";
        return this.displayUiElementWithResult(new RunnableWithResult<Feedback>(){

            @Override
            public void run() {
                this.setResult(UserInterfaceAdapter.this.openQuestionDialog(question, offerCancel));
            }
        });
    }

    public int question(final int dialogType, final String question, final String content, final String[] buttonLabels) {
        assert (question != null && question.length() > 0) : "Parameter 'question' of method 'question' must not be empty";
        assert (buttonLabels != null && buttonLabels.length > 0) : "Parameter 'buttonLabels' of method 'question' must not be empty";
        return this.displayUiElementWithResult(new RunnableWithResult<Integer>(){

            @Override
            public void run() {
                this.setResult(UserInterfaceAdapter.this.openQuestionDialog(dialogType, question, content, buttonLabels));
            }
        });
    }

    public int question(String question, String[] buttonLabels) {
        assert (question != null && question.length() > 0) : "Parameter 'question' of method 'question' must not be empty";
        assert (buttonLabels != null && buttonLabels.length > 0) : "Parameter 'buttonLabels' of method 'question' must not be empty";
        return this.question(3, question, null, buttonLabels);
    }

    public void run(Command command, IWorkerContext workerContext, CommandResultConsumer consumer) {
        assert (command != null) : "Parameter 'command' of method 'run' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'run' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'run' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            command.run(workerContext, consumer);
        }
    }

    public void run(Command command, CommandResultConsumer consumer) {
        assert (command != null) : "Parameter 'command' of method 'run' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'run' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            this.run(command, (IWorkerContext)(command.getActivityMode() != ActivityMode.NONE ? new ActivityEventBasedWorkerContext(WorkbenchRegistry.getInstance().getProvider()) : DefaultWorkerContext.INSTANCE), consumer);
        }
    }

    public void run(Command command) {
        this.run(command, this.m_commandResultConsumer);
    }

    public CommandException runWaitingForCompletion(Command command, IWorkerContext workerContext) {
        assert (command != null) : "Parameter 'command' of method 'runWaitingForCompletion' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'runWaitingForCompletion' must not be null";
        if (WorkbenchRegistry.isRunning()) {
            WaitForCommandCompletion waitForCommandCompletion = new WaitForCommandCompletion(WorkbenchRegistry.getInstance().getDisplay(), command, workerContext);
            waitForCommandCompletion.run();
            return waitForCommandCompletion.getCommandExecutionException();
        }
        return null;
    }

    public CommandException runWaitingForCompletion(Command command) {
        assert (command != null) : "Parameter 'command' of method 'runWaitingForCompletion' must not be null";
        Object workerContext = command.getActivityMode() != ActivityMode.NONE ? new ActivityEventBasedWorkerContext(WorkbenchRegistry.getInstance().getProvider()) : DefaultWorkerContext.INSTANCE;
        return this.runWaitingForCompletion(command, (IWorkerContext)workerContext);
    }

    public void handleException(Throwable throwable) {
        assert (throwable != null) : "Parameter 'throwable' of method 'handleException' must not be null";
        this.m_logger.error(throwable, "UI related exception");
    }

    private void reset() {
        if (WorkbenchRegistry.isRunning()) {
            try {
                Shell[] shellArray = WorkbenchRegistry.getInstance().getDisplay().getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell nextShell = shellArray[n2];
                    nextShell.setCursor(null);
                    nextShell.setEnabled(true);
                    ++n2;
                }
                if (this.m_currentProgressMonitor != null) {
                    this.m_currentProgressMonitor.done();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_currentWorked = 0;
            this.m_currentProgressMonitor = null;
        }
    }

    public void setStatusLineProgressMonitor(IProgressMonitor progressMonitor) {
        this.m_statusLineProgressMonitor = progressMonitor;
    }

    private IProgressMonitor getStatusLineProgressMonitor() {
        if (this.m_statusLineProgressMonitor != null) {
            return this.m_statusLineProgressMonitor;
        }
        LOGGER.warn("No status line manager avaliable");
        return this.m_noneProgressMonitor;
    }

    private Shell getCurrentlyFocusedShell() {
        Shell[] shellArray = WorkbenchRegistry.getInstance().getDisplay().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell nextShell = shellArray[n2];
            if (nextShell.isFocusControl()) {
                return nextShell;
            }
            ++n2;
        }
        return WorkbenchRegistry.getInstance().getMainApplicationWindowShell();
    }

    private void handleActivity(ActivityEvent activityEvent) {
        assert (activityEvent != null) : "Parameter 'activityEvent' of method 'handleActivity' must not be null";
        Activity activity = activityEvent.getActivity();
        assert (activity != null) : "'activity' of method 'handleActivity' must not be null";
        WorkerContext workerContext = activityEvent.getWorkerContext();
        assert (workerContext != null) : "'workerContext' of method 'handleActivity' must not be null";
        if (activity.isRunning()) {
            if (activity.hasJustBeenStarted()) {
                switch (activity.getMode()) {
                    case MODAL: {
                        this.m_currentProgressMonitor = new ModalDialog(this.getCurrentlyFocusedShell(), activity.getCurrentMessage(), activity.providesProgress(), false);
                        break;
                    }
                    case MODAL_CANCELABLE: {
                        this.m_currentProgressMonitor = new ModalDialog(this.getCurrentlyFocusedShell(), activity.getCurrentMessage(), activity.providesProgress(), true);
                        break;
                    }
                    case BLOCKING: {
                        Cursor waitCursor = UiResourceManager.getInstance().getCursor(1);
                        Shell[] shellArray = WorkbenchRegistry.getInstance().getDisplay().getShells();
                        int n = shellArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell nextShell = shellArray[n2];
                            nextShell.setCursor(waitCursor);
                            nextShell.setEnabled(false);
                            ++n2;
                        }
                        this.m_currentProgressMonitor = this.getStatusLineProgressMonitor();
                        break;
                    }
                    case NONE: {
                        this.m_currentProgressMonitor = this.m_noneProgressMonitor;
                        break;
                    }
                }
                try {
                    this.m_currentProgressMonitor.beginTask(activity.getCurrentMessage() + RUNNING, activity.providesProgress() ? activity.getTotal() : -1);
                }
                catch (Exception waitCursor) {}
            } else if (this.m_currentProgressMonitor != null) {
                boolean isCanceled = false;
                try {
                    isCanceled = this.m_currentProgressMonitor.isCanceled();
                }
                catch (Exception e) {
                    isCanceled = true;
                }
                if (isCanceled) {
                    this.reset();
                    assert (workerContext != null) : "'workerContext' must not be null";
                    workerContext.cancel();
                } else {
                    int workIncrement = activity.getWorkedInPercent() - this.m_currentWorked;
                    this.m_currentProgressMonitor.worked(workIncrement);
                    this.m_currentWorked = activity.getWorkedInPercent();
                    if (activity.isMainStep()) {
                        this.m_currentProgressMonitor.setTaskName("");
                        this.m_currentProgressMonitor.subTask(activity.getCurrentMessage() + RUNNING);
                    }
                }
            }
        } else {
            this.reset();
        }
    }

    public static enum Feedback {
        CONFIRMED,
        DISAGREED,
        CANCELLED;

    }

    private static final class NoneProgressMonitor
    implements IProgressMonitor {
        NoneProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

