/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.foundation.propertyreader.IPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

final class PropertyTableSorter<T>
extends ViewerComparator {
    private final List<StrictPair<String, Boolean>> m_sortBy = new ArrayList<StrictPair<String, Boolean>>(5);
    private final IPropertyReader m_propertyReader;
    private final boolean m_hasInitialSort;
    private List<StrictPair<String, Boolean>> m_sortOrder;

    PropertyTableSorter(IPropertyReader propertyReader, StrictPair<String, Boolean> initialSort) {
        assert (propertyReader != null) : "Parameter 'propertyReader' of method 'PropertyTableSorter' must not be null";
        this.m_propertyReader = propertyReader;
        boolean bl = this.m_hasInitialSort = initialSort != null;
        if (initialSort != null) {
            this.m_sortBy.add(initialSort);
        }
    }

    boolean hasInitialSort() {
        return this.m_hasInitialSort;
    }

    boolean hasSortCriteria() {
        return !this.m_sortBy.isEmpty();
    }

    void setSortBy(String propertyName) {
        assert (propertyName != null) : "'propertyName' must not be null";
        StrictPair entry = new StrictPair((Object)propertyName, (Object)true);
        if (!this.m_sortBy.isEmpty()) {
            StrictPair<String, Boolean> firstEntry = this.m_sortBy.get(0);
            if (((String)firstEntry.getFirst()).equals(propertyName)) {
                entry = new StrictPair((Object)propertyName, (Object)((Boolean)firstEntry.getSecond() == false ? 1 : 0));
            }
            this.m_sortBy.clear();
        }
        this.m_sortBy.add((StrictPair<String, Boolean>)entry);
        if (this.m_sortOrder != null) {
            this.addSortProperties(this.m_sortOrder, this.m_sortBy);
        }
    }

    private void addSortProperties(List<StrictPair<String, Boolean>> sortOrder, List<StrictPair<String, Boolean>> sortBy) {
        for (StrictPair<String, Boolean> next : sortOrder) {
            if (sortBy != null && sortBy.contains(next)) continue;
            sortBy.add(next);
        }
    }

    String getSortProperty() {
        if (this.m_sortBy.isEmpty()) {
            return null;
        }
        return (String)this.m_sortBy.get(0).getFirst();
    }

    Boolean isAscendingSort() {
        if (this.m_sortBy.isEmpty()) {
            return null;
        }
        return (Boolean)this.m_sortBy.get(0).getSecond();
    }

    void addSortProperty(String propertyName, boolean ascending, boolean reset) {
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'addSortProperty' must not be empty";
        if (reset) {
            this.m_sortBy.clear();
        }
        this.m_sortBy.add((StrictPair<String, Boolean>)new StrictPair((Object)propertyName, (Object)ascending));
    }

    void removeSortProperty(String propertyName) {
        assert (propertyName != null) : "Parameter 'propertyName' of method 'removeSortProperty' must not be null";
        if (!this.m_sortBy.isEmpty()) {
            Iterator<StrictPair<String, Boolean>> iter = this.m_sortBy.iterator();
            while (iter.hasNext()) {
                StrictPair<String, Boolean> next = iter.next();
                if (!((String)next.getFirst()).equals(propertyName)) continue;
                iter.remove();
                break;
            }
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        assert (o1 != null) : "'o1' must not be null";
        assert (o2 != null) : "'o2' must not be null";
        if (this.m_sortBy.isEmpty()) {
            return 0;
        }
        for (StrictPair<String, Boolean> entry : this.m_sortBy) {
            String s2;
            int sortOrder = (Boolean)entry.getSecond() != false ? 1 : -1;
            Object v1 = this.m_propertyReader.readProperty(o1, (String)entry.getFirst());
            Object v2 = this.m_propertyReader.readProperty(o2, (String)entry.getFirst());
            if (v1 == null || v2 == null) {
                if (v1 != null) {
                    return sortOrder;
                }
                if (v2 == null) continue;
                return -sortOrder;
            }
            if (v1 instanceof Number && v2 instanceof Number) {
                Number n1 = (Number)v1;
                Number n2 = (Number)v2;
                double doubleDiff = n1.doubleValue() - n2.doubleValue();
                if (Math.abs(doubleDiff) < 1.0E-8) continue;
                return sortOrder * (int)Math.signum(doubleDiff);
            }
            if (v1 instanceof Date && v2 instanceof Date) {
                Date d1 = (Date)v1;
                Date d2 = (Date)v2;
                int result = sortOrder * d1.compareTo(d2);
                if (result == 0) continue;
                return result;
            }
            String s1 = v1.toString().toLowerCase();
            int result = s1.compareTo(s2 = v2.toString().toLowerCase()) * sortOrder;
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    void setSortOrder(List<StrictPair<String, Boolean>> sortOrder) {
        assert (sortOrder != null && sortOrder.size() > 0) : "Parameter 'sortOrder' of method 'setSortOrder' must not be empty";
        this.m_sortOrder = sortOrder;
        this.addSortProperties(this.m_sortOrder, this.m_sortBy);
    }
}

