/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.swt.base.workbench;

import com.hello2morrow.sonargraph.ui.swt.base.view.IPropertyTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

final class PropertyCellLabelProvider<T>
extends CellLabelProvider {
    private final IPropertyTableViewer<T> m_tableViewer;
    private final String m_propertyName;

    PropertyCellLabelProvider(IPropertyTableViewer<T> tableViewer, String propertyName) {
        assert (tableViewer != null) : "Parameter 'tableViewer' of method 'PropertyCellLabelProvider' must not be null";
        this.m_tableViewer = tableViewer;
        this.m_propertyName = propertyName;
    }

    public void update(ViewerCell cell) {
        Image columnImage;
        Image image;
        assert (cell != null) : "Parameter 'cell' of method 'update' must not be null";
        Object element = cell.getElement();
        int colIndex = cell.getColumnIndex();
        if (this.m_tableViewer.isTextualColumn(colIndex)) {
            cell.setText(this.m_tableViewer.getColumnText(element, this.m_propertyName));
        }
        if ((image = this.m_tableViewer.getCellImage(element, this.m_propertyName, columnImage = this.m_tableViewer.getColumnImage(element, colIndex))) == null) {
            image = this.m_tableViewer.getColumnImage(element, colIndex);
        }
        cell.setImage(image);
        Color color = this.m_tableViewer.getCellColor(element, this.m_propertyName);
        cell.setBackground(color);
        Color foreground = this.m_tableViewer.getForeground(element, this.m_propertyName);
        if (foreground != null) {
            cell.setForeground(foreground);
        }
    }

    public String getToolTipText(Object element) {
        return this.m_tableViewer.getTooltipText(element, this.m_propertyName);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }
}

